/* Libraries */
#include <gtk/gtk.h>
#include <gdk_imlib.h>
/* For lln_file */
#include <sys/types.h>
#include <sys/dir.h>
#include <time.h>
/* Common stuff */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <ctype.h>

#include <sys/stat.h> /* Added by Lalo Martins, Feb 27 1999: */

/* Widgets */
void 
lln_set_widget_font      (GtkWidget *widget);

void 
lln_pack_image_in_box    (GtkWidget *parent, 
			  GtkWidget *box,
			  gchar *xpm_filename);

GtkWidget*
lln_image_popup_new      (char *filename, 
			  char *title, 
			  char *label);

/* Window manipulation */

void close_my_window     (GtkWidget *widget,  //Closes the parent 
			  GtkWidget *window); //Window of a button

int close_window         (GtkWidget *widget,  //Close the window in
			  GdkEvent *event,    //response from window 
			  GtkWidget *window );//manager event

int close_window_onclick (GtkWidget *widget,  
			  GdkEventButton *event,
			  GtkWidget *window );

void lln_show_letter     (GtkWidget *widget,  //Display a letter 
			  gpointer *data);

void lln_show_number     (GtkWidget *widget, 
			  gpointer *data);

/* Utility event handling */

int
retransmit_press (GtkWidget * widget,
                  GdkEventButton * event,
                  gpointer * data);

int
retransmit_release (GtkWidget * widget,
                    GdkEventButton * event,
                    gpointer * data);

int
get_keystroke (GtkWidget * widget, 
	       GdkEventKey * event, 
	       gpointer * data);

/* String Parsing */

char lln_get_1st_letter  (char *filename);

char *lln_get_word (char *filename);

char *lln_get_number (char *filename);

char *lln_get_file (char letter);

int lln_get_random(double max);

/* Multiple language support - by Lalo Martins, Feb 27 1999 */

extern char * lln_image_dir;

/* Internationalization support - by Jan-Philip Velders, Mar 6 1999 */
#define _(x) (x)
//#include <libintl.h>
//Disabled gettext until I get it to work with Automake & Autoconf.
