/*	$Id: ncurses_misc.c,v 1.19 1997/10/30 18:29:46 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "zile.h"
#include "extern.h"
#include "term_ncurses.h"

int
ncurses_init(void)
{
	initscr();

	ncurses_tp->width = COLS;
	ncurses_tp->height = LINES;

	return TRUE;
}

static void
init_colors(void)
{
#if 0
	int i = 0, fg, bg;
	for (fg = COLORS - 1; fg >= 0; --fg)
		for (bg = 0; bg < COLORS; ++bg) {
			if (i != 0)
				init_pair(i, fg, bg);
			++i;
		}
#endif
	int fg;
	for (fg = 0; fg < COLORS; ++fg)
		init_pair(fg, fg, COLOR_BLACK);
}

int
ncurses_open(void)
{
	int colors = lookup_bool_variable("colors") && has_colors();

	if (colors)
		start_color();
	noecho();
	nonl();
	raw();
	intrflush(stdscr, FALSE);
	keypad(stdscr, TRUE);
	if (colors)
		init_colors();

	return TRUE;
}

int
ncurses_close(void)
{
	endwin();

	return TRUE;
}

void
ncurses_refresh(void)
{
	refresh();
}

void
ncurses_show_about(char *text[], char *minibuf, char *waitstr)
{
	int i, bold = 0;
	char **pp, *p;

	for (i = 0; i < LINES - 2; ++i) {
		move(i, 0);
		clrtoeol();
	}

	for (i = 0, pp = text; *pp != NULL; ++i, ++pp) {
		move(i, 0);
		for (p = *pp; *p != '\0'; ++p)
			if (*p == '%') {
				if (bold)
					attrset(0), bold = 0;
				else
					attrset(A_BOLD), bold = 1;
			} else
				addch(*p);
	}

	if (waitstr != NULL)
		mvaddstr(LINES - 4, (COLS - strlen(waitstr)) / 2, waitstr);

	minibuf_write(minibuf);
}

void
ncurses_clear(void)
{
	erase();
}

void
ncurses_beep(void)
{
	beep();
}
