%% SKK (Simple Kana to Kanji conversion program)
%% version 8.6 of May 17, 1995
%% Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995
%% Masahiko Sato (masahiko@sato.riec.tohoku.ac.jp)

%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either versions 2, or (at your option)
%% any later version.

%% This program is distributed in the hope that it will be useful
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.

%% You should have received a copy of the GNU General Public License
%% along with SKK, see the file COPYING.  If not, write to the Free
%% Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


%% Jed version 0.52d of May 8, 1998
%% Chikanobu Toyofuku (toyofuku@juice.or.jp)

variable NS = Null_String;
variable minibuf = " <mini>";
variable minimap = "Mini_Map";

define skk_copy_keymap(map, orgmap)
{
   make_keymap(map);
   copy_keymap(map, orgmap);
}

define my_int(obj)
{
	variable n;

	n = int(obj);
	if (n < 0)
		n += 256;

	return n;
}

define my_create_array(type, n)
{
	switch (type)
	{ case 'i': return Integer_Type[n]; }
	{ case 's': return String_Type[n]; }
	{ error("my_create_array1: unexpected type"); }
}

define create_array1(type)
{
	variable n, array;

	n = ();
	!if (n)
		return NULL;

	array = my_create_array(type, n);
	while (n) {
		--n;
		array[n] = ();
	}
	return array;
}

define create_rev_array1(type)
{
	variable i, n, array;

	n = ();
	!if (n)
		return NULL;

	array = my_create_array(type, n);
	_for (0, n - 1, 1) {
		i = ();
		array[i] = ();
	}
	return array;
}

define arraylen(obj)
{
	variable dims, ndim, type;

	if (obj == NULL)
		return 0;

	(dims, ndim, type) = array_info(obj);

	return dims[0];
}

variable skk_map = NS;
variable skk_minibuff_map = "map000";
variable skk_abbrev_map;
variable skk_zenkaku_map;
variable skk_mode = 0;
variable skk_kakutei_key = "^J";
variable skk_roma_kana_a;
variable skk_roma_kana_i;
variable skk_roma_kana_u;
variable skk_roma_kana_e;
variable skk_roma_kana_o;
variable skk_char_type_vec;
variable skk_kana_rom_vector;
variable skk_zenkaku_vector;
variable skk_rule;
variable skk_rule_num = 0;
variable skk_prefix_list = "by ch cy dh dy fy gy hy jy ky my ny py ry sh sy th ts ty xk xt xts xw xy zy";
variable skk_echo = 1;
variable skk_use_vip = 0;
variable skk_delete_implies_kakutei = 0;
variable skk_keep_record = 0;
variable skk_record_file = ".skk_record";
variable skk_isearch_message = NS;
variable skk_input_vector;
%(defvar skk-init-file (if (eq system-type 'ms-dos) "~/_skk" "~/.skk")
%  "*The name of the skk initialization file.")
variable skk_init_file = "~/.skkrc";
%(defconst skk-jisyo (if (eq system-type 'ms-dos) "~/_skk-jisyo" "~/.skk-jisyo")
%  "*The name of the skk jisyo file.")
variable skk_jisyo = "~/.skk-jisyo";
variable skk_aux_large_jisyo = NS;
variable skk_kakutei_jisyo = NS;
variable skk_initial_search_jisyo = NS;
variable skk_large_jisyo = NS;
%(defconst skk-backup-jisyo
%  (if (eq system-type 'ms-dos) "~/_skk-jisyo.BAK" "~/.skk-jisyo.BAK")
%  "*The name of the skk backup jisyo file.")
variable skk_backup_jisyo = "~/.skk-jisyo.BAK";
variable skk_jisyo_code = 1; % EUC
variable skk_mode_string = "--SKK:";
variable skk_hirakana_mode_string = "--";
variable skk_katakana_mode_string = "--";
variable skk_zenei_mode_string = "--";
variable skk_kakutei_early = 1;
variable skk_process_okuri_early = 0;
variable skk_auto_okuri_process = 0;
variable skk_delete_okuri_when_quit = 0;
variable skk_use_numeric_conversion = 1;
variable skk_mule = 0;
variable skk_egg_like_newline = 0;
variable skk_dabbrev_like_completion = 1;
variable skk_always_henkan_on = 0;
variable skk_report_server_response = 0;
variable skkserv_pid = -1;
variable skk_date_ad = 0;
variable skk_zenkaku_alist = "   ! \" # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ { | } ~ ))";
variable skk_number_style = 1; % 0: ascii, 1: zenkaku, 2: kanji
variable  num2zen = "";
variable  num2kan = "󻰻͸ϻȬ";

%%% skk_num_type_list

	$0 = _stkdepth();

.	"identify"
.	"j_zenkaku_num_str"
.	"j_kanji_num_str"
.	"j_kanji_num_str2"
.	"identify"
.	"identify"
.	"identify"
.	"identify"
.	"identify"
.	"j_shogi_num_str"

	(_stkdepth() - $0);

variable skk_num_type_list = create_array1('s');

variable skk_server_host = getenv("SKKSERVER");
	if (skk_server_host == NULL)
		skk_server_host = NS;
variable skk_serv = getenv("SKKSERV");
	if (skk_serv == NULL)
		skk_serv = NS;
variable skk_portnum = NS;
variable j_remote_shell_program = "/usr/ucb/rsh";

%%% skk_server_list 

	$0 = _stkdepth();

% for example
%.	"host1"	"server1"
%.	"host2"	"server2"

	(_stkdepth() - $0);

variable skk_server_list = create_rev_array1('s');

%%% skk_search_prog_list

	$0 = _stkdepth();

.	"j_search_kakutei_jisyo_file(skk_kakutei_jisyo, 20, 1)"
.	"j_search_jisyo_file(skk_initial_search_jisyo, 20, 1)"
.	"j_search_jisyo_file(skk_jisyo, 0, 1)"
.	"j_okuri_search()"
.	"j_search_jisyo_file(skk_large_jisyo, 20, 1)"
.	"j_search_server(skk_aux_large_jisyo, 20, 0)"

	(_stkdepth() - $0);

variable skk_search_prog_list = create_rev_array1('s');

variable j_skk_mode_invoked = 0;
variable j_prefix = NS;
variable j_katakana = 0;
variable j_okurigana = 0;
variable j_kana_start_point;
variable j_kakutei_early = 1;
variable j_henkan_active;	% 
variable j_henkan_on;		% 
variable j_henkan_start_point;
variable j_henkan_end_point;
variable j_okurigana_start_point;
variable p;
variable q;
variable j_henkan_vector;
variable j_henkan_vector_num = 0;
variable j_henkan_count = 0;
variable j_henkan_key = NS;
variable j_henkan_key2 = NS;
variable j_henkan_okurigana = NS;
variable j_search_key = NS;
variable j_kakutei_key = NS;
variable j_mode = 0;
variable j_okuri_ari = 0;
variable j_okuri_char = NS;
variable j_okuri_index_min = 0;
variable j_okuri_index_max = 0;
variable j_kanji_len = strlen("");
variable j_count_kakutei = 0;
variable j_count_touroku = 0;
variable j_abbrev = 0;
variable j_num_list = NS;
variable j_num_list_num = 0;
variable j_okuri_ari_min;
variable j_okuri_ari_max;
variable j_okuri_nasi_min;
variable j_henkan_show_candidates_keys = "asdfjkl";
variable j_search_prog_num;
variable j_henkan_okuri_strictly = 0;
variable j_zenkaku = 0;
variable j_emacs_local_map = NS;
variable j_current_local_map = NS;
variable j_mode_line_skk;
variable j_mode_line_format;
variable j_completion_word;
variable j_jisyo_buffer_modified = 0;
variable mini_local_map = "mini_local_map";
%variable mini_local_completion_map = "mini_local_completion_map";
%variable mini_local_ns_map = "mini_local_ns_map ";
variable hook_trigger_map = "HookTriggerMap";

variable skk_kana_start_in_mini;
variable skk_henkan_start_in_mini;
variable skk_henkan_end_in_mini;
variable skk_str_in_mini;
variable skk_recursive_in_mini;

variable s_j_set_henkan_point = "j_set_henkan_point";
variable s_j_self_insert2 = "j_self_insert2";
variable s_j_kana_input = "j_kana_input";

variable okuri_ari;
variable okurigana;

variable overwrite_mode = 0; % ???
variable zen0 = "";
variable zen9 = "";

variable previous_char_cmd_keystr = "\002";

variable new_word, found, kakutei;
variable quit;

%% type of rule
variable Nil_type = "0";
variable Next_type = "1";
variable End_type = "2";
variable Function_type = "3";

variable J_PREFIX_MAX = 43;
variable JED_USER_MARK_TYPE = 128;
variable SKK_BUF_MAX = 10;
variable SKK_JISYO_BUF_MAX = 5;

variable skk_buf_tbl = Integer_Type[SKK_BUF_MAX];
_for (0, SKK_BUF_MAX - 1, 1) {
	$0 = ();
	skk_buf_tbl[$0] = 0;
}
variable skk_prev_buf_id = -1;

variable skk_jisyo_buf_tbl = Integer_Type[SKK_JISYO_BUF_MAX];
_for (0, SKK_JISYO_BUF_MAX - 1, 1) {
	$0 = ();
	skk_jisyo_buf_tbl[$0] = 0;
}
variable skk_jisyo_buf_num = 0;
variable skk_jisyo_prev_buf_id = -1;

% 0 skk_mode;
% 1 j_katakana;
% 2 j_okurigana;
% 3 j_henkan_active;
% 4 j_henkan_on;
% 5 j_henkan_vector_num;
% 6 j_henkan_count;
% 7 j_mode;
% 8 j_okuri_ari;
% 9 j_okuri_index_min;
%10 j_okuri_index_max;
%11 j_count_kakutei;
%12 j_num_list_num;
%13 j_zenkaku;
%14 j_abbrev;

variable skk_int_tbl = Integer_Type[SKK_BUF_MAX, 20];

% 0 j_prefix;
% 1 j_kakutei_key;
% 2 j_henkan_key;
% 3 j_henkan_key2;
% 4 j_henkan_okurigana;
% 5 j_search_key;
% 6 j_okuri_char;
% 7 j_num_list;
% 8 j_mode_line_skk;
% 9 j_mode_line_format;
%10 j_completion_word;
%11 skk_map;
%12 skk_abbrev_map;
%13 skk_zenkaku_map;
%14 j_emacs_local_map;
%15 j_current_local_map;
%16 j_henkan_vector;

variable skk_string_tbl = String_Type[SKK_BUF_MAX, 20];

% 0 j_kana_start_point;
% 1 j_henkan_start_point;
% 2 j_henkan_end_point;
% 3 j_okurigana_start_point;
% 4 p;
% 5 q;

variable skk_mark_tbl = Mark_Type[SKK_BUF_MAX, 10];

% 0 j_okuri_ari_min;
% 1 j_okuri_ari_max;
% 2 j_okuri_nasi_min;

variable skk_jisyo_mark_tbl = Mark_Type[SKK_JISYO_BUF_MAX, 3];

define j_henkan ();
define j_kakutei ();
define j_search ();
define j_keyboard_quit ();

define j_in_minibuffer()
{
	return not(strcmp(whatbuf(), minibuf));
}

variable skk_buf_seqno = 1;
variable skk_jisyo_buf_seqno = 0;
variable skk_minibuffer_depth = 1;

define get_skk_buf_id ()
{
	variable id;

	if (j_in_minibuffer()) {
		return (- skk_minibuffer_depth);
	}

	ERROR_BLOCK
	{
		_clear_error();
		++skk_buf_seqno;
		define_blocal_var("skk_buf_id", 'i', skk_buf_seqno);
		return skk_buf_seqno;
	}

	id = get_blocal_var("skk_buf_id");

	return id;
}

define skk_gc ()
{
	variable n, b, id, cur;

	n = buffer_list();
	loop (n) {
		b = ();
		!if (my_int(b))
			continue;
		id = get_skk_buf_id ();
		_for (0, SKK_BUF_MAX - 1, 1) {
			cur = ();
			if (skk_buf_tbl[cur] == id) {
				skk_buf_tbl[cur] = - id;
				break;
			}
		}
	}
	_for (0, SKK_BUF_MAX - 1, 1) {
		cur = ();
		id = skk_buf_tbl[cur];
		if (id > 0) {
			skk_buf_tbl[cur] = 0;
		} else if (id < 0) {
			skk_buf_tbl[cur] = - id;
		}
	}
}

define set_buffer_local ()
{
	variable id, cur, pre, new_skk_buf;

	id = get_skk_buf_id();

	for (cur = 0; cur < SKK_BUF_MAX; ++cur) {
		if (skk_buf_tbl[cur] == id)
			break;
	}
	if (cur >= SKK_BUF_MAX) {
		for (cur = 0; cur < SKK_BUF_MAX; ++cur) {
			if (skk_buf_tbl[cur] == 0)
				break;
		}
		if (cur >= SKK_BUF_MAX) {
			% error
		}
	}

	pre = skk_prev_buf_id;
	skk_prev_buf_id = cur;

	if (pre == cur)
		return;

	if (skk_buf_tbl[cur]) {
		new_skk_buf = 0;
	} else {
		% new skk buffer
		new_skk_buf = 1;
		skk_buf_tbl[cur] = id;
	}

	if (pre >= 0) {
	  	if (andelse {skk_buf_tbl[pre] < 0} {skk_buf_tbl[pre] < skk_buf_tbl[cur]}) {
	  		skk_buf_tbl[pre] = 0;
		} else {
			% save previous variables

			skk_int_tbl[pre, 0] = skk_mode;
			skk_int_tbl[pre, 1] = j_katakana;
			skk_int_tbl[pre, 2] = j_okurigana;
			skk_int_tbl[pre, 3] = j_henkan_active;
			skk_int_tbl[pre, 4] = j_henkan_on;
			skk_int_tbl[pre, 5] = j_henkan_vector_num;
			skk_int_tbl[pre, 6] = j_henkan_count;
			skk_int_tbl[pre, 7] = j_mode;
			skk_int_tbl[pre, 8] = j_okuri_ari;
			skk_int_tbl[pre, 9] = j_okuri_index_min;
			skk_int_tbl[pre, 10] = j_okuri_index_max;
			skk_int_tbl[pre, 11] = j_count_kakutei;
			skk_int_tbl[pre, 12] = j_num_list_num;
			skk_int_tbl[pre, 13] = j_zenkaku;
			skk_int_tbl[pre, 14] = j_abbrev;

			skk_string_tbl[pre, 0] = j_prefix;
			skk_string_tbl[pre, 1] = j_kakutei_key;
			skk_string_tbl[pre, 2] = j_henkan_key;
			skk_string_tbl[pre, 3] = j_henkan_key2;
			skk_string_tbl[pre, 4] = j_henkan_okurigana;
			skk_string_tbl[pre, 5] = j_search_key;
			skk_string_tbl[pre, 6] = j_okuri_char;
			skk_string_tbl[pre, 7] = j_num_list;
			skk_string_tbl[pre, 8] = j_mode_line_skk;
			skk_string_tbl[pre, 9] = j_mode_line_format;
			skk_string_tbl[pre, 10] = j_completion_word;
			skk_string_tbl[pre, 11] = skk_map;
			skk_string_tbl[pre, 12] = skk_abbrev_map;
			skk_string_tbl[pre, 13] = skk_zenkaku_map;
			skk_string_tbl[pre, 14] = j_emacs_local_map;
			skk_string_tbl[pre, 15] = j_current_local_map;
			skk_string_tbl[pre, 16] = j_henkan_vector;


			skk_mark_tbl[pre, 0] = j_kana_start_point;
			skk_mark_tbl[pre, 1] = j_henkan_start_point;
			skk_mark_tbl[pre, 2] = j_henkan_end_point;
			skk_mark_tbl[pre, 3] = j_okurigana_start_point;
			skk_mark_tbl[pre, 4] = p;
			skk_mark_tbl[pre, 5] = q;
		}
	}

	if (new_skk_buf) { % new skk buffer

		% initialize variables

		skk_mode		= 0;
		j_katakana		= 0;
		j_okurigana		= 0;
		j_henkan_active		= 0;
		j_henkan_on		= 0;
		j_henkan_vector_num	= 0;
		j_henkan_count		= 0;
		j_mode			= 0;
		j_okuri_ari		= 0;
		j_okuri_index_min	= 0;
		j_okuri_index_max	= 0;
		j_count_kakutei		= 0;
		j_num_list_num		= 0;
		j_zenkaku		= 0;
		j_abbrev		= 0;

		j_prefix		= NS;
		j_kakutei_key		= NS;
		j_henkan_key		= NS;
		j_henkan_key2		= NS;
		j_henkan_okurigana	= NS;
		j_search_key		= NS;
		j_okuri_char		= NS;
		j_num_list		= NS;
		j_mode_line_skk		= NS;
		j_mode_line_format	= NS;
		j_completion_word	= NS;
		skk_map			= Sprintf("map1%02d", cur, 1);
		skk_abbrev_map		= Sprintf("map2%02d", cur, 1);
		skk_zenkaku_map		= Sprintf("map3%02d", cur, 1);
		j_emacs_local_map	= Sprintf("map4%02d", cur, 1);
		j_current_local_map	= Sprintf("map5%02d", cur, 1);
		j_henkan_vector		= NS;

		j_kana_start_point = create_user_mark();
		j_henkan_start_point = create_user_mark();
		j_henkan_end_point = create_user_mark();
		j_okurigana_start_point = create_user_mark();
		p = create_user_mark();
		q = create_user_mark();
	} else {
		% load current variables

		skk_mode		= skk_int_tbl[cur, 0];
		j_katakana		= skk_int_tbl[cur, 1];
		j_okurigana		= skk_int_tbl[cur, 2];
		j_henkan_active		= skk_int_tbl[cur, 3];
		j_henkan_on		= skk_int_tbl[cur, 4];
		j_henkan_vector_num	= skk_int_tbl[cur, 5];
		j_henkan_count		= skk_int_tbl[cur, 6];
		j_mode			= skk_int_tbl[cur, 7];
		j_okuri_ari		= skk_int_tbl[cur, 8];
		j_okuri_index_min	= skk_int_tbl[cur, 9];
		j_okuri_index_max	= skk_int_tbl[cur, 10];
		j_count_kakutei		= skk_int_tbl[cur, 11];
		j_num_list_num		= skk_int_tbl[cur, 12];
		j_zenkaku		= skk_int_tbl[cur, 13];
		j_abbrev		= skk_int_tbl[cur, 14];

		j_prefix		= skk_string_tbl[cur, 0];
		j_kakutei_key		= skk_string_tbl[cur, 1];
		j_henkan_key		= skk_string_tbl[cur, 2];
		j_henkan_key2		= skk_string_tbl[cur, 3];
		j_henkan_okurigana	= skk_string_tbl[cur, 4];
		j_search_key		= skk_string_tbl[cur, 5];
		j_okuri_char		= skk_string_tbl[cur, 6];
		j_num_list		= skk_string_tbl[cur, 7];
		j_mode_line_skk		= skk_string_tbl[cur, 8];
		j_mode_line_format	= skk_string_tbl[cur, 9];
		j_completion_word	= skk_string_tbl[cur, 10];
		skk_map			= skk_string_tbl[cur, 11];
		skk_abbrev_map		= skk_string_tbl[cur, 12];
		skk_zenkaku_map		= skk_string_tbl[cur, 13];
		j_emacs_local_map	= skk_string_tbl[cur, 14];
		j_current_local_map	= skk_string_tbl[cur, 15];
		j_henkan_vector		= skk_string_tbl[cur, 16];

		j_kana_start_point	= skk_mark_tbl[cur, 0];
		j_henkan_start_point	= skk_mark_tbl[cur, 1];
		j_henkan_end_point	= skk_mark_tbl[cur, 2];
		j_okurigana_start_point	= skk_mark_tbl[cur, 3];
		p			= skk_mark_tbl[cur, 4];
		q			= skk_mark_tbl[cur, 5];
	}
}

define get_skk_jisyo_buf_id ()
{
	variable id;

	ERROR_BLOCK
	{
		_clear_error();
		++skk_jisyo_buf_seqno;
		define_blocal_var("skk_jisyo_buf_id", 'i', skk_jisyo_buf_seqno);
		return skk_jisyo_buf_seqno;
	}

	id = get_blocal_var("skk_jisyo_buf_id");

	return id;
}

define set_jisyo_buffer_local ()
{
	variable id, cur, pre;

	id = get_skk_jisyo_buf_id();

	for (cur = 0; cur < SKK_JISYO_BUF_MAX; ++cur) {
		if (skk_jisyo_buf_tbl[cur] == id)
			break;
	}
	if (cur >= SKK_JISYO_BUF_MAX) {
		for (cur = 0; cur < SKK_JISYO_BUF_MAX; ++cur) {
			if (skk_jisyo_buf_tbl[cur] == 0)
				break;
		}
		if (cur >= SKK_JISYO_BUF_MAX) {
			% error
		}
	}


	pre = skk_jisyo_prev_buf_id;
	skk_jisyo_prev_buf_id = cur;

	if (pre == cur)
		return 0;

	if (pre >= 0) {
		% save previous variables

		skk_jisyo_mark_tbl[pre, 0] = j_okuri_ari_min;
		skk_jisyo_mark_tbl[pre, 1] = j_okuri_ari_max;
		skk_jisyo_mark_tbl[pre, 2] = j_okuri_nasi_min;
	}

	if (skk_jisyo_buf_tbl[cur] == 0) {
		% new skk jisyo buffer

		skk_jisyo_buf_tbl[cur] = id;

		% initialize variables

		j_okuri_ari_min = create_user_mark();
		j_okuri_ari_max = create_user_mark();
		j_okuri_nasi_min = create_user_mark();

		return 1;
	} else {
		% load current variables

		j_okuri_ari_min = skk_jisyo_mark_tbl[cur, 0];
		j_okuri_ari_max = skk_jisyo_mark_tbl[cur, 1];
		j_okuri_nasi_min = skk_jisyo_mark_tbl[cur, 2];

		return 0;
	}
}

define j_define_skk_map (map, minibuff)
{
	%%  "Setup skk key bindings for the keymap MAP.  If the optional argument
	%% MINIBUFF is t, the map is used in the minibuffer."

	definekey("j_keyboard_quit2",	"^G", map);
	definekey("j_keyboard_quit2",	"^?", map);
	%definekey("j_kakutei2",
	%	(if (minibuff) defualt_value(skk_kakutei_key); else skk_kakutei_key),
	%	map);
	definekey("j_kakutei2", skk_kakutei_key, map);
	definekey("j_newline",	"^M", map);
	definekey("j_try_completion2",	"\t", map);

	definekey("j_start_henkan",	" ", map);

	definekey("j_delete_backward_char",	"\177", map);

	definekey(s_j_set_henkan_point,	"A", map);
	definekey(s_j_set_henkan_point,	"B", map);
	definekey(s_j_set_henkan_point,	"C", map);
	definekey(s_j_set_henkan_point,	"D", map);
	definekey(s_j_set_henkan_point,	"E", map);
	definekey(s_j_set_henkan_point,	"F", map);
	definekey(s_j_set_henkan_point,	"G", map);
	definekey(s_j_set_henkan_point,	"H", map);
	definekey(s_j_set_henkan_point,	"I", map);
	definekey(s_j_set_henkan_point,	"J", map);
	definekey(s_j_set_henkan_point,	"K", map);
	definekey("j_zenkaku_eiji",	"L", map);
	definekey(s_j_set_henkan_point,	"M", map);
	definekey(s_j_set_henkan_point,	"N", map);
	definekey(s_j_set_henkan_point,	"O", map);
	definekey(s_j_set_henkan_point,	"P", map);
	definekey("j_set_henkan_point_subr",	"Q", map);
	definekey(s_j_set_henkan_point,	"R", map);
	definekey(s_j_set_henkan_point,	"S", map);
	definekey(s_j_set_henkan_point,	"T", map);
	definekey(s_j_set_henkan_point,	"U", map);
	definekey(s_j_set_henkan_point,	"V", map);
	definekey(s_j_set_henkan_point,	"W", map);
	definekey("j_purge_from_jisyo",	"X", map);
	definekey(s_j_set_henkan_point,	"Y", map);
	definekey(s_j_set_henkan_point,	"Z", map);

	definekey("j_insert_a",		"a", map);
	definekey(s_j_kana_input,	"b", map);
	definekey(s_j_kana_input,	"c", map);
	definekey(s_j_kana_input,	"d", map);
	definekey("j_insert_e",		"e", map);
	definekey(s_j_kana_input,	"f", map);
	definekey(s_j_kana_input,	"g", map);
	definekey(s_j_kana_input,	"h", map);
	definekey("j_insert_i",		"i", map);
	definekey(s_j_kana_input,	"j", map);
	definekey(s_j_kana_input,	"k", map);
	if (minibuff) "j_mode_off_in_minibuff"; else "j_mode_off";
	$1 = ();
	definekey($1, "l", map);
	definekey(s_j_kana_input,	"m", map);
	definekey(s_j_kana_input,	"n", map);
	definekey("j_insert_o",		"o", map);
	definekey(s_j_kana_input,	"p", map);
	definekey("j_toggle_kana",	"q", map);
	definekey(s_j_kana_input,	"r", map);
	definekey(s_j_kana_input,	"s", map);
	definekey(s_j_kana_input,	"t", map);
	definekey("j_insert_u",		"u", map);
	definekey(s_j_kana_input,	"v", map);
	definekey(s_j_kana_input,	"w", map);
	definekey("j_previous_candidate",	"x", map);
	definekey(s_j_kana_input,	"y", map);
	definekey(s_j_kana_input,	"z", map);

	definekey(s_j_self_insert2,	"?", map);
	definekey(s_j_self_insert2,	"!", map);
	definekey(s_j_self_insert2,	"\"", map);
	definekey(s_j_self_insert2,	"#", map);
	definekey(s_j_self_insert2,	"%", map);
	definekey(s_j_self_insert2,	"&", map);
	definekey(s_j_self_insert2,	"'", map);
	definekey(s_j_self_insert2,	"\(", map);
	definekey(s_j_self_insert2,	"\)", map);
	definekey(s_j_self_insert2,	"*", map);
	definekey(s_j_self_insert2,	"+", map);
	definekey(s_j_self_insert2,	"-", map);
	definekey(s_j_self_insert2,	"0", map);
	definekey(s_j_self_insert2,	"1", map);
	definekey(s_j_self_insert2,	"2", map);
	definekey(s_j_self_insert2,	"3", map);
	definekey(s_j_self_insert2,	"4", map);
	definekey(s_j_self_insert2,	"5", map);
	definekey(s_j_self_insert2,	"6", map);
	definekey(s_j_self_insert2,	"7", map);
	definekey(s_j_self_insert2,	"8", map);
	definekey(s_j_self_insert2,	"9", map);
	definekey(s_j_self_insert2,	":", map);
	definekey(s_j_self_insert2,	";", map);
	definekey(s_j_self_insert2,	"=", map);
	definekey(s_j_self_insert2,	"\[", map);
	definekey(s_j_self_insert2,	"\]", map);
	definekey(s_j_self_insert2,	"^", map);
	definekey(s_j_self_insert2,	"_", map);
	definekey(s_j_self_insert2,	"`", map);
	definekey(s_j_self_insert2,	"\{", map);
	definekey(s_j_self_insert2,	"|", map);
	definekey(s_j_self_insert2,	"\}", map);
	definekey(s_j_self_insert2,	"~", map);

	definekey("j_insert_period",	".", map);
	definekey("j_insert_comma",	",", map);
	definekey("j_abbrev_input",	"/", map);
	definekey("j_today",		"@", map);

	definekey("j_katakana_henkan",	"\ek", map);
	definekey("j_hiragana_henkan",	"\eh", map);
	definekey("j_zenkaku_henkan",	"\ez", map);
}

define j_setup_skk_map ()
{
	% (setq skk-map (j-convert-to-vector j-emacs-local-map))
	skk_copy_keymap(skk_map, j_emacs_local_map);
	j_define_skk_map(skk_map, 0);
}

define j_setup_skk_minibuff_map ()
{
	% (setq skk-minibuff-map (j-convert-to-vector minibuffer-local-map))
	skk_copy_keymap(skk_minibuff_map, mini_local_map);
	j_define_skk_map(skk_minibuff_map, 1);
}

define j_int(s)
{
	if (iskanji(s[0])) {
		return s[0] * 0x100 + s[1];
	} else {
		return s[0];
	}
}

define ishira(ch)
{
	return andelse {ch >= 0x829f} {ch <= 0x82f1};
}

define iskata(ch)
{
	return andelse {ch >= 0x8340} {ch <= 0x8393} {ch != 0x837f};
}

define what_point()
{
	return POINT;
}

define goto_point(n)
{
	bol();
	go_right(n);
}

define mark_eq(mark1, mark2)
{
	variable l1, l2, c1, c2;

	push_spot();
	goto_user_mark(mark1);
	l1 = what_line();
	c1 = what_point();
	goto_user_mark(mark2);
	l2 = what_line();
	c2 = what_point();
	pop_spot();

	return (andelse {l1 == l2} {c1 == c2});
}

define spot_eq(user_mark, n)
{
	variable l1, l2, c1, c2;

	push_spot();
	if (n > 0)
		go_right(n);
	else if (n < 0)
		go_left(- n);
	l1 = what_line();
	c1 = what_point();
	goto_user_mark(user_mark);
	l2 = what_line();
	c2 = what_point();
	pop_spot();

	return (andelse {l1 == l2} {c1 == c2});
}

define spot_gt(user_mark, n)
{
	variable l1, l2, c1, c2;

	push_spot();
	if (n > 0)
		go_right(n);
	else if (n < 0)
		go_left(- n);
	l1 = what_line();
	c1 = what_point();
	goto_user_mark(user_mark);
	l2 = what_line();
	c2 = what_point();
	pop_spot();

	if (l1 > l2)
		return 1;
	else if (l1 < l2)
		return 0;

	% l1 == l2

	return (c1 > c2);
}

define spot_lt(user_mark, n)
{
	variable l1, l2, c1, c2;

	push_spot();
	if (n > 0)
		go_right(n);
	else if (n < 0)
		go_left(- n);
	l1 = what_line();
	c1 = what_point();
	goto_user_mark(user_mark);
	l2 = what_line();
	c2 = what_point();
	pop_spot();

	if (l1 < l2)
		return 1;
	else if (l1 > l2)
		return 0;

	% l1 == l2

	return (c1 < c2);
}

define use_local_map (map)
{
	use_keymap(map);
}

define current_local_map ()
{
	return what_keymap();
}

define j_setup_skk_zenkaku_map ()
{
	variable i;

	% (setq skk-zenkaku-map (j-convert-to-vector j-emacs-local-map))
	skk_copy_keymap(skk_zenkaku_map, j_emacs_local_map);

	definekey("j_kakutei2", skk_kakutei_key, skk_zenkaku_map);

	for (i = 0; i < 128; i++) {
		if (my_int(skk_zenkaku_vector[i]))
			definekey("j_zenkaku_insert", char(i), skk_zenkaku_map);
	}
}

define j_setup_skk_abbrev_map ()
{
	%(setq skk-abbrev-map (j-convert-to-vector j-emacs-local-map))
	skk_copy_keymap(skk_abbrev_map, j_emacs_local_map);

	definekey("j_keyboard_quit2",	"^G", skk_abbrev_map);
	definekey("j_keyboard_quit2",	"^?", skk_abbrev_map);
	definekey("j_kakutei2",	skk_kakutei_key, skk_abbrev_map);
	definekey("j_try_completion2",	"\t", skk_abbrev_map);
	definekey("j_newline",	"^M", skk_abbrev_map);
	definekey("j_zenkaku_henkan",	"^Q", skk_abbrev_map);
	definekey("j_abbrev_period",	".", skk_abbrev_map);
	definekey("j_abbrev_comma",	",", skk_abbrev_map);
	definekey("j_start_henkan",	" ", skk_abbrev_map);
	definekey("j_delete_backward_char",	"\177", skk_abbrev_map);
	definekey("j_zenkaku_henkan",	"\ez", skk_abbrev_map);
}

define abort_recursive_edit ()
{
	call("kbd_quit");
}

define keyboard_quit ()
{
	call("kbd_quit");
}

define file_exists_p (file)
{
	return (file_status(expand_filename(file)) > 0);
}

define  j_change_mode_line (str)
{
	j_mode_line_skk = str;
	set_status_line(strcat(j_mode_line_skk, j_mode_line_format), 0);
}

define j_create_file (file, msg)
{
	if (file_exists_p(file))
		return;

	flush(msg);
% Sorry, not implemeted yet
}

define get_file_buffer (file)
{
	variable buf;
	variable fname, b, dir;
	variable n;

	file = expand_filename(file);

	buf = NS;
	n = buffer_list();
	while (n) {
		b = ();
		--n;
		!if (my_int(b))
			continue;
		setbuf(b);
		(fname, dir,,) = getbuf_info();
		!if (strcmp(strcat(dir, fname), file)) {
			buf = b;
			break;
		}
	}
	while (n) {
		pop();
		--n;
	}

	return buf;
}

define j_get_file_buffer (file, nomsg)
{
	variable buf;
	variable fname, dir, bufname, flags, savebuf, first;

	push_spot(); savebuf = whatbuf();

	buf = get_file_buffer(file);

	ERROR_BLOCK
	{
		sw2buf(savebuf); pop_spot(); % save-excursion end
		return NS;
	}

	if (my_int(buf)) {
		sw2buf(buf);
	} else {
		file = expand_filename(file);
		fname = extract_filename(file);
		buf = Sprintf(" *%s*", fname, 1);
		sw2buf(buf);

		insert_file(file);
		!if (nomsg)
			vmessage("Inserting contents of %s ...done", fname, 1);
		set_buffer_modified_flag(0);
		bob();
		if (eobp()) {
		    %% if the file is empty, we make it a minimal well
		    %% formed skk jisyo
		    insert(";; okuri-ari entries.\n;; okuri-nasi entries.\n");
		}
		(,, bufname, flags) = getbuf_info();
		dir = substr(file, 1, strlen(file) - strlen(fname));
		flags = flags & ~(1);
		setbuf_info(fname, dir, bufname, flags);
	}

	first = set_jisyo_buffer_local();

	if (first) {
		bob();
		if (bol_fsearch(";; okuri-ari entries.\n")) {
			go_down_1();
			move_user_mark(j_okuri_ari_min);
			go_left_1();
			if (bol_fsearch(";; okuri-nasi entries.")) {
				move_user_mark(j_okuri_ari_max);
				go_down_1();
				move_user_mark(j_okuri_nasi_min);
			} else
				vmessage("%s is not well formeddd!", file, 1); % error() ?
		} else
			vmessage("%s is not well formed!", file, 1); % error() ?
	}

	sw2buf(savebuf); pop_spot();

	return buf;
}

variable skk_save_abort;

define skk0 (arg)
{
	variable map;

	set_buffer_local();

	if (my_int(j_mode_line_format)) {
		if (arg == 0)
			not(skk_mode);
		else if (arg > 0)
			1;
		else
			0;
	} else {
		%% if skk-mode has not been called in this buffer, always
		%% enter skk-mode
		1;
	}
	skk_mode = ();

	if (andelse {j_in_minibuffer()} {is_defined("vip_current_mode")}) {
	%	vip_read_string_hook =
	%		"definekey(\"j_kakutei\", skk_kakutei_key, mini_local_map);\
	%		definekey(\"j_newline\", \"^M\", mini_local_map)";
	}

	!if (skk_mode) {
		%% exit skk-mode
		if (skk_use_vip)
			eval("vip_change_mode_to_insert");
		skk_mode = 1;
		j_kakutei(NS);
		skk_mode = 0;
		set_status_line(j_mode_line_format, 0);
		use_local_map(j_current_local_map);
		set_buffer_modified_flag(buffer_modified());

		IGNORE_USER_ABORT = skk_save_abort;
		return;
	}

	skk_save_abort = IGNORE_USER_ABORT;
	IGNORE_USER_ABORT = 1;

	%% enter skk-mode

	!if (j_skk_mode_invoked) {
		%% enter skk-mode for the first time in this session
		j_skk_mode_invoked = 1;
		if (file_exists_p(skk_init_file))
			evalfile(skk_init_file);
		j_kakutei_early = andelse {skk_kakutei_early} {not(skk_process_okuri_early)};
		if (skk_keep_record)
			j_create_file(skk_record_file, "I have created an SKK record file for you.");
		!if (file_exists_p(skk_jisyo))
			j_create_file(skk_jisyo, "I have created an empty Jisyo file for you.");
		() = j_get_file_buffer(skk_jisyo, 1);
		j_jisyo_buffer_modified = 0;

		make_keymap(hook_trigger_map);

		if (skk_use_vip) {
			%% we should be able to use (require 'vip) eventually.
			!if (eval("vip_current_mode"))
				evalfile("vip");
			%% check vip's version.  this modification will not be
			%% necessary for vip4.x.
			!if (strcmp(eval("vip_version"), "VIP version 3.5 of September 15, 1987")) {
				message(NS);
				%(fset 'vip-change-mode 'vip-ch-mode)))))))
			}
		}
	}
	if (orelse {not(my_int(j_mode_line_format))} {j_in_minibuffer()}) {
		%% enter skk-mode for the first time in this buffer or the buffer
		%% is the minibuffer
		skk_copy_keymap(mini_local_map, minimap);
		%map = if (j_in_minibuffer()) mini_local_map; else current_local_map();
		if (j_in_minibuffer()) mini_local_map; else current_local_map();
		map = ();
		%% save current mode
		j_mode_line_format = Status_Line_String;
		%j_current_local_map = if (my_int(map)) copy_keymap(map); else NS;
		j_current_local_map = current_local_map();
		%j_emacs_local_map = if (my_int(map)) copy_keymap(map); else sparse_keymap();
		skk_copy_keymap(j_emacs_local_map, map);
		if (j_in_minibuffer()) {
			definekey("exit_mini", "^M", j_emacs_local_map);
		}
		definekey("j_kakutei2", skk_kakutei_key, j_emacs_local_map);
		j_setup_skk_map();
		j_setup_skk_zenkaku_map();
		j_setup_skk_abbrev_map();
		%run_hooks("skk_mode_hook");
	} else {
		if (andelse {skk_use_vip} {not(j_in_minibuffer())}) {
			skk_mode = 0;
			eval("vip_change_mode_to_insert");
			skk_mode = 1;
		}
	}

	j_mode = 1;
	j_katakana = 0;
	use_local_map(skk_map);

	%definekey("j_kakutei2", default_value(skk_kakutei_key), j_mini_local_map);
	definekey("j_kakutei2", skk_kakutei_key, mini_local_map);
%	definekey("j_newline", "^M", mini_local_map);
	%definekey("j_kakutei2", skk_kakutei_key, mini_local_completion_map);
	%definekey("j_newline", "^M", mini_local_completion_map);
	%definekey("j_kakutei2", skk_kakutei_key, mini_local_ns_map);
	%definekey("j_newline", "^M", mini_local_ns_map);
	j_change_mode_line(skk_hirakana_mode_string);
}

define skk ()
{
	skk0(0);
}

define j_erase_prefix ()
{
	variable n;

	if (skk_echo) {
		push_mark();
		goto_user_mark(j_kana_start_point);
		del_region();
	}
}

define j_insert_str (str)
{
	insert(str);
}

define j_num1 (c)
{
	!if (isdigit(char(c)))
		return NS;

	switch (skk_number_style)
	{ case (0): return char(c); }
	{ case (1): return substr(num2zen, 2*(c - '0') + 1, 2); }
	{ return substr(num2kan, 2*(c - '0') + 1, 2); }
}

define j_num (str)
{
	variable convstr, i;

	convstr = NS;
	for (i = 0; str[i]; i++)
		convstr = strcat(convstr, j_num1(str[i]));
	return convstr;
}

define identify (num)
{
	return num;
}

define j_zenkaku_num (c)
{
	!if (isdigit(char(c)))
		return NS;

	return substr(num2zen, 2*(c - '0') + 1, 2);
}

define j_kanji_num (c)
{
	!if (isdigit(char(c)))
		return NS;

	return substr(num2kan, 2*(c - '0') + 1, 2);
}

define j_zenkaku_num_str (num)
{
	variable convstr, i;

	convstr = NS;
	for (i = 0; num[i]; i++)
		convstr = strcat(convstr, j_zenkaku_num(num[i]));
	return convstr;
}

define j_kanji_num_str (num)
{
	variable convstr, i;

	convstr = NS;
	for (i = 0; num[i]; i++)
		convstr = strcat(convstr, j_kanji_num(num[i]));
	return convstr;
}

define j_kanji_num_str2_subr (); % definition required for recursion

define j_kanji_num_str2_subr (num, silent0, len)
{
	variable l, r, c, res;

	l = substr(num, 1, 1);
	c = my_int(l);
	if (len == 1) {
		if (c == '0')
			return NS;
		else
			return j_kanji_num(c);
	}
	r = substr(num, 2, len - 1);
	if (c != '0')
		silent0 = 0;

	res = len mod 4;

	% push format string for Sprintf

	"%s%s%s";

	% push 1st argument
	% a1 =
	if (orelse {c == '0'} {andelse {c == '1'} {res != 1}})
		NS;
	else
		j_kanji_num(c);

	% push 2nd argument
	% a2 =
	if (andelse {c == '0'} {orelse {silent0} {res != 1}}) {
		NS;
	} else {
		if (res == 2)
			"";
		else if (res == 3)
			"ɴ";
		else if (res == 0)
			"";
		else if (len == 5) {
			silent0 = 1;
			"";
		} else if (len == 9) {
			silent0 = 1;
			"";
		} else if (len == 13) {
			silent0 = 1;
			"";
		} else if (len == 17) {
			silent0 = 1;
			"";
		} else {
			message("Too big num!"); % error
			"??";
		}
	};

	% push 3rd argument
	% a3 =
	j_kanji_num_str2_subr(r, silent0, len - 1);

	return Sprintf(3); %  "%s%s%s", a1, a2, a3 ϤǤ push Ƥ
}

define j_kanji_num_str2 (num)
{
	variable str;

	str = j_kanji_num_str2_subr(num, 0, strlen(num));
	if (my_int(str))
		return str;
	else
		return "";
}

define j_shogi_num_str (num)
{
	return strcat(j_zenkaku_num(my_int(num)), j_kanji_num(num[1]));
}

define j_num_exp (num, type)
{
	!if (isdigit(char(type)))
		return num;

	num; % push argument;

	return eval(skk_num_type_list[type - '0']);
}

define j_numeric_convert (word)
{
	variable num, i, pos, newword, offset, len;

	!if (j_num_list_num)
		return word;

	newword = NS;
	pos = 1;
	for (i = 0; i < j_num_list_num; i++) {
		num = extract_element(j_num_list, i, ' ');
		if (num == NULL)
			num = NS;
		offset = string_match(word, "#", pos);
		!if (offset)
			break; % this case is bug
		--offset; % because offset is 1 origin
		newword = strcat(newword, substr(word, pos, offset));
		pos += offset;
		newword = strcat(newword, j_num_exp(num, word[pos]));
		++pos; ++pos; % skip #[0-9]
	}
	len = strlen(word);
	if (pos <= len) {
		newword = strcat(newword, substr(word, pos, len - pos + 1));
	}

	return newword;
}

define j_insert_word (word)
{
	if (andelse {skk_use_numeric_conversion} {j_num_list_num}) {
		word = j_numeric_convert(word);
	}
	%if (string-match "^(.*)$" word)
	if (my_int(word) == ' ') {
		ERROR_BLOCK
		{
			insert(word);
		}
		insert(eval(word));
	} else {
		insert(word);
	}
}

define j_emulate_original_map ()
{
	variable str, use_call, savemap;

	savemap = current_local_map();
	%use_local_map(j_emacs_local_map);
	if (j_in_minibuffer) mini_local_map; else j_emacs_local_map;
	$1 = ();
	use_local_map($1);
	ungetkey(LAST_CHAR);
	str = get_key_function();
	use_local_map(savemap);
	!if (my_int(str))
		return;

	use_call = ();
	if (use_call)
		call(str);
	else
		eval(str);
}

define j_do_auto_fill ()
{
% Sorry, not implemeted yet
}

define j_remove_common (word, henkan_key)
{
%   "remove trailing common kana ending parts both from midasi and word.
% For instance, (äƤ äƤ) -> key := \"t /\",
% okurigana := \"ä\", word := \"\""
	variable midasi, midasi_len, word_len, kanji_len2, chr, pos2, ascii;
	variable midasi_tail, word_tail, i, pos;
	variable new_word, new_j_henkan_key, okuri_first;
variable x, y, z;

	midasi = henkan_key;
	midasi_len = strlen(midasi);
	word_len = strlen(word);
	kanji_len2 = 2 * j_kanji_len;

	if (orelse {midasi_len < kanji_len2} {word_len < kanji_len2})
		return (word, henkan_key);

	%% check if both midasi and word end with the same ascii char.
	for (i = 0; i < midasi_len - 1; ) {
		if (iskanji(midasi[i])) {
			i += j_kanji_len;
		} else {
			++i;
		}
	}
	if (andelse {i < midasi_len}
			{midasi[midasi_len - 1] == word[word_len - 1]}) {
		%% if so chop off the char from midasi and word
		midasi = substr(midasi, 1, midasi_len - 1);
		--midasi_len;
		word = substr(word, 1, word_len - 1);
		--word_len;
	}

	midasi_tail = substr(midasi, midasi_len - j_kanji_len + 1, j_kanji_len); 
	word_tail = substr(word, word_len - j_kanji_len + 1, j_kanji_len); 
	if (orelse {strcmp(midasi_tail, word_tail)}
		{andelse {not(ishira(j_int(midasi_tail)))}
			{strcmp(midasi_tail, "")}
			{strcmp(midasi_tail, "")}
			{strcmp(midasi_tail, "")}
			{strcmp(midasi_tail, "")}}) {
		return (word, henkan_key);
	}

	pos = word_len - j_kanji_len;

	while (pos > 0) {
		chr = substr(word, pos - j_kanji_len + 1, j_kanji_len);
		%% char is the right_most Kanji
		%if (andelse {chr >= ""} {chr <= ""}) {
		%	break;
		%}
		!if (ishira(j_int(chr))) {
			break;
		}
		pos -= j_kanji_len;
	}

	pos2 = midasi_len - word_len + pos;
	%% check if midasi and word has the same tail of length
	%% (- word_len pos)
	if (strcmp(substr(midasi, pos2 + 1, -1), substr(word, pos + 1, -1))) {
		return (word, henkan_key);
	}

	okuri_first = substr(word, pos + 1, j_kanji_len);
	if (orelse {strcmp(okuri_first, "")}
			{pos + kanji_len2 > word_len}) {
		okuri_first;
	} else {
		%% in this case okuriga consits of two
		%% characters, e.g., ֻĤä
		substr(word, pos + 1, kanji_len2);
	}
	okurigana = ();

	new_word = substr(word, 1, pos);

	% push format string for Sprintf

	"%s%c";

	% push 1st argument
	% a1 =
	substr(midasi, 1, pos2);

	% push 2nd argument
	% a2 =
	switch (okuri_first)
	{ case (""): 'n'; }
	{ case (""): skk_kana_rom_vector[okurigana[kanji_len2 - 1] - 0x9f]; }
	{ skk_kana_rom_vector[okurigana[j_kanji_len - 1] - 0x9f]; }

	new_j_henkan_key = Sprintf(2); %  "%s%c", a1, a2 ϤǤ push Ƥ

	if (j_henkan_count > j_henkan_vector_num) {
		%% ask if register as okuri_ari word.
		%% allow keyboard quit
		%inhibit_quit = 0;
		if (get_yes_no(Sprintf("Shall I register this as okuri_ari entry: %s /%s/ ? ", new_j_henkan_key, new_word, 2)) > 0) {
			word = new_word;
			henkan_key = new_j_henkan_key;
		}
		message("");
		%inhibit_quit = ??? ;
	} else {
		word = new_word;
		henkan_key = new_j_henkan_key;
	}

	return (word, henkan_key);
}

define j_quote_char (w)
{
% Sorry, not implemeted yet
	return w;
}

define j_compute_henkan_vectors()
{
	variable stage = 1;
	variable item;
	variable v1, v2, v3, v4;
	variable l1, l2, l3, l4;

	%  Ѵ "" Ф
	% "k /¿//[/¿/]/[//¿/]/[/¿/]/"  stage
	%        <--1--><----2-----><--3--><----4---->

	push_mark();

	v1 = NS;
	v2 = NS;
	v3 = NS;
	v4 = NS;
	l1 = 0;
	l2 = 0;
	l3 = 0;
	l4 = 0;
	while (ffind("/")) {
		item = bufsubstr();

		if (not(okuri_ari)) {
			if (andelse {skk_process_okuri_early} {my_int(item) == '['}) {
				break;
			}
			v1 = Sprintf("%s%s/", v1, item, 2);
			l1++;
		} else if (andelse {my_int(item) == '['} {stage <= 2}) {
			% /[.../  stage 1  2

			if (strcmp(item, strcat("[", okurigana)) == 0) {
				stage = 3;
			} else {
				stage = 2;
			}
			% v2  "[<꤬>" ɲ
			v2 = Sprintf("%s%s/", v2, item, 2);
			l2++;
		} else if (andelse {my_int(item) == ']'} {stage == 3}) {
			% /]/  stage 3
			stage = 4;
			% v4  "]" ɲ
			v4 = Sprintf("%s%s/", v4, item, 2);
			l4++;
		} else if (stage == 1) {
			v1 = Sprintf("%s%s/", v1, item, 2);
			l1++;
		} else if (stage == 2) {
			v2 = Sprintf("%s%s/", v2, item, 2);
			l2++;
		} else if (stage == 3) {
			v3 = Sprintf("%s%s/", v3, item, 2);
			l3++;
		} else if (stage == 4) {
			v4 = Sprintf("%s%s/", v4, item, 2);
			l4++;
		}

		go_right_1(); % skip "/"

		push_mark();
	}
	pop_mark(0);

	return (v1, l1, v2, l2, v3, l3, v4, l4);
}

define j_update_jisyo (file, word, purge)
{
	variable buf, save_buf, vector1, vector2, vector3, vector4;
	variable len, count, okuri_ari, min, maxl, okurigana, key;
	variable entry_point, inhibit_quit, new_entry;
	variable chr, num;
	variable index, uniq, w, l1, l2, l3, l4;

	ERROR_BLOCK
	{
		sw2buf(save_buf); pop_spot(); % save excursion end
	}
	push_spot(); save_buf = whatbuf(); % save excursion

	buf = get_file_buffer(file);
	!if (my_int(buf)) {
		sw2buf(save_buf); pop_spot(); % save excursion end
		return;
	}

	count = j_henkan_count - 1;
	okurigana = j_henkan_okurigana;
	inhibit_quit = 1;
	new_entry = 1;

	%% we don't have to auto-process okuri if j-num-list is non-nil
	%% or the first character of j-henkan-key is an ascii character.
	if (andelse {skk_auto_okuri_process} {not(j_num_list_num)} {my_int(j_henkan_key) > 127}
		{orelse {j_henkan_count > j_henkan_vector_num}
			{andelse {j_okuri_index_min < j_henkan_count}
				{j_henkan_count <= j_okuri_index_max}}}) {
		(word, j_henkan_key) = j_remove_common(word, j_henkan_key);
	}
	%% we must re-compute okuri-ari, since j-henkan-key might have been
	%% changed by j-remove-common
	chr = j_henkan_key[strlen(j_henkan_key) - 1];
	okuri_ari = %% used in j-compute-henkan-vectors
		andelse {my_int(j_henkan_key) > 127} {'a' <= chr} {chr <= 'z'};

	if (okuri_ari) j_henkan_key; else j_search_key;
	$1 = ();
	key = strcat($1, " /");

	sw2buf(buf);

	() = set_jisyo_buffer_local();

	if (okuri_ari) j_okuri_ari_min; else j_okuri_nasi_min;
	min = ();
	if (okuri_ari) {
		goto_user_mark(j_okuri_ari_max);
	} else {
		eob();
	}
	maxl = what_line();
	push_mark();
	%% we have to backup one character so that we can find key correctly
	%% even if it is the first entry in the region bounded by min and max
	goto_user_mark(min);
	go_left_1();

	%% delete old entry
	narrow();
	if (bol_fsearch(key)) {
		go_right(strlen(key));
		(vector1, l1, vector2, l2, vector3, l3, vector4, l4) = j_compute_henkan_vectors();
		new_entry = 0;
		bol();
		push_mark();
		go_down_1();
		del_region();
	} else {
		vector1 = NS; vector2 = NS; vector3 = NS; vector4 = NS;
		l1 = 0; l2 = 0; l3 = 0; l4 = 0;
	}
	widen();

	%% insert new entry
	if (okuri_ari) {
		if (new_entry) {
			goto_user_mark(min);
			forever {
				if (what_line() >= maxl)
					break;
				bol();
				push_mark();
				() = ffind(" /");
				go_right(2); % 2 == strlen(" /");
				if (strcmp(key, bufsubstr()) >= 0)
					break;
				go_down_1();
			}
		}
	} else {
		goto_user_mark(min);
	}
	bol();

	entry_point = create_user_mark();

	insert(key);

	!if (purge) {
		if (andelse {not(new_entry)} {skk_use_numeric_conversion}
			{j_num_list_num} {count < l1}) {
			word = extract_element(vector1, count, '/');
			if (word != NULL)
				insert(word);
		} else {
			insert(j_quote_char(word));
		}
		insert("/");
	}

	for (index = 0; index < l1; index++) {
		w = extract_element(vector1, index, '/');
		if (w == NULL)
			w = NS;
		if (strcmp(word, w)) {
			insert(j_quote_char(w));
			insert("/");
		}
	}
	if (andelse {okuri_ari} {not(skk_process_okuri_early)}) {
		for (index = 0; index < l2; index++) {
			$1 = extract_element(vector2, index, '/');
			if ($1 != NULL)
				insert($1);
			insert("/");
		}
		if (l3) {
			!if (purge) {
				insert(word);
				insert("/");
			}
			for (index = 0; index < l3; index++) {
				w = extract_element(vector3, index, '/');
				if (w == NULL)
					w = NS;
				if (strcmp(word, w)) {
					insert(w);
					insert("/");
				}
			}
		} else {
			!if (purge) {
				insert("[");
				insert(okurigana);
				insert("/");
				insert(word);
				insert("/]/");
			}
		}
		if (l4) {
			push_spot();
			push_mark();
			() = bfind("/"); % (search-backward "/" nil nil 2)
			index = 0;
			if (looking_at("/[")) {
				go_right_1();
				del_region();
				index = 1;
			}
			pop_spot();

			for ( ; index < l4; index++) {
				$1 = extract_element(vector4, index, '/');
				if ($1 != NULL)
					insert($1);
				insert("/");
			}
		}
	}
	if (purge) {
		uniq = 1;
		for (index = 0; index < 12; index++) {
			$2 = extract_element(vector2, index, '/');
			if ($2 == NULL)
				$2 = NS:
			!if (strcmp(word, $2)) {
				uniq = 0;
				break;
			}
		}
		if (uniq) {
			for (index = 0; index < 14; index++) {
				$2 = extract_element(vector4, index, '/');
				if ($2 == NULL)
					$2 = NS:
				!if (strcmp(word, $2)) {
					uniq = 0;
					break;
				}
			}
		}
		if (uniq) {
			%% the WORD is not in vector2 nor in vector4, so purge it
			%% also from vector1 (if any)
			push_spot();
			goto_user_mark(entry_point);
			() = ffind(" ");
			if (ffind(Sprintf("/%s/", word, 1))) {
				go_right_1();
				push_mark();
				go_right(strlen(word) + 1);
				del_region();
			}
			pop_spot();
		}
	}
	insert("\n");
	up_1();
	bol();
	() = ffind(" /");
	go_right(2);
	if (eolp()) {
		%% the key has no words for it so delete everything
		bol();
		push_mark();
		go_down_1();
		del_region();
	}
	if (okuri_ari) {
		%% in this case, we need to reset j-okuri-ari-max and
		%% j-okuri-nasi-min
		goto_user_mark(min);
		() = bol_fsearch(";; okuri-nasi");
		bol();
		move_user_mark(j_okuri_ari_max);
		go_down_1();
		move_user_mark(j_okuri_nasi_min);
	}
	j_jisyo_buffer_modified = orelse {j_jisyo_buffer_modified} {buffer_modified()};
	set_buffer_modified_flag(0);

	sw2buf(save_buf); pop_spot(); % save excursion end
}

define j_kakutei (word)
{
	variable inhibit_quit;
	variable x;

	if (skk_mode) {
		if (j_katakana) skk_katakana_mode_string;
		else		skk_hirakana_mode_string;
		$1 = ();
		j_change_mode_line($1);
		if (j_in_minibuffer())
			use_keymap(skk_minibuff_map);
		else
			use_local_map(skk_map);
		++j_count_kakutei;
	} else {
		skk0(1);
	}
	if (j_henkan_on) {
		if (andelse {j_henkan_active} {j_henkan_count}) {
			if (my_int(word)) word; else extract_element(j_henkan_vector, j_henkan_count - 1, '/');
			$2 = ();
			if ($2 == NULL)
				$2 = NS;
			j_update_jisyo(skk_jisyo, $2, 0);
			++j_count_kakutei;
		}
		push_spot(); % save-excursion
		goto_user_mark(j_henkan_start_point);
		go_left(j_kanji_len);
		if (j_henkan_active) {
			if (looking_at("")) {
				deln(2);
			} else {
				%@@
			}
		} else {
			if (looking_at("")) {
				deln(2);
			} else {
				%@@
			}
		}
		if (j_okurigana) {
			goto_user_mark(j_okurigana_start_point);
			if (looking_at("*"))
				del();
			j_okurigana = 0;
		}
		pop_spot(); % save-excursion end
		%if (self_insert_after_hook)
		%	call ...
		%if (orelse {overwrite_mode} {boundp "vip_ovwrt_limit"})
		%	j_del_char_with_pad ...
		j_abbrev = 0;
	}
	j_henkan_active = 0;
	j_henkan_on = 0;
	j_okurigana = 0;
	j_okuri_char = NS;
	j_henkan_key = NS;
	j_henkan_key2 = NS;
	j_henkan_okurigana = NS;
	j_henkan_vector = NS;
	j_henkan_vector_num = 0;
	j_henkan_count = 0;
	j_search_key = NS;
	j_okuri_index_min = 0;
	j_okuri_index_max = 0;
	j_num_list = NS;
	j_num_list_num = 0;

	j_do_auto_fill();
}

define j_kakutei2 ()
{
	set_buffer_local();

	j_kakutei(NS);
}

define prefix_numeric_value ()
{
	return prefix_argument(1);
}

define j_self_insert ()
{
	variable str, count;

	str = skk_input_vector[LAST_CHAR];
	if (my_int(str)) {
		count = prefix_numeric_value();
		loop (count) {
			j_insert_str(str);
		}
	} else {
		j_emulate_original_map();
	}

	if (j_henkan_active) {
		j_kakutei(NS);
	}
}

define j_self_insert2 ()
{
	set_buffer_local();

	j_self_insert();
}

define j_zenkaku_insert ()
{
	variable count, str, len;

	%count = ???;
	count = 1;
	str = skk_zenkaku_vector[LAST_CHAR];
	loop (count)
		j_insert_str(str);
}

define j_set_henkan_point_subr ()
{
	%  ޤ  ΤȤϳꤹ
	if (j_henkan_on)
		j_kakutei(NS);

	if (my_int(j_prefix))
		j_erase_prefix();

	insert("");

	if (my_int(j_prefix)) {
		move_user_mark(j_kana_start_point);
		insert(j_prefix);
	}
	update(FALSE); %@@ 롩
	j_henkan_on = 1;
	move_user_mark(j_henkan_start_point);
}

define assoc (prefix, table)
{
	variable i;

	% is_list_element("b by ch cy ...", prefix, ' ') 
	% Ѥˡ⤢뤬Ƥ

	for (i = 0; my_int(table[i,0]) != ' '; ++i) {
		if (strcmp(table[i,0], prefix) == 0) {
			return i;
		}
	}
	return -1;
}

define j_set_okurigana()
{
	variable w_head;

	push_spot();
	goto_user_mark(j_okurigana_start_point);
	move_user_mark(j_henkan_end_point);
	%% just in case
	!if (looking_at("*"))
		insert("*");

	goto_user_mark(j_henkan_start_point);
	push_mark();
	goto_user_mark(j_henkan_end_point);
	w_head = bufsubstr();

	pop_spot();

	push_spot();
	push_mark();
	goto_user_mark(j_okurigana_start_point);
	go_right_1(); % right of "*"
	j_henkan_okurigana = bufsubstr();
	j_henkan_key2 = Sprintf("%s*%s", w_head, j_henkan_okurigana, 2);
	j_henkan_key = strcat(w_head, j_okuri_char);
	j_prefix = NS;
	j_okuri_char = NS;
	goto_user_mark(j_okurigana_start_point);
	del();
	pop_spot();
	j_henkan();
	j_okurigana = 0;
}

define j_insert (table)
{
	variable chr, i;

	i = assoc(j_prefix, table);
	if (i < 0) { % j-prefix not found in the table
		j_prefix = NS;
		ungetkey(LAST_CHAR);
		return;
	}
	if (andelse {j_kakutei_early} {j_henkan_active})
		j_kakutei(NS);
	if (j_katakana) table[i, 2]; else table[i, 1];
	$1 = ();
	j_insert_str($1);
	if (j_okurigana)
		j_set_okurigana();
	else
		j_prefix = NS;
}

define j_insert_a ()
{
	set_buffer_local();

	if (andelse {skk_always_henkan_on} {not(j_henkan_on)})
		j_set_henkan_point_subr();
	j_insert(skk_roma_kana_a);
}

define j_insert_i ()
{
	set_buffer_local();

	if (andelse {skk_always_henkan_on} {not(j_henkan_on)})
		j_set_henkan_point_subr();
	j_insert(skk_roma_kana_i);
}

define j_insert_u ()
{
	set_buffer_local();

	if (andelse {skk_always_henkan_on} {not(j_henkan_on)})
		j_set_henkan_point_subr();
	j_insert(skk_roma_kana_u);
}

define j_insert_e ()
{
	set_buffer_local();

	if (andelse {skk_always_henkan_on} {not(j_henkan_on)})
		j_set_henkan_point_subr();
	j_insert(skk_roma_kana_e);
}

define j_insert_o ()
{
	set_buffer_local();

	if (andelse {skk_always_henkan_on} {not(j_henkan_on)})
		j_set_henkan_point_subr();
	j_insert(skk_roma_kana_o);
}

define j_insert_prefix (r_ch)
{
	if (skk_echo) {
		insert(r_ch);
		update(FALSE);
	}
}

define j_member (x, L)
{
	%variable i;

	%for (i = 0; strcmp(L[i], NS) != 0; ++i) {
	%	!if (strcmp(L[i], x)) {
	%		return 1;
	%	}
	%}
	%return 0;

	return is_list_element(L, x, ' ');
}

define j_assoc_rule (prefix)
{
	variable i;

	for (i = 0; i < skk_rule_num; i++) {
		!if (strcmp(skk_rule[i,0], prefix)) {
			return (skk_rule[i,1], skk_rule[i,3], skk_rule[i,2], skk_rule[i,4]);
		}
	}
	return Nil_type;
}

define j_compute_numeric_henkan_key()
{
#ifdef nodef
	!if (skk_use_numeric_conversion)
		return j_henkan_key;

	key = j_henkan_key;
  (let (p (list nil) (val nil) (key j-henkan-key))

	push_spot();
	buf = whatbuf();
	sw2buf(" *skk-work*");
	erase_buffer();
	insert(key)
	bob();
	while (re-search-forward "\\([0-9]\\|[-]\\)" nil t) {
		(goto-char (match-beginning 1))
		p = what_point();
		while (looking_at("\\([0-9]\\|[-]\\)") {
			if (looking_at("[-]") {
				insert(...);
				del();
			} else {
				go_right_1();
			}
		}
		push_mark(); % for del_region
		push_mark(); % for bufsubstr
		goto_point(p);
		num = bufsubstr();
		del_region();
		insert("#");
		list = (nconc list (list num));
	}
	bob();
	push_mark();
	eob();
	val = bufsubstr();

	setbuf(buf);
	pop_spot();

	j_num_list = list;
#endif
	variable len, key, val, list, n, i, j, m, num, c;

	!if (skk_use_numeric_conversion)
		return j_henkan_key;

	key = j_henkan_key;

	len = strlen(key);
	val = NS;
	list = NS;
	n = 0;
	i = 1;
	%while (string_match(key, "\\([0-9-]\\)", i))
	%while (string_match(key, "\\([0-9]\\)", i))
	while (i <= len)
	{
		%m = string_match(key, "\\([0-9]\\)", i);
		m = string_match(key, "[0-9]", i);
		!if (m)
			break;
		m--;
		val = strcat(val, substr(key, i, m));
		if (n)
			list = strcat(list, " ");
		num = NS;
		i += m;
		%while (string_match(key, "[0-9-]", i))
		forever
		{
			c = key[i - 1];
			if (isdigit(char(c))) {
				i++;
			} else if (andelse {c == zen0[0]} {key[i] >= zen0[1]} { key[i] <= zen9[1]}) {
				c = key[i] - 128;
				i += 2;
			} else {
				break;
			}
			num = Sprintf("%s%c", num, c, 2);
		}
		list = strcat(list, num);
		n++;
		val = strcat(val, "#");
	}
	if (i <= len)
		val = strcat(val, substr(key, i, len - i + 1));

	j_num_list_num = n;
	j_num_list = list;

	return val;
}

define j_vector_add (u, ulen, v)
{
	variable x, i, e, w, l;

	w = u;
	l = ulen;
	i = 0;
	forever {
		e = extract_element(v, i, '/');
		if (e == NULL)
			e = NS;
		!if (my_int(e))
			break;
		!if (is_list_element(u, e, '/')) {
			l++;
			w = Sprintf("%s%s/", w, e, 2);
		}
		i++;
	}
	return (w, l);
}

define j_henkan_show_candidates (h_start)
{
	variable cont, count, unread, h_count;
	variable i;
	variable l;
	variable str;
	variable ch;
	variable c;
	variable a, b;
	variable up_keys;
	variable num, vec;

	cont = 1;
	count = 1;
	l = j_henkan_vector_num;
	if (h_start < 0)
		h_start = 4;
	found = 1;

	push_spot();
	goto_user_mark(j_henkan_start_point);
	push_mark();
	del_region();
	goto_user_mark(j_henkan_end_point);
	pop_spot();

	h_count = j_henkan_count;
	unread = 0;
	%inhibit_quit = 0;

	push_spot();
	while (andelse {j_search_prog_num} {l - h_count < 7}) {
		(vec, num) = j_search();
		(j_henkan_vector, j_henkan_vector_num) = j_vector_add(j_henkan_vector, j_henkan_vector_num, vec);
		l = j_henkan_vector_num;
	}
	if (h_count == l) {
		cont = 0;
		found = 0;
	}

	%IGNORE_USER_ABORT = 1;

	ERROR_BLOCK
	{
		_clear_error();
		flush(NS);
		ungetkey('x');
		quit = 1;
		h_count = 1;
		j_henkan_count = h_count;
	}

	while (cont) {
		while (andelse {j_search_prog_num} {l - h_count < 7}) {
			(vec, num) = j_search();
			(j_henkan_vector, j_henkan_vector_num) = j_vector_add(j_henkan_vector, j_henkan_vector_num, vec);
			l = j_henkan_vector_num;
		}
		if (h_count == l) {
			%cont = 0;
			break;
		}

		up_keys = strup(j_henkan_show_candidates_keys);

		$3 = extract_element(j_henkan_vector, h_count, '/');
		if ($3 == NULL)
			$3 = NS;
		str = Sprintf("%c:%s", up_keys[0], $3, 2);
		i = 1;
		while (andelse {h_count + i < l} {i < 7}) {
			$4 = extract_element(j_henkan_vector, h_count + i, '/');
			if ($4 == NULL)
				$4 = NS;
			str = Sprintf("%s %c:%s", str, up_keys[i], $4, 3);
			i++;
		}

		count = l - h_count + 1;
		if (count > 8)
			count = 8;
		if (j_search_prog_num) "+"; else NS;
		$4 = ();
		str = Sprintf("%s  [Ĥ %d%s]", str, 
			l - (h_count + count) + 1,
			%(make-string j_search_prog_num ?+))),
			$4,
			3);

		%(princ str)
		%message(str);
		flush(str);

		h_count += count - 1;

		ch = getkey();
		c = is_substr(j_henkan_show_candidates_keys, char(ch)) - 1;

		if (c >= 0) {
			if (c + 2 > count) {
				flush(Sprintf("`%c' is not valid here!", ch, 1));
				flush(NS);
				h_count -= count - 1;
			} else {
				h_count -= count - c - 2;
				new_word = extract_element(j_henkan_vector, h_count - 1, '/');
				if (new_word == NULL)
					new_word = NS;
				kakutei = 1;
				%cont = 0;
				break;
			}
		} else if (ch == 'x') {
			a = (h_count - (h_start + 1)) / 7;
			b = h_count - (h_start + 7 * a);

			if (a) {
				h_count -= b + 7;
			} else {
				h_count -= b - 1;
				unread = 1;
				%cont = 0;
				break;
			}
		} else if (ch == ' ') {
			%if (andelse {h_count == l} {j_search_prog_num == 0})
			if (h_count == l)
			{
				%% no more candidates
				found = 0;
				%cont = 0;
				break;
			}
		%} else if (ch == 8) { % ^G
		%	%(signal 'quit nil)
		%	h_count = 1;
		%	unread = 1;
		%	%cont = 0;
		%	break;
		} else {
			flush(Sprintf("`%c' is not valid here!", ch, 1));
			flush(NS);
			h_count = h_count - (count - 1);
		}
		%if (quit) {
		%	h_count = 1;
		%	unread = 1;
		%	%cont = 0;
		%	break;
		%}
	}
	pop_spot(); % end of save excur

	%IGNORE_USER_ABORT = 0;

	if (unread) {
		ungetkey('x');
		quit = 1;
	}
	j_henkan_count = h_count;
}

define j_change_marker ()
{
	variable save_pos, n;
   
	push_spot();
	goto_user_mark(j_henkan_start_point);
	go_left_1();
	if (looking_at("")) {
		insert("");
		del();
	} else {
		j_kakutei(NS);
		% error("It seems that you have deleted .");
	}
	pop_spot();
}

define j_change_marker_to_white ()
{
	push_spot();
	goto_user_mark(j_henkan_start_point);
	go_left(j_kanji_len);
	if (looking_at("")) {
		insert("");
		del();
	} else {
		goto_user_mark(j_henkan_start_point);
		insert("");
		move_user_mark(j_henkan_start_point);
		message("It seems that you have deleted .");
	}
	pop_spot();
}

define j_purge_from_jisyo ()
{
	% "Purge wrong words from jisyo buffer."

	if (andelse {j_henkan_active} {my_int(j_henkan_key)}
		{get_yes_no("Really purge?") > 0}) {
		$2 = extract_element(j_henkan_vector, j_henkan_count - 1, '/');
		if ($2 == NULL)
			$2 = NS;
		j_update_jisyo(skk_jisyo, $2, 1);
		push_spot();
		goto_user_mark(j_henkan_start_point);
		push_mark();
		goto_user_mark(j_henkan_end_point);
		del_region();
		pop_spot();
		j_change_marker_to_white();
		j_henkan_active = 0;
		j_kakutei(NS);
	}
}

define minibuf_hook ()
{
	variable a, b, new_word_enterd, save_j_prefix;
%variable x;

	set_buffer_local();
	use_keymap(skk_minibuff_map);

	insert(skk_str_in_mini);

	goto_point(skk_kana_start_in_mini);
	j_kana_start_point = create_user_mark();
	goto_point(skk_henkan_start_in_mini);
	j_henkan_start_point = create_user_mark();
	goto_point(skk_henkan_end_in_mini);
	j_henkan_end_point = create_user_mark();

	new_word_enterd = my_int(new_word);

	if (new_word_enterd) {
		kakutei = 1;
		j_count_touroku++;
		j_henkan_count++;
	} else {
		if (j_henkan_count > 4) {
			%a = (j_henkan_count - 5) / 7;
			%b = j_henkan_count - 4 - 7 * a;
			%j_henkan_count = j_henkan_count - b;
			j_henkan_count = 4 + (j_henkan_count - 5) / 7 * 7;
			j_henkan();
		} else if (not(j_henkan_count)) {
			j_henkan_active = 0;
			j_henkan_key2 = NS;
			j_change_marker_to_white();
			%(j-henkan-start-point save-start))
		}
	}

	if (new_word_enterd) {
		push_mark();
		goto_user_mark(j_henkan_start_point);
		del_region();
		j_insert_word(new_word);
		move_user_mark(j_henkan_end_point);
		if (kakutei) {
			kakutei = 0;
			save_j_prefix = j_prefix;
			j_kakutei(new_word);
			j_prefix = save_j_prefix;
		}
	}
}

define my_read_mini (); % definition required for recursion

define my_read_mini (w)
{
	variable initial, w2, h_count, str, kana_start, henkan_start, henkan_end;

	ERROR_BLOCK
	{
		_clear_error();
		--skk_minibuffer_depth;
		return NS;
	}

	++skk_minibuffer_depth;

	setbuf(minibuf);
	set_buffer_local();
	j_setup_skk_minibuff_map();
	use_keymap(skk_minibuff_map);
	skk_recursive_in_mini = 0;

	new_word = read_mini(w, NS, NS);

	while (skk_recursive_in_mini) {

		if (j_num_list_num)
			j_search_key;
		else if (my_int(j_henkan_key2))
			j_henkan_key2;
		else
			j_henkan_key;
		w2 = ();

		h_count = j_henkan_count;
		str = skk_str_in_mini;
		kana_start = skk_kana_start_in_mini;
		henkan_start = skk_henkan_start_in_mini;
		henkan_end = skk_henkan_end_in_mini;

		new_word = my_read_mini(w2);

		j_henkan_count = h_count;
		skk_str_in_mini = str;
		skk_kana_start_in_mini = kana_start;
		skk_henkan_start_in_mini = henkan_start;
		skk_henkan_end_in_mini = henkan_end;

		definekey("minibuf_hook", "^M", hook_trigger_map);
		setbuf(minibuf);
		use_keymap(hook_trigger_map);
		buffer_keystring("\015"); % ^M

		skk_recursive_in_mini = 0;

		new_word = read_mini(w, NS, NS);
	}

	--skk_minibuffer_depth;

	return new_word;
}

define j_henkan_in_minibuff ()
{
	variable save_minikeymap;
	variable x, new_word, r_word, h_count, w, a, b;
	variable buf, minimap;

	new_word = NS;
	h_count = j_henkan_count;

	if (j_num_list_num)
		j_search_key;
	else if (my_int(j_henkan_key2))
		j_henkan_key2;
	else
		j_henkan_key;
	w = ();

	buf = whatbuf();
	setbuf(minibuf);
	minimap = what_keymap();

	r_word = my_read_mini(w);

	setbuf(minibuf);
	use_keymap(minimap);

	setbuf(buf);
	set_buffer_local();

	j_henkan_count = h_count;

	new_word = r_word;

	if (my_int(new_word)) {
		kakutei = 1;
		j_count_touroku++;
		j_henkan_count++;
	} else {
		if (j_henkan_count > 4) {
			%a = (j_henkan_count - 5) / 7;
			%b = j_henkan_count - 4 - 7 * a;
			%j_henkan_count = j_henkan_count - b;
			j_henkan_count = 4 + (j_henkan_count - 5) / 7 * 7;
			j_henkan();
		} else if (not(j_henkan_count)) {
			j_henkan_active = 0;
			j_henkan_key2 = NS;
			j_change_marker_to_white();
			%(j-henkan-start-point save-start))
		}
	}

	new_word;
}

define j_search_sorted_buffer (key, buf, limit, min, max, reverse)
{
	variable w, merge_all_entry;
	variable save_cs;
	variable vec = 0, num;
	variable len, found;
	variable minl, maxl, pl, size, res;
	variable vec1, vec2, vec3, vec4, l1, l2, l3, l4;

	merge_all_entry = (orelse {not(j_okuri_ari)} {not(j_henkan_okuri_strictly)});
	okuri_ari = j_okuri_ari;
	okurigana = j_henkan_okurigana;

	goto_user_mark(min);
	minl = what_line();
	if (reverse)
		goto_user_mark(max);
	else
		eob();
	maxl = what_line();
	size = maxl - minl;

	if (limit) {
		while (size > limit) {
			pl = minl + size / 2;
			goto_line(pl);
			bol();
			push_mark();
			() = ffind(" ");
			res = strcmp(bufsubstr(), key);
			if (reverse)
				res = -res;
			pl; % push right value
			if (res > 0)
				maxl = ();
			else
				minl = ();
			size = maxl - minl;
		}
	}

	goto_line(maxl);
	bol();
	push_mark();
	goto_line(minl);
	bol();
	!if (bobp())
		go_left_1();
	narrow();

	save_cs = CASE_SEARCH;
	CASE_SEARCH = 0;
	%w = Sprintf("\n%s /", key, 1);
	w = strcat(key, " /");
	found = bol_fsearch(w);

	widen();

	if (found) {
		go_right(strlen(w));
		(vec1, l1, vec2, l2, vec3, l3, vec4, l4) = j_compute_henkan_vectors();
	} else {
		vec1 = NS; vec2 = NS; vec3 = NS; vec4 = NS;
		l1 = 0; l2 = 0; l3 = 0; l4 = 0;
	}
	CASE_SEARCH = save_cs;

	if (merge_all_entry)
		(vec3, l3) = j_vector_add(vec3, l3, vec1);

	return (vec3, l3);
}

define j_search_jisyo_file (file, limit, nomsg)
{
	variable ari_min, ari_max, nasi_min;
	variable buf;
	variable vec = 0, num;
	variable savebuf;

	!if (my_int(file))
		return (NS, 0); % 0 ???

	push_spot(); savebuf = whatbuf();

	buf = j_get_file_buffer(file, nomsg);

	ERROR_BLOCK
	{
		sw2buf(savebuf); pop_spot(); % save-excursion end
		return (NS, 0);
	}

	sw2buf(buf);

	() = set_jisyo_buffer_local();

	ari_min = j_okuri_ari_min;
	ari_max = j_okuri_ari_max;
	nasi_min = j_okuri_nasi_min;

	if (j_okuri_ari)
		(vec, num) = j_search_sorted_buffer(j_henkan_key, buf, limit, ari_min, ari_max, 1);
	else
		(vec, num) = j_search_sorted_buffer(j_search_key, buf, limit, nasi_min, 0, 0);

	sw2buf(savebuf); pop_spot();

	return (vec, num);
}

define server_signal_handler (pid, flags)
{
	skkserv_pid = -1;
}

define server_status ()
{
	if (skkserv_pid != -1)
		update(0);
	return skkserv_pid != -1;
}

define j_open_server_subr ()
{
	ERROR_BLOCK
	{
		_clear_error();
		return 0;
	}

	if (my_int(skk_portnum)) skk_portnum; else "skkserv";
	$3 = ();
	skkserv_pid = open_process("tcp", skk_server_host, $3, 2);
	if (skkserv_pid == -1)
		return 0;

	set_process(skkserv_pid, "signal", "server_signal_handler");

	return server_status();
}

define j_open_server ()
{
%   "Establish connection with skk server."

	variable succ, i, count, server_host, server_serv;

	if (server_status())
		return;

	i = arraylen(skk_server_list);
	!if (i) {
		skk_server_list = String_Type[2];
		skk_server_list[1] = skk_serv;
		skk_server_list[0] = skk_server_host;
		i = 2;
	}

	%get_buffer_create(" *skkserv*");
	%get_buffer_create("*skkserv*");
	setbuf("*skkserv*");

	if (j_open_server_subr()) {
		succ = 1;
	} else {
		succ = 0;
#iffalse
		while (i > 0) {
			--i;
			server_serv = skk_server_list[i];
			--i;
			server_host = skk_server_list[i];

			for (count = 7; count > 0; --count) {
			  	%message ""
				   %skk_server_host (make_string count ?.))
				vmessage("SKK SERVER on %s is not active, I will activate it", server_host, 1);
				if (strcmp(server_host, systemname())) {
					() = system(Sprintf("%s %s %s", j_remote_shell_program, skk_server, skk_serv, 3);
				} else {
					%% server host is local machine
					() = system(skk_serv);
				}
				input_pending(3);
				if (j_open_server_subr()) {
					succ = 1;
					break;
				}
			}
			if (succ) {
				vmessage("SKK SERVER on %s is active now.", skk_server_host, 1);
				input_pending(1);
				break;
			}
		}
#endif
	}

	if (succ) {
%		    (set_process_kanji_code (get_process "skkservd") 0))
	} else {
		vmessage("Could not activate SKK SERVER on %s.", skk_server_host, 1);
		input_pending(1);
		%% reset SKK_SERVER_HOST so as not to use server in this session
		skk_server_host = NS;
		beep();
	}
}

define j_search_server_subr (file, limit)
{
%   "search for henkan-key through skkserver and create the vector of
% candidates.  if server is not available, search FILE instead."

	variable key, okurigana, okuri_ari, merge_all_entry, count, buf;
	variable vec1, vec2, vec3, vec4, l1, l2, l3, l4;

	if (j_okuri_ari) j_henkan_key; else j_search_key;
	key = ();
	okurigana = j_henkan_okurigana; %% passed to j-compute-henkan-vectors
	okuri_ari = j_okuri_ari; %% used in j-compute-henkan-vectors
	%% when merge-all-entry is nil, only the entry with strcitly
	%% matched okurigana is returned.
	merge_all_entry = (orelse {not(j_okuri_ari)} {not(j_henkan_okuri_strictly)});

	buf = whatbuf();

	EXIT_BLOCK
	{
		setbuf(buf);
	}

	!if (server_status())
		j_open_server();

	!if (server_status()) {
		%% server is not active, so search file instead
		return j_search_jisyo_file(file, limit, 0);
	}
	%setbuf(" *skkserv*");
	setbuf("*skkserv*");
	erase_buffer();
	send_process(skkserv_pid, Sprintf("1%s \n", key, 1));
	count = 0;
	forever { %(memq (process-status "skkservd") '(open run))
		get_process_input(1);
		++count;
if (count > 100) {
break;
}
		if (andelse {bobp()} {eobp()})
			continue;
		bob();
		!if (what_char() == '1') {
			%% not found or error, so exit
			break;
		}
		%% found key successfully, so check if a whole line
		%% is received.
%		eol();
%		!if (eobp()) {
%			break;
%		}
		eob();
		if (what_line() > 1)
			break;
	}
	bob();
	if (skk_report_server_response) {
		vmessage("waited for server response %d times.", count, 1);
	}
	!if (looking_at("1")) {
		%% not found or error
		return (NS, 0);
	}

	go_right(2);
	(vec1, l1, vec2, l2, vec3, l3, vec4, l4) = j_compute_henkan_vectors();
	if (merge_all_entry)
		(vec3, l3) = j_vector_add(vec3, l3, vec1);

	return (vec3, l3);
}

define j_okuri_search_subr ()
{
	variable key, key1, key2, key3, len, len1, len2, len3;
	variable henkan_key, okuri, okuri3, v, buf;
	variable savebuf, i, num;

	% "줷" 
	% "s //[//]/" Ѵͻ

	v = NS;
	num = 0;

	% henkan_key "줷"
	henkan_key = j_henkan_key;
	% key = ""
	if (skk_mule) 3; else 2;
	len1 = ();
	key = substr(henkan_key, 1, len1);
	% len = 6
	len = strlen(henkan_key);
	% key1 = strcat("\n", key);
	key1 = key;
	%kanji_flag = 0;
	%mc_flag = 0;
	%inhibit_quit = 1;

	push_spot(); savebuf = whatbuf(); % save_excursion

	buf = get_file_buffer(skk_jisyo);

	ERROR_BLOCK
	{
		sw2buf(savebuf); pop_spot(); % save_excursion end
		return (NS, 0);
	}

	sw2buf(buf);

	() = set_jisyo_buffer_local();

	goto_user_mark(j_okuri_ari_max);
	push_mark();
	goto_user_mark(j_okuri_ari_min);
	bol();
	go_left_1();
	narrow();

	while (bol_fsearch(key1)) {
		go_right(len1);
		% "s "  "" ΰ
		push_mark();
		() = ffind(" ");
		% "s" ʬ"s "  "s" ΰ֤
		% skk.el  (- (point) 2)  "s " ʬɤäƤ
		go_left_1();
		% key2 = "" + "" = ""
		key2 = strcat(key, bufsubstr());
		% len2 = 4
		len2 = strlen(key2);
		if (orelse {len2 > len}
			{strcmp(key2, substr(henkan_key, 1, len2))}) {
			continue;
		}

		while (ffind("/[")) {
			% "/[/ "  "/" ΰ֤ "/[" ʬؤ "" ΰ֤
			go_right(2);
			% skk.el  r Ϥΰ
			push_mark();
			() = ffind("/");
			% okuri3 = ""
			okuri3 = bufsubstr();
			% "/" ʬؤ
			go_right_1();
			% key3 = "" + "" = "줷"
			key3 = strcat(key2, okuri3);
			% len3 = 6
			len3 = strlen(key3);
			if (andelse {len3 <= len}
				{strcmp(key3, substr(henkan_key, 1, len3)) == 0}) {
				%% finally found a candidate!
				% okuri = "" + substr("줷", 6 + 1, 8) = ""
				okuri = strcat(okuri3, substr(henkan_key, len3 + 1, len));
				while (not(looking_at("\]"))) {
					push_mark();
					!if (ffind("/")) {
						%% it is not necessary to seach for "\[" on this line
						%% any more
						pop_mark(0);
						break;
					}
					
					v = Sprintf("%s%s%s/", v, bufsubstr(), okuri, 3);
					++num;

					% "/" ʬؤ
					go_right_1();
				}
			}
		}
	}

	widen();

	sw2buf(savebuf); pop_spot(); % save_excursion end

	return (v, num);
}

define j_okuri_search ()
{
	variable v, num;

	if (orelse {j_abbrev} {not(skk_auto_okuri_process)}
		{skk_process_okuri_early} {j_okuri_ari}
			%% we don't do auto_okuri_process if henkan key
			%% contains numerals
			{j_num_list_num} {strlen(j_henkan_key) <= 1}) {
		return (NS, 0);
	}

	j_okuri_index_min = j_henkan_vector_num;
	(v, num) = j_okuri_search_subr();
	j_okuri_index_max = j_okuri_index_min + num;
	return (v, num);
}

define j_search_server (file, limit, nomsg)
{
	if (orelse {arraylen(skk_server_list)} {my_int(skk_server_host)})
		return j_search_server_subr(file, limit);
	else
		return j_search_jisyo_file(file, limit, nomsg);
}


define j_search_kakutei_jisyo_file (file, limit, nomsg)
{
	variable vec, num;

	(vec, num) = j_search_jisyo_file(file, limit, nomsg);
	if (num) {
		kakutei = 1;
		return (vec, 1);
	} else {
		return (NS, 0);
	}
}


define j_search ()
{
	% search j-henkan-key using the programs in the list j-search-prog-list."

	variable num;
	variable c;

	while (j_search_prog_num) {
		--j_search_prog_num;
		c = my_int(skk_search_prog_list[j_search_prog_num]);

		num = eval(skk_search_prog_list[j_search_prog_num]);
		if (num)
			return num; % vector ΤޤޤǤξ num  push
		else
			pop(); % pop dummy vector
	}

	return (NS, 0);
}

define j_henkan ()
{
	variable ebp, new_word_enterd;
	variable l1, l2;
	variable vec, num;
	variable save_start, save_end, ch;
	variable save_pos, save_j_prefix, len;

	ebp = eobp();
	!if (ebp) {
		go_right_1();
		push_spot(); % (setq mark (make_marker))
	}

	%  save_excursion ɬפʤ
	push_spot(); % save_excursion

	!if (j_henkan_active) { % ΤȤ
		j_change_marker();
		j_henkan_active = 1;
		j_search_prog_num = arraylen(skk_search_prog_list);
	}
	if (my_int(j_henkan_key) == 0) {
		j_kakutei(NS);
	} else {
		found = 0;
		kakutei = 0;
		quit = 0;
		l1 = 0;
		l2 = 0;
		if (j_henkan_count == 0) {
			!if (j_henkan_vector_num) {
				if (strcmp(LAST_KBD_COMMAND, "j_undo_kakutei")) {
					len = strlen(j_henkan_key) - 1;
					ch = j_henkan_key[len];
					j_okuri_ari = (andelse {my_int(j_henkan_key) > 127} {'a' <= ch} {ch <= 'z'});
					(j_henkan_vector, j_henkan_vector_num) = j_search();
				} else {
					j_search_prog_num = arraylen(skk_search_prog_list) - 1;
				}
			}
			if (j_henkan_vector_num) {
				found = 1;
				j_henkan_count = 1;
				new_word = extract_element(j_henkan_vector, 0, '/');
				if (new_word == NULL)
					new_word = NS;
			}
		} else {
			if (j_henkan_count < j_henkan_vector_num) {
				new_word = extract_element(j_henkan_vector, j_henkan_count, '/');
				if (new_word == NULL)
					new_word = NS;
				found = 1;
			} else {
				%% call j-search repeateldly, until we find new candidates
				%% or until j-search-prog-list becomes empty
				while (andelse {j_search_prog_num} {l1 == l2}) {
					l1 = j_henkan_vector_num;

					(vec, num) = j_search();
					(j_henkan_vector, j_henkan_vector_num) =
						j_vector_add(j_henkan_vector, j_henkan_vector_num, vec);

					l2 = j_henkan_vector_num;
				}
				if (j_henkan_count < j_henkan_vector_num) {
					new_word = extract_element(j_henkan_vector, j_henkan_count, '/');
					if (new_word == NULL)
						new_word = NS;
					found = 1;
				}
			}
			if (j_henkan_count < 4) {
				if (found)
					++j_henkan_count;
			} else {
				if (found)
					j_henkan_show_candidates(-1);
			}
		}

		!if (quit) {
			if (found) {
				goto_user_mark(j_henkan_end_point);
				push_mark();
				goto_user_mark(j_henkan_start_point);
				del_region();
				j_insert_word(new_word);
				move_user_mark(j_henkan_end_point);
				if (kakutei) {
					kakutei = 0;
					save_j_prefix = j_prefix;
					j_kakutei(new_word);
					j_prefix = save_j_prefix;
				}
			} else {
if (j_in_minibuffer()) {
				if (strcmp(what_keymap(), skk_minibuff_map)) {
% Sorry, not implemeted yet
message("no more candidate");
				} else {
					skk_recursive_in_mini = 1;
					goto_user_mark(j_kana_start_point);
					skk_kana_start_in_mini = what_point();
					goto_user_mark(j_henkan_start_point);
					skk_henkan_start_in_mini = what_point();
					goto_user_mark(j_henkan_end_point);
					skk_henkan_end_in_mini = what_point();
					bol(); push_mark(); eol();
					skk_str_in_mini = bufsubstr();
					pop_spot(); % end of save_excursion
					if (ebp) {
						eob();
					} else {
						pop_spot(); % (goto-char mark)
						go_left_1(); % ?????????
					}
					call("exit_mini");
					return;
				}
} else {
				% use recursive minibuffer

				push_spot();
				goto_user_mark(j_henkan_start_point);
				save_start = create_user_mark();
				goto_user_mark(j_henkan_end_point);
				save_end = create_user_mark();
				pop_spot();
				% enable_recursive_minibuffer = 1;
				% skk_isearch_message = 0;
				new_word = j_henkan_in_minibuff();
				new_word_enterd = my_int(new_word);
				j_henkan_start_point = save_start;
				j_henkan_end_point = save_end;

				if (new_word_enterd) {
					goto_user_mark(j_henkan_end_point);
					push_mark();
					goto_user_mark(j_henkan_start_point);
					del_region();
					j_insert_word(new_word);
					move_user_mark(j_henkan_end_point);
					if (kakutei) {
						kakutei = 0;
						save_j_prefix = j_prefix;
						j_kakutei(new_word);
						j_prefix = save_j_prefix;
					}
				}
}
			}
		}
	}
	%  push_spot ʤмɬפʤ
	pop_spot(); % end of save_excursion

	if (ebp) {
		eob();
	} else {
		pop_spot(); % (goto-char mark)
		!if (andelse {overwrite_mode} {new_word_enterd})
			go_left_1();
	}
}

define j_next_candidate()
{
	if (j_henkan_active) {
		j_henkan();
	}
}

define j_start_henkan()
{
	variable key;

	set_buffer_local();

	if (j_henkan_on) { % ΤȤ
		j_mode = 1;
		if (j_henkan_active) { % ΤȤ
			j_next_candidate();

			% ʲΤȤ
		} else if (my_int(j_prefix)) {
			% error(NS);
		} else if (0) { % pos < j_henkan_start_point
			% error("...");
		} else {
			% (save-excursion ...)
			move_user_mark(j_henkan_end_point);
			push_spot();
			push_mark();
			goto_user_mark(j_henkan_start_point);
			key = bufsubstr();
			pop_spot();
			j_henkan_key = extract_element(key, 0, ' ');
			if (j_henkan_key == NULL)
				j_henkan_key = NS;
			j_search_key = j_compute_numeric_henkan_key();
			j_henkan();
			if (andelse {j_abbrev} {j_henkan_active})
				use_local_map(skk_map);
		}
	} else {
		j_self_insert();
	}
}

define j_isearch_message()
{
}

!if (is_defined("j_save_buffers_kill_emacs")) {
	eval("define j_save_buffers_kill_emacs () { exit_jed(); }");
}
	
%define skk_kill_emacs_without_saveing_jisyo (query)
%{
%}

define j_save_jisyo (jisyo)
{
	bob();
	forever {
		push_mark();
		go_down(1000);
		() = append_region_to_file(jisyo);
		if (eobp())
			break;
	}
}

define skk_save_jisyo ()
{
	% "Save jisyo buffer into jisyo file."

	variable savebuf, jisyo, lines;

	!if (j_jisyo_buffer_modified) {
		flush("No need to save Jisyo.");
		return;
	}

	%% check if the header lines for the two jisyo buffers are ok.

	push_spot(); savebuf = whatbuf(); % save-excursion

	ERROR_BLOCK
	{
		sw2buf(savebuf); pop_spot(); % save-excursion end
	}

	sw2buf(get_file_buffer(skk_jisyo));
	%% set kanji-fileio-code appropriately
	set_kanji_fileio_code(skk_jisyo_code);
	bob();
	!if (bol_fsearch(";; okuri-ari entries.")) {
		message("Header line for okuri-ari entries is missing!"); % error
		return;
	}
	!if (bol_fsearch(";; okuri-nasi entries.")) {
		message("Header line for okuri-nasi entries is missing!"); % error
		return;
	}
	message("Saving Jisyo..."); % error

	% (get-buffer-create " *record*")

	% inhibit_quit = 1;

	jisyo = expand_filename(skk_jisyo);
	% file_modes = file_modes(jisyo);

	if (my_int(skk_backup_jisyo))
		() = rename_file(jisyo, expand_filename(skk_backup_jisyo));
	else
		() = delete_file(jisyo);
	j_create_file(jisyo, NS);
	% set_file_modes(jisyo, file_modes);
	sw2buf(get_file_buffer(jisyo));
	eob();
	lines = what_line();
	j_save_jisyo(jisyo);
	message("Saving Jisyo...done.");

% Sorry, not implemeted yet
	%(if (and skk-keep-record (> j-count-kakutei 0)) ... )

	j_count_touroku = 0;
	j_count_kakutei = 0;

	%% reset j-jisyo-buffer-modified
	j_jisyo_buffer_modified = 0;

	sw2buf(savebuf); pop_spot(); % save-excursion end
}

%define save_buffer_kill_emacs (query)
define exit_hook ()
{
	% "Save SKK jisyo buffer, offer to save each buffer, then kill this Emacs fork.
	% With prefix arg, silently save all file-visiting buffers, then kill."

	skk_save_jisyo();
	%if (strcmp(system_type, "ms-dos")) {
		if (andelse {my_int(skk_server_host)} {server_status()})
			send_process(skkserv_pid, "0\n"); %% disconnect server

		loop (100) { !if (server_status()) break; }
	%}
	j_save_buffers_kill_emacs();
}

define j_newline()
{
	variable no_nl;

	no_nl = andelse {skk_egg_like_newline} {j_henkan_on};

	if (j_in_minibuffer()) {
		j_kakutei(NS);
		!if (no_nl) {
			j_mode = 0;
			call("exit_mini");
		}
	} else {
		%if (j_kakutei(NS))
		%	--arg;
		j_kakutei(NS);
		!if (no_nl)
			j_emulate_original_map();
	}
}

define j_set_henkan_point ()
{
	variable normal, last_char, sokuon, henkan_active;

	set_buffer_local();

	if (andelse {LAST_CHAR >= 'A'} {LAST_CHAR <= 'Z'}) {
		normal = 1;
		last_char = LAST_CHAR + 'a' - 'A';
	} else {
		normal = 0;
		last_char = LAST_CHAR;
	}

	sokuon = andelse {strcmp(j_prefix, char(last_char)) == 0} {not(LAST_CHAR == 'o')};

	henkan_active = j_henkan_active;

	if (orelse {not(j_henkan_on)} {j_henkan_active}) { % ʳΤȤ
		if (normal) { %@@ ʸΤȤ
			j_set_henkan_point_subr();
		} else { %@@ '>' Τ褦ʤȤ
			if (j_henkan_on)
				j_set_henkan_point_subr();

			if (j_henkan_active)
				j_emulate_original_map();
			else
				j_self_insert();
		}
	} else { % ΤȤ
		if (normal) {
			%% prepare for the processing of okurigana if not j-okurigana and
			%% the preceding character is not a numeric character.
			%% if the previous char is a special midashi char or a
			%% numeric character, we assume that the user intended to type the
			%% last-command-char in lower case.
			% p1 ϰʸ
			% p2 ʸ
			!if (j_okurigana) {
%           (not
%            (and (not (= j-henkan-start-point (point)))
%             (let ((p1 (char-after (1- (point))))
%                   (p2 (char-after (- (point) 2))))
%               (or
%                ;; previous char is a special midashi char
%                (memq p1 j-special-midashi-char-list)
%                ;; previous char is an ascii numeric char
%                (and (<= ?0 p1) (<= p1 ?9))
%                ;; previous char is a jis numeric char
%                (and (= p2 163) (<= 176 p1) (<= p1 185)))))) ѿ
				if (skk_process_okuri_early) {
					move_user_mark(j_henkan_end_point);
					push_spot();
					if (sokuon) {
						goto_user_mark(j_kana_start_point);
					}
					push_mark();
					goto_user_mark(j_henkan_start_point);
					j_henkan_key = bufsubstr();
					pop_spot();
					if (sokuon) {
						if (j_katakana) ""; else "";
						$2 = ();
						j_henkan_key = strcat(j_henkan_key, $2);
					}
					j_henkan_key = strcat(j_henkan_key, char(last_char));
					if (sokuon) {
						j_erase_prefix();
						if (j_katakana) ""; else "";
						$1 = ();
						insert($1);
					}
					insert(" ");
					j_prefix = NS;
					j_henkan();
					if (sokuon) {
						go_left(2);
						deln(2);
					} else {
						go_left_1();
						del();
					}
					%% we set j-kana-start-point here, since the marker may
					%% no longer point at the correct position after j-henkan.
					move_user_mark(j_kana_start_point);
				} else {
					!if (spot_eq(j_henkan_start_point, 0)) {
						if (sokuon) {
							j_erase_prefix();
							if (j_katakana) ""; else "";
							$1 = ();
							insert($1);
							j_prefix = NS;
						}
					}
					move_user_mark(j_okurigana_start_point);
					insert("*");
					%%%%update(FALSE);
					move_user_mark(j_kana_start_point);
					j_okuri_char = char(last_char);
					j_okurigana = 1;
				}
			}
		} else { % process special char % !if normal
			insert(char(last_char));
			move_user_mark(j_henkan_end_point);
			push_mark();
			goto_user_mark(j_henkan_start_point);
			j_henkan_key = bufsubstr();
			j_search_key = j_henkan_key;
			j_prefix = NS;
			j_henkan();
		}
	}
	if (normal) {
		ungetkey(last_char);
	}
}

define j_kana_input ()
{
	variable ch, r_ch, input, prefix, nexttype;
	variable newprefix, kata, hira, save;

	set_buffer_local();

	if (andelse {j_kakutei_early} {j_henkan_active}) % j_kakutei_early && ΤȤ
		j_kakutei(NS);

	if (andelse {skk_always_henkan_on} {not(j_henkan_on)})
		j_set_henkan_point_subr();

	ch = char(LAST_CHAR);

	%if (my_int(skk_isearch_message))
	%	j_isearch_message();

	if (andelse {LAST_CHAR == 'o'}
		{0}) {
    %         (null (j-assoc-rule (concat j-prefix char))))
    %    (progn
    %      (j-insert-o)
    %      (if skk-isearch-message
    %          (progn
    %            (j-isearch-message)
    %            (setq cont nil)
    %            ;; thus you must type `oota' instead of `ohta' when inputting
    %            ;; isearch string
    %            )
		j_prefix = ch;
		move_user_mark(j_kana_start_point);
	} else {
		j_prefix = ch;
		move_user_mark(j_kana_start_point);
		j_insert_prefix(j_prefix);
	}

%	IGNORE_USER_ABORT = 1;
	%ERROR_BLOCK
	%{
	%	!if (strcmp(j_prefix, "o")) {
	%		j_keyboard_quit();
	%	}
	%	j_prefix = NS;
	%	j_erase_prefix();
	%	%j_kana_start_point = -1;
	%	beep();
	%	IGNORE_USER_ABORT = 0;
	%	return;
	%}

	forever {
		update(FALSE);
		r_ch = getkey();
		if (r_ch == 7 or r_ch == 127) { % '^G' or ^?
			% EXECUTE_ERROR_BLOCK;
			!if (strcmp(j_prefix, "o")) {
				j_keyboard_quit();
			}
			j_prefix = NS;
			j_erase_prefix();
			%j_kana_start_point = -1; %@@???
			beep();
			break;
		}
		if (andelse {j_henkan_on} {not(j_henkan_active)}
			%% we must distinguish the two cases where
			%% SKK-ECHO is on and off
			{mark_eq(j_henkan_start_point, j_kana_start_point)}
			{'A' <= r_ch} {r_ch <= 'Z'}) {
			%% this case takes care of the rare case where
			%% one types two characters in upper case
			%% consequtively.  For example, one sometimes
			%% types "TE" when one should type "Te"
			r_ch += 32; % tolower
		}
		input = char(r_ch);
		prefix = strcat(j_prefix, input);

		nexttype = j_assoc_rule(prefix);
		if (my_int(nexttype) != my_int(Nil_type)) {
			kata = ();
			hira = ();
			newprefix = ();

			j_erase_prefix();
			if (my_int(nexttype) == my_int(Next_type)) { % newprefix
				if (j_katakana) kata; else hira;
				$1 = ();
				j_insert_str($1);
				move_user_mark(j_kana_start_point);
				j_insert_prefix(newprefix);
				j_prefix = newprefix;
			} else if (my_int(nexttype) == my_int(End_type)) {
				if (j_katakana) kata; else hira;
				$1 = ();
				j_insert_str($1);
				j_prefix = NS;
				break;
			} else if (my_int(nexttype) == my_int(Function_type)) {
				j_prefix = NS;
				if (j_katakana) kata; else hira;
				$1 = ();
				eval($1);
				break;
			}
		} else if (strcmp(j_prefix, "n") == 0) { % "n"
			if (skk_char_type_vec[r_ch] == 3) { % vowel
				j_erase_prefix();
				ungetkey(r_ch);
				break;
			} else if (r_ch == 'y') { % "ny"
				j_prefix = prefix;
				j_insert_prefix("y");
			} else if (andelse {j_okurigana} {r_ch == ' '}) {
				ungetkey('n');
			} else {
				j_erase_prefix();
				if (j_katakana) ""; else "";
				$1 = ();
				j_insert_str($1);
				j_prefix = NS;
				move_user_mark(j_kana_start_point);
				ungetkey(r_ch);
				break;
			}
		} else if (andelse {strcmp(input, j_prefix) == 0}
						{skk_char_type_vec[r_ch] == 1}) {
			j_erase_prefix();
			if (j_katakana) ""; else "";
			$1 = ();
			j_insert_str($1);
			move_user_mark(j_kana_start_point);
			j_insert_prefix(char(r_ch));
		} else if (j_member(prefix, skk_prefix_list)) {
			j_prefix = prefix;
			j_insert_prefix(input);
		} else if (skk_char_type_vec[r_ch] == 3) { % vowel
			j_erase_prefix();
			ungetkey(r_ch);
			break;
		} else if (skk_char_type_vec[r_ch] == 4) {
			save = LAST_CHAR;
			LAST_CHAR = r_ch;
			j_erase_prefix();
			j_set_henkan_point();
			LAST_CHAR = save;
		} else if (skk_char_type_vec[r_ch] == 5) { % delete prefix
			if (j_okurigana) {
				push_spot();
				goto_user_mark(j_okurigana_start_point);
				if (what_char() == '*') {
					del(); % delete '*'
					move_user_mark(j_kana_start_point);
					j_okurigana = 0;
				}
				pop_spot();
			}
			if (my_int(j_prefix)) {
				if (skk_echo) {
					j_erase_prefix();
				} else {
					vmessage("Deleted prefix \"%s\".", j_prefix);
				}
			}
			if (andelse {skk_always_henkan_on} {spot_eq(j_henkan_start_point, 0)}) {
				j_kakutei(NS);
			}
			j_prefix = NS;
			break;
		} else {
			j_erase_prefix();
			%j_kana_start_point = -1; %@@ ???
			j_prefix = NS;
			ungetkey(r_ch);
			break;
		}
	}
%	IGNORE_USER_ABORT = 0;
}

define j_change_marker_to_white()
{
	push_spot();
	goto_user_mark(j_henkan_start_point);
	go_left(j_kanji_len);
	if (looking_at("")) {
		insert("");
		del();
	} else {
		goto_user_mark(j_henkan_start_point);
		insert("");
		move_user_mark(j_henkan_start_point);
		message("It seems that you have deleted .");
	}
	pop_spot();
}

define j_previous_candidate ()
{
	variable word;
	variable p_col;

	set_buffer_local();

	if (andelse {j_henkan_active} {my_int(j_henkan_key)}) {
		insert(" ");
		push_spot();
		%if (j_henkan_count == 1)
		if (j_henkan_count <= 1)
		{
			j_henkan_active = 0;
			j_henkan_count = 0;
			j_okuri_index_min = 0;
			j_okuri_index_max = 0;
			j_henkan_vector_num = 0;
			j_henkan_vector = NS;
			j_okurigana = 0;
			j_henkan_okurigana = NS;
			j_henkan_key2 = NS;
			j_num_list = NS;

			move_user_mark(q);
			goto_user_mark(j_henkan_start_point);
			push_mark();
			goto_user_mark(j_henkan_end_point);
			del_region();
			insert(j_henkan_key);
			if (my_int(j_prefix))
				move_user_mark(j_kana_start_point);
			p_col = what_point();
			move_user_mark(p);
			goto_user_mark(j_henkan_start_point);
			if (iskanji(what_char())) { % what_char() > 127
				%% roman prefix for okurigana is removed
				while (andelse {what_point() < p_col} {what_char() > 127}) {
						go_right_1();
				}
				if (andelse {what_char() >= 'a'} {what_char() <= 'z'}) {
					push_mark();
					goto_user_mark(p);
					del_region();
				}
			} else {
				goto_user_mark(p);
			}
			j_change_marker_to_white();
		} else if (j_henkan_count <= 7) {
			word = extract_element(j_henkan_vector, j_henkan_count - 2, '/');
			if (word == NULL)
				word = NS;
			goto_user_mark(j_henkan_start_point);
			push_mark();
			goto_user_mark(j_henkan_end_point);
			del_region();
			j_insert_word(word);
			move_user_mark(j_henkan_end_point);
			j_henkan_count--;
		} else if (j_henkan_count > 7) {
			j_henkan_count -= 8;
			ungetkey(' ');
		}
		pop_spot();
		!if (bobp()) {
			push_mark();
			go_left_1();
			if (what_char() == ' ') {
				del();
				pop_mark(0);
			} else {
				pop_mark(1);
			}
		}
		!if (j_henkan_count) {
			%goto_user_mark(if (skk_auto_okuri_process) q; else p);
			goto_user_mark(q);
			if (j_abbrev)
				use_local_map(skk_abbrev_map);
		}
	} else {
		if (strcmp(LAST_KBD_COMMAND, "j_kakutei_henkan")) {
			j_kana_input();
		} else {
			push_mark();
			goto_user_mark(j_henkan_start_point);
			del_region();
			j_set_henkan_point_subr();
			insert(j_kakutei_key);
			set_current_kbd_command("j_undo_kakutei");
		}
	}
}

%% j_katakana_region: 
%%    Arguments can be markers as well as numbers.
%%    Cf. katakana_region in wnn_egg.el, arguments to which 
%%    should not be markers.
%%    If vcontract is non_nil, "" is converted to "".
%%    The idea for this function comes from katakana_region in wnn_egg.el.

define j_katakana_region (start, end, vcontract)
{
%   "Convert hiragana\'s in the region between START and END to katakana\'s.
% Arguments start and end can be markers as well as numbers.
% If vcontract is non_nil, \"\" is converted to \"\"."

	variable ch, c;

	push_spot(); % save excursion

	goto_user_mark(end);
	push_mark();
	goto_user_mark(start);

	%narrow_to_region();
	%bob();

	while (spot_lt(end, 0)) { % not(eobp())
		ch = jwhat_char();
		if (ch < 0x100) {
			go_right_1();
			continue;
		}
		if (ishira(ch)) {
			c = ch mod 0x100;
			c -= 0x5f;
			if (c > 0x7f)
				++c;
			insert_char(0x83);
			insert_char(c);
			deln(2);
			continue;
		}
		go_right(2);
	}

	if (vcontract) {
		bob();
		while (fsearch("")) {
			insert("");
			deln(4);
		}
	}

	%wide_region();

	pop_spot(); % save excursion end
}

%% j_hiragana_region: 
%%    Arguments can be markers as well as numbers.
%%    Cf. hiragana_region in wnn_egg.el, arguments to which 
%%    should not be markers.
%%    "" and "" are not regarded as katakana's, since
%%    they don't have corresponding hiragana's.  If optional
%%    argument vexpand is non_nil, "" is converted to "".
%%    The idea for this function comes from hiragana_region in wnn_egg.el.

define j_hiragana_region (start, end, vexpand)
{
%   "Convert katakana\'s in the region between START and END to hiragana\'s.
% Arguments start and end can be markers as well as numbers.
% If vexpand is non_nil, \"\" is converted to \"\".
% \"\" and \"\" are left unchanged."

	variable ch, c;

	push_spot(); % save excursion

	goto_user_mark(end);
	push_mark();
	goto_user_mark(start);

	%narrow_to_region();
	%bob();

	while (spot_lt(end, 0)) { % not(eobp())
		ch = jwhat_char();
		if (ch < 0x100) {
			go_right_1();
			continue;
		}
		if (iskata(ch)) {
			c = ch mod 0x100;
			c += 0x5f;
			if (c > 0xde)
				--c;
			insert_char(0x82);
			insert_char(c);
			deln(2);
			continue;
		}
		go_right(2);
	}

	if (vexpand) {
		bob();
		while (fsearch("")) {
			insert("");
			deln(2);
		}
	}

	%wide_region();

	pop_spot(); % save excursion end
}

define j_zenkaku_region (start, end)
{
%   "Convert ascii characters in the region between START and END to the
% corresponding zenkaku characters."

	variable c, n, s;

	push_spot(); % save excursion

	goto_user_mark(end);
	push_mark();
	goto_user_mark(start);

	%narrow_to_region();
	%bob();

	while (re_fsearch("[ -~]")) {
		!if (spot_lt(end, 0))
			break;

		c = what_char();
		% ΣХܤȥޥåʤ褦˥ڡĤƤ
		n = is_substr(skk_zenkaku_alist, strcat(" ", char(c)));
		if (n) {
			insert(substr(skk_zenkaku_alist, n + 2, 2));
		} else if (andelse {c >= 'a'} {c <= 'z'}) {
			insert_char(0x82);
	    		insert_char(c + 0x20);
		} else {
			insert_char(0x82);
	    		insert_char(c + 0x1f);
		}
		del(1);
	}

	%wide_region();

	pop_spot(); % save excursion end
}

define j_katakana_henkan ()
{
%   "Convert hiragana\'s between henkan start point and
% henkan end point into katakana\'s.  Valid only in  mode."

	set_buffer_local();

	if (j_henkan_on) {
		!if (orelse {j_henkan_active} {j_katakana}) {
			j_mode = 1;
			if (my_int(j_prefix))
				error(" ");
			if (spot_lt(j_henkan_start_point, 0))
				error("Henkan end point must be after henkan start point.");
			push_spot(); % save excursion
			bol();
			if (spot_gt(j_henkan_start_point, 0)) {
				pop_spot(); % save excursion end
				error("Henkan key may not contain a new line character.");
			}
			pop_spot(); % save excursion end

			move_user_mark(j_henkan_end_point);
			j_katakana_region(j_henkan_start_point, j_henkan_end_point, 1);
			if (prefix_argument(-1) == -1)
				j_kakutei(NS);
		}
	} else {
		j_emulate_original_map();
	}
}

define j_hiragana_henkan ()
{
% "Convert katakana\'s between henkan start point and
% henkan end point into hiragana\'s.  Valid only in  mode."

	set_buffer_local();

	if (j_henkan_on) {
		!if (orelse {j_henkan_active} {not(j_katakana)}) {
			j_mode = 1;
			if (my_int(j_prefix))
				error(" ");
			if (spot_lt(j_henkan_start_point, 0))
				error("Henkan end point must be after henkan start point.");
			push_spot(); % save excursion
			bol();
			if (spot_gt(j_henkan_start_point, 0)) {
				pop_spot(); % save excursion end
				error("Henkan key may not contain a new line character.");
			}
			pop_spot(); % save excursion end

			move_user_mark(j_henkan_end_point);
			j_hiragana_region(j_henkan_start_point, j_henkan_end_point, 1);
			if (prefix_argument(-1) == -1)
				j_kakutei(NS);
		}
	} else {
		j_emulate_original_map();
	}
}

define j_zenkaku_henkan ()
{
%   "Convert hankaku\'s between henkan start point and
% henkan end point into zenkaku\'s.  Valid only in  mode."

	set_buffer_local();

	if (j_henkan_on) {
		!if (j_henkan_active) {
			j_mode = 1;
			if (my_int(j_prefix))
				error(" ");
			if (spot_lt(j_henkan_start_point, 0))
				error("Henkan end point must be after henkan start point.");
			push_spot(); % save excursion
			bol();
			if (spot_gt(j_henkan_start_point, 0)) {
				pop_spot(); % save excursion end
				error("Henkan key may not contain a new line character.");
			}
			pop_spot(); % save excursion end

			move_user_mark(j_henkan_end_point);
			j_zenkaku_region(j_henkan_start_point, j_henkan_end_point);
			if (prefix_argument(-1) == -1)
				j_kakutei(NS);
		}
	} else {
		j_emulate_original_map();
	}
}

define j_toggle_kana ()
{
	set_buffer_local();

	if (andelse {j_henkan_on} {not(j_henkan_active)}) {
		 j_katakana_henkan();
	} else {
		j_kakutei(NS);
		j_katakana = not(j_katakana);
		if (j_katakana)	skk_katakana_mode_string;
		else			skk_hirakana_mode_string;
		$1 = ();
		j_change_mode_line($1);
	}
}

define j_keyboard_quit ()
{
	%!if (my_int(j_henkan_key)) {
	%	if (j_in_minibuffer())
	%		abort_recursive_edit();
	%	else
	%		keyboard_quit();
	%}
	if (j_henkan_active) { % ΤȤ
		if (andelse {skk_delete_okuri_when_quit} {j_okuri_ari}) {
			push_mark();
			j_henkan_count = 1;
			j_previous_candidate();
			del_region();
		} else {
			j_henkan_count = 1;
			j_previous_candidate();
		}
	} else {
		if (j_henkan_on) { % ΤȤ
			if (spot_gt(j_henkan_start_point, 0)) {
				push_mark();
				goto_user_mark(j_henkan_start_point);
				del_region();
			}
			j_kakutei(NS);
		} else { % Ǥ⢧ǤʤȤ
			if (j_in_minibuffer())
				abort_recursive_edit();
			else
				keyboard_quit();
		}
	}
}

define j_keyboard_quit2 ()
{
	set_buffer_local();

	j_keyboard_quit();
}

define j_mode_off ()
{
  % "return to old ascii mode."

	set_buffer_local();

	j_kakutei(NS);
	j_mode = 0;
	j_prefix = NS;
	j_zenkaku = 0;
	use_local_map(j_emacs_local_map);
	j_change_mode_line(skk_mode_string);
}

define j_mode_off_in_minibuff ()
{
	% "return to old ascii mode in the minibuffer."

	set_buffer_local();

	j_kakutei(NS);
	j_mode = 0;
	j_prefix = NS;
	j_zenkaku = 0;
	use_local_map(mini_local_map);
}

define j_zenkaku_eiji ()
{
	set_buffer_local();

	j_kakutei(NS);
	j_mode = 0;
	j_prefix = NS;
	j_zenkaku = 1;
	use_local_map(skk_zenkaku_map);
	j_change_mode_line(skk_zenei_mode_string);
}

define j_abbrev_input ()
{
	set_buffer_local();

	if (andelse {j_henkan_on} {not(j_henkan_active)}) { % ΤȤ
		return; % error ??
	}
	j_kakutei(NS);
	j_set_henkan_point_subr();
	use_local_map(skk_abbrev_map);
	j_abbrev = 1;
}

%% completion

define j_completion (first)
{
	variable c_word = NS;
	variable buf, savebuf, jis_completion_word;

	if (first) {
		push_spot();
		goto_user_mark(j_henkan_start_point);
		push_mark();
		pop_spot();
		j_completion_word = bufsubstr();
		!if (my_int(j_completion_word)) {
			% error
			message("Cannot complete an empty string!");
			return;
		}
	}

	%IGNORE_USER_ABORT = 1;

	jis_completion_word = (j_completion_word[0] > 127);

	push_spot(); savebuf = whatbuf(); % save-excursion

	buf = get_file_buffer(skk_jisyo);

	ERROR_BLOCK
	{
		sw2buf(savebuf); pop_spot(); % save-excursion end
	}

	sw2buf(buf);

	() = set_jisyo_buffer_local();

	if (first) {
		goto_user_mark(j_okuri_nasi_min);
	}
	%kanji_flag = 0;
	%mc_flag = 0;
	%%  kanji-flag/mc-flag must be set nil for efficiency.

	while (bol_fsearch(j_completion_word)) {
		go_right(strlen(j_completion_word));
		!if (looking_at(" /")) {
			push_mark();
			() = ffind(" /");
			c_word = strcat(j_completion_word, bufsubstr());
			%% if the c-word begins with a JIS character, we must check
			%% if it ends with an ascii character.  if it indeed ends
			%% with an ascii character we should ignore it.
			if (andelse {jis_completion_word} {c_word[strlen(c_word) - 1] <= 127})
				c_word = NS;
		}
		if (my_int(c_word))
			break;
	}

	sw2buf(savebuf); pop_spot(); % save-excursion end

	if (my_int(c_word)) {
		push_mark();
		goto_user_mark(j_henkan_start_point);
		del_region();
		insert(c_word);
	} else {
		if (first) NS; else "more ";
		$2 = ();
		vmessage("No %scompletions for \"%s\"",
			$2, j_completion_word, 2);
		beep();
	}
}

define j_previous_completion ()
{
	variable c_word;
	variable buf, savebuf, jis_completion_word;

	%IGNORE_USER_ABORT = 1;
	%% completion word is assumed to be a JIS Kanji word if it begins
	%% with a JIS character
	jis_completion_word = (j_completion_word[0] > 127);
	c_word = NS;

	push_spot(); savebuf = whatbuf(); % save-excursion

	buf = get_file_buffer(skk_jisyo);

	ERROR_BLOCK
	{
		sw2buf(savebuf); pop_spot(); % save-excursion end
	}

	sw2buf(buf);

	() = set_jisyo_buffer_local();

	bol();
	%kanji_flag = 0;
	%mc_flag = 0;
	%% kanji-flag must be set nil for efficiency.

	while (not(bobp())) {
		!if (bol_bsearch(j_completion_word)) {
			bob();
			!if (looking_at(j_completion_word))
				break;
		}
		go_right(strlen(j_completion_word));
		if (looking_at(" /")) {
			bol();
		} else {
			push_mark();
			() = ffind(" /");
			c_word = strcat(j_completion_word, bufsubstr());
			%% if the c-word begins with a JIS character, we must check
			%% if it ends with an ascii character.  if it indeed ends
			%% with an ascii character we should ignore it.
			!if (jis_completion_word)
				break;
			if (c_word[strlen(c_word) - 1] > 127)
				break;

			c_word = NS;
			bol();
		}
	}

	sw2buf(savebuf); pop_spot(); % save-excursion end

	push_mark();
	goto_user_mark(j_henkan_start_point);
	del_region();
	if (my_int(c_word)) {
		insert(c_word);
	} else {
		insert(j_completion_word);
		message("No more previous completions.");
		beep();
	}
	set_current_kbd_command("j_completion");
}

define j_try_completion ()
{
	if (andelse {j_henkan_on} {not(j_henkan_active)}) { % 
		set_current_kbd_command("j_completion");
		j_completion(orelse {not(skk_dabbrev_like_completion)}
			{strcmp(LAST_KBD_COMMAND, "j_completion")});
	} else {
		j_emulate_original_map();
	}
}

define j_try_completion2 ()
{
	set_buffer_local();

	j_try_completion();
}

define j_insert_period ()
{
	set_buffer_local();

	if (strcmp(LAST_KBD_COMMAND, "j_completion")) {
		j_self_insert();
	} else {
		set_current_kbd_command("j_completion");
		j_completion(0);
	}
}

define j_insert_comma ()
{
	set_buffer_local();

	if (strcmp(LAST_KBD_COMMAND, "j_completion")) {
		j_self_insert();
	} else {
		j_previous_completion();
	}
}

define j_abbrev_period ()
{
	if (strcmp(LAST_KBD_COMMAND, "j_completion")) {
		j_emulate_original_map();
	} else {
		set_current_kbd_command("j_completion");
		j_completion(0);
	}
}

define j_abbrev_comma ()
{
	if (strcmp(LAST_KBD_COMMAND, "j_completion")) {
		j_emulate_original_map();
	} else {
		j_previous_completion();
	}
}

define j_delete_backward_char ()
{
	if (j_okurigana) {
		j_okurigana = 0;
		push_spot();
		goto_user_mark(j_okurigana_start_point);
		if (what_char() == '*')
			del();
		pop_spot();
	}
	if (andelse {j_henkan_on} {spot_eq(j_henkan_start_point, 0)}) {
		j_henkan_count = 0;
		j_kakutei(NS);
	} else if (j_henkan_active) {
		if (andelse {not(skk_delete_implies_kakutei)}
			{spot_eq(j_henkan_end_point, 0)}) {
			j_previous_candidate();
		} else {
			%(delete-backward-char (prefix-numeric-value count))
			go_left_1(); del();
			%if ((point) < p)
			%	j_kakutei(NS);
		}
	} else if (j_in_minibuffer()) {
		%(delete-backward-char (prefix-numeric-value count))
		go_left_1(); del();
	} else {
		%% we should not emulate original map if skk-use-vip is t and
		%% vip-current-mode's value is insert-mode
		if (andelse {skk_use_vip} {0}) { % (eq vip-current-mode 'insert-mode)
			%(delete-backward-char (prefix-numeric-value count))
			go_left_1(); del();
		} else {
			j_emulate_original_map();
		}
		if (andelse {skk_always_henkan_on} {spot_eq(j_henkan_start_point, 0)}) {
			j_kakutei(NS);
		}
	}
}

define j_date (date_ad, number_style)
{
	variable save_date_ad, save_number_style, str;
	variable y_str, y, year, mon, month, day, dw, day_of_week;

	save_date_ad = skk_date_ad;
	save_number_style = skk_number_style;

	skk_date_ad = orelse {date_ad} {skk_date_ad};
	skk_number_style = orelse {number_style} {skk_number_style};
	str = time();
	y_str = substr(str, 21, 4);
	y = integer(y_str) - 1988;
	if (skk_date_ad)
		j_num(y_str);
	else if (y == 1)
		"";
	else
		j_num(string(y));
	year = ();
	mon = substr(str, 5, 3);
	switch (mon)
	{ case ("Jan"): "1"; }
	{ case ("Feb"): "2"; }
	{ case ("Mar"): "3"; }
	{ case ("Apr"): "4"; }
	{ case ("May"): "5"; }
	{ case ("Jun"): "6"; }
	{ case ("Jul"): "7"; }
	{ case ("Aug"): "8"; }
	{ case ("Sep"): "9"; }
	{ case ("Oct"): "10"; }
	{ case ("Nov"): "11"; }
	{ case ("Dec"): "12"; }
	{ "?"; }
	month =	j_num($1);
	day = j_num(substr(str, 9, 2));
	dw = substr(str, 1, 3);
	switch (dw)
	{ case ("Sun"): ""; }
	{ case ("Mon"): ""; }
	{ case ("Tue"): ""; }
	{ case ("Wed"): ""; }
	{ case ("Thu"): ""; }
	{ case ("Fri"): ""; }
	{ case ("Sat"): ""; }
	{ "??"; }
	day_of_week = ();

	skk_date_ad = save_date_ad;
	skk_number_style = save_number_style;

	if (skk_date_ad) NS; else "ʿ";
	$2 = ();
	return Sprintf("%s%sǯ%s%s(%s)", $2,
		year, month, day, day_of_week, 5);
}

define j_today()
{
	insert(j_date(0, 0));
}

#iffalse
define skk_clear ()
{
	variable buf, cur;

	buf = whatbuf();

}
#endif

define init_rk_rule ()
{
	variable n, rule;

	n = ();

	rule = String_Type[n, 3];

	while (n) {
		--n;
		rule[n, 2] = ();
		rule[n, 1] = ();
		rule[n, 0] = ();
	}
	return rule;
}

%%%% skk_roma_kana_a

	$0 = _stkdepth();
.	NS	""		""
.	"b"	""	""	
.	"by"	"Ӥ"	"ӥ"
.	"ch"	""	""
.	"cy"	""	""
.	"d"	""	""
.	"dh"	"Ǥ"	"ǥ"
.	"dy"	"¤"	"¥"
.	"f"	"դ"	"ե"
.	"fy"	"դ"	"ե"
.	"g"	""	""
.	"gy"	""	""
.	"h"	""	""
.	"hy"	"Ҥ"	"ҥ"
.	"j"	""	""
.	"jy"	""	""
.	"k"	""	""
.	"ky"	""	""
.	"m"	""	""
.	"my"	"ߤ"	"ߥ"
.	"n"	""	""
.	"ny"	"ˤ"	"˥"
.	"p"	""	""
.	"py"	"Ԥ"	"ԥ"
.	"r"	""	""
.	"ry"	""	""
.	"s"	""	""
.	"sh"	""	""
.	"sy"	""	""
.	"t"	""	""
.	"th"	"Ƥ"	"ƥ"
.	"ty"	""	""
.	"v"	""	""
.	"w"	""	""
.	"x"	""	""
.	"xk"	""	""
.	"xw"	""	""
.	"xy"	""	""
.	"y"	""	""
.	"z"	""	""
.	"zy"	""	""
.	" "	NS	NS
	(_stkdepth() - $0) / 3;

skk_roma_kana_a = init_rk_rule();

%%%% skk_roma_kana_i

	$0 = _stkdepth();
.	NS	""	""
.	"b"	""	""
.	"by"	"Ӥ"	"ӥ"
.	"ch"	""	""
.	"cy"	""	""
.	"d"	""	""
.	"dh"	"Ǥ"	"ǥ"
.	"dy"	"¤"	"¥"
.	"f"	"դ"	"ե"
.	"fy"	"դ"	"ե"
.	"g"	""	""
.	"gy"	""	""
.	"h"	""	""
.	"hy"	"Ҥ"	"ҥ"
.	"j"	""	""
.	"jy"	""	""
.	"k"	""	""
.	"ky"	""	""
.	"m"	""	""
.	"my"	"ߤ"	"ߥ"
.	"n"	""	""
.	"ny"	"ˤ"	"˥"
.	"p"	""	""
.	"py"	"Ԥ"	"ԥ"
.	"r"	""	""
.	"ry"	"ꤣ"	"ꥣ"
.	"s"	""	""
.	"sh"	""	""
.	"sy"	""	""
.	"t"	""	""
.	"th"	"Ƥ"	"ƥ"
.	"ty"	""	""
.	"v"	""	""
.	"w"	""	""
.	"x"	""	""
.	"xw"	""	""
.	"z"	""	""
.	"zy"	""	""
.	" "	NS	NS
	(_stkdepth() - $0) / 3;

skk_roma_kana_i = init_rk_rule();

%%%% skk_roma_kana_u

.	NS	""	""
.	"b"	""	""
.	"by"	"Ӥ"	"ӥ"
.	"ch"	""	""
.	"cy"	""	""
.	"d"	""	""
.	"dh"	"Ǥ"	"ǥ"
.	"dy"	"¤"	"¥"
.	"f"	""	""
.	"fy"	"դ"	"ե"
.	"g"	""	""
.	"gy"	""	""
.	"h"	""	""
.	"hy"	"Ҥ"	"ҥ"
.	"j"	""	""
.	"jy"	""	""
.	"k"	""	""
.	"ky"	""	""
.	"m"	""	""
.	"my"	"ߤ"	"ߥ"
.	"n"	""	""
.	"ny"	"ˤ"	"˥"
.	"p"	""	""
.	"py"	"Ԥ"	"ԥ"
.	"r"	""	""
.	"ry"	""	""
.	"s"	""	""
.	"sh"	""	""
.	"sy"	""	""
.	"t"	""	""
.	"th"	"Ƥ"	"ƥ"
.	"ts"	""	""
.	"ty"	""	""
.	"v"	""	""
.	"w"	""	""
.	"x"	""	""
.	"xt"	""	""
.	"xts"	""	""
.	"xy"	""	""
.	"y"	""	""
.	"z"	""	""
.	"zy"	""	""
.	" "	NS	NS
	(_stkdepth() - $0) / 3;

skk_roma_kana_u = init_rk_rule();

%%%% skk_roma_kana_e

	$0 = _stkdepth();
.	NS	""	""
.	"b"	""	""
.	"by"	"Ӥ"	"ӥ"
.	"ch"	""	""
.	"cy"	""	""
.	"d"	""	""
.	"dh"	"Ǥ"	"ǥ"
.	"dy"	"¤"	"¥"
.	"f"	"դ"	"ե"
.	"fy"	"դ"	"ե"
.	"g"	""	""
.	"gy"	""	""
.	"h"	""	""
.	"hy"	"Ҥ"	"ҥ"
.	"j"	""	""
.	"jy"	""	""
.	"k"	""	""
.	"ky"	""	""
.	"m"	""	""
.	"my"	"ߤ"	"ߥ"
.	"n"	""	""
.	"ny"	"ˤ"	"˥"
.	"p"	""	""
.	"py"	"Ԥ"	"ԥ"
.	"r"	""	""
.	"ry"	"ꤧ"	"ꥧ"
.	"s"	""	""
.	"sh"	""	""
.	"sy"	""	""
.	"t"	""	""
.	"th"	"Ƥ"	"ƥ"
.	"ty"	""	""
.	"v"	""	""
.	"w"	""	""
.	"x"	""	""
.	"xk"	""	""
.	"xw"	""	""
.	"y"	""	""
.	"z"	""	""
.	"zy"	""	""
.	" "	NS	NS
	(_stkdepth() - $0) / 3;

skk_roma_kana_e = init_rk_rule();

%%%% skk_roma_kana_o

	$0 = _stkdepth();
.	NS	""	""
.	"b"	""	""
.	"by"	"Ӥ"	"ӥ"
.	"ch"	""	""
.	"cy"	""	""
.	"d"	""	""
.	"dh"	"Ǥ"	"ǥ"
.	"dy"	"¤"	"¥"
.	"f"	"դ"	"ե"
.	"fy"	"դ"	"ե"
.	"g"	""	""
.	"gy"	""	""
.	"h"	""	""
.	"hy"	"Ҥ"	"ҥ"
.	"j"	""	""
.	"jy"	""	""
.	"k"	""	""
.	"ky"	""	""
.	"m"	""	""
.	"my"	"ߤ"	"ߥ"
.	"n"	""	""
.	"ny"	"ˤ"	"˥"
.	"p"	""	""
.	"py"	"Ԥ"	"ԥ"
.	"r"	""	""
.	"ry"	""	""
.	"s"	""	""
.	"sh"	""	""
.	"sy"	""	""
.	"t"	""	""
.	"th"	"Ƥ"	"ƥ"
.	"ty"	""	""
.	"v"	""	""
.	"w"	""	""
.	"x"	""	""
.	"xy"	""	""
.	"y"	""	""
.	"z"	""	""
.	"zy"	""	""
.	" "	NS	NS
	(_stkdepth() - $0) / 3;

skk_roma_kana_o = init_rk_rule();

%%%% skk_kana_rom_vector
%  "*kana to roman conversion giving only the first roman character
%corresponding to the following kana characters.  For the characters
%֤, ֤,֤ա, you might want to change the values for them to
%\"z\", \"c\", \"f\".
%                                  
%                                  
%                                  
%                                  
%                                  
%        ")

	$0 = _stkdepth();

.	'x' 'a' 'x' 'i' 'x' 'u' 'x' 'e' 'x' 'o' 'k' 'g' 'k' 'g' 'k' 'g'
.	'k' 'g' 'k' 'g' 's' 'z' 's' 'j' 's' 'z' 's' 'z' 's' 'z' 't' 'd'
.	't' 'd' 'x' 't' 'd' 't' 'd' 't' 'd' 'n' 'n' 'n' 'n' 'n' 'h' 'b'
.	'p' 'h' 'b' 'p' 'h' 'b' 'p' 'h' 'b' 'p' 'h' 'b' 'p' 'm' 'm' 'm'
.	'm' 'm' 'x' 'y' 'x' 'y' 'x' 'y' 'r' 'r' 'r' 'r' 'r' 'x' 'w' 'x'
.	'x' 'w' 'n'

	(_stkdepth() - $0);

skk_kana_rom_vector = create_array1('i');

%%%% skk_char_type_vector

	$0 = _stkdepth();

.  0 0 0 0 0 0 0 0
.  5 0 0 0 0 0 0 0
.  0 0 0 0 0 0 0 0
.  0 0 0 0 0 0 0 0
.  0 0 0 0 0 0 0 0
.  0 0 0 0 0 0 0 0
.  0 0 0 0 0 0 0 0
.  0 0 0 0 0 0 0 0
.  0 4 4 4 4 4 4 4
.  4 4 4 4 0 4 4 4
.  4 0 4 4 4 4 4 4
.  0 4 4 0 0 0 0 0
.  0 3 1 1 1 3 1 1
.  1 3 1 1 0 1 2 3
.  1 0 1 1 1 3 1 1
.  2 1 1 0 0 0 0 5

	(_stkdepth() - $0);

variable skk_char_type_vec = create_array1('i');

%%%% skk_input_vector

	$0 = _stkdepth();
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	""	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	""	""	""	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	""	""	NS	NS	NS	""
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	""	NS	""	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
	(_stkdepth() - $0);

skk_input_vector = create_array1('s');

%%%% skk_zenkaku_vector

	$0 = _stkdepth();
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	NS	NS	NS	NS	NS	NS	NS	NS
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	""
.	""	""	""	""	""	""	""	NS
	(_stkdepth() - $0);

skk_zenkaku_vector = create_array1('s');

define add_rule ()
{
	skk_rule[$0, 4] = (); 
	skk_rule[$0, 3] = (); 
	skk_rule[$0, 2] = (); 
	skk_rule[$0, 1] = (); 
	skk_rule[$0, 0] = (); 

	++$0;
}

%%%% skk_rom_kana_rule_list

skk_rule = String_Type[20, 5];

	$0 = 0;

.	"nn"	NS	""	""	End_type	add_rule
.	"n'"	NS	""	""	End_type	add_rule

	% example: "skk" -> "skk", "skK" -> "SKK"

%.	"sk"	"sk"	NS	NS	Next_type	add_rule
%.	"skk"	NS	"skk"	"skk"	End_type	add_rule
%.	"skK"	NS	"SKK"	"SKK"	End_type	add_rule

skk_rule_num = $0;
