% -*- mode: slang; mode: fold -*-
%
%  Copyright (c) 1998 Uichi Katsuta  (katsuta@lang2.bs1.fc.nec.co.jp)
%  All Rights Reserved.
%
% canna_control(request)
%
% request:			    in			out
%  CANNA_INITIALIZE		    			n, string,...
%  CANNA_FINALIZE		    			n, string,...
%  CANNA_CHANGEMODE		   Mode			string, Status
%  CANNA_SETWIDTH		   Width
%  CANNA_SETUNDEFKEYFUNCTION
%  CANNA_SETBUNSETSUKUGIRI          0,1
%  CANNA_SETMODEINFOSTYLE           0,1
%  CANNA_SETHEXINPUTSTYLE
%  CANNA_INHIBITHANKAKUKANA         0,1
%  CANNA_DEFINEKANJI
%  CANNA_KAKUTEI					string, Status
%  CANNA_KILL						string, Status
%  CANNA_MODEKEYS
%  CANNA_QUERYMODE					string
%  CANNA_QUERYCONNECTION
%  CANNA_SETSERVERNAME
%  CANNA_PARSE
%  CANNA_YOMIINFO
%  CANNA_STOREYOMI
%  CANNA_SETINITFILENAME
%  CANNA_DO
%  CANNA_GETCONTEXT
%  CANNA_SETAPPNAME		   string
%
% return:
%  buffer	:  kakutei mojiretsu
%  echoStr	:  local echo string
%  length	:  length of echo string. -1 if unchanged before.
%  revPos	:  position of reverse.
%  revLen	:  length of reverse.
%  mode		:  mode string
%  line		:  kouho ichiran string
%  lineLength   :  length of ichiran string. -1 if unchanged before.
%  lineRevPos	:  position of reverse.
%  lineRevLen	:  length of reverse.

variable CANNA_INITIALIZE	= 0;
variable CANNA_FINALIZE		= 1;
variable CANNA_CHANGEMODE	= 2;
variable CANNA_SETWIDTH		= 3;
%variable CANNA_SETUNDEFKEYFUNCTION = 4;
variable CANNA_SETBUNSETSUKUGIRI = 5;
variable CANNA_SETMODEINFOSTYLE = 6;
%variable CANNA_SETHEXINPUTSTYLE = 7;
variable CANNA_INHIBITHANKAKUKANA = 8;
variable CANNA_DEFINEKANJI	= 9;
%variable CANNA_KAKUTEI		= 10;
%variable CANNA_KILL		= 11;
%variable CANNA_MODEKEYS	= 12;
variable CANNA_QUERYMODE	= 13;
%variable CANNA_QUERYCONNECTION	= 14;
%variable CANNA_SETSERVERNAME    = 15;
%variable CANNA_PARSE		= 16;
%variable CANNA_YOMIINFO	= 17;
%variable CANNA_STOREYOMI	= 18;
%variable CANNA_SETINITFILENAME	= 19;
%variable CANNA_DO		= 20;
%variable CANNA_GETCONTEXT	= 21;
%variable CANNA_CLOSEUICONTEXT	= 22;
%variable CANNA_INHIBITCHANGEMODE = 23;
%variable CANNA_LETTERRESTRICTION = 24;
variable CANNA_QUERYMAXMODESTR	= 25;
variable CANNA_SETAPPNAME	= 30;
variable CANNA_STRING		= 1000;

%variable CANNA_MODE_AlphaMode	= 0; %	/* At@xbg[h */
variable CANNA_MODE_HenkanMode	= 1; %	/* ǂݓ͂Ȃ */
%variable CANNA_MODE_KigoMode	= 2; %	/* Lꗗ\ */
%variable CANNA_MODE_YomiMode	= 3; %	/* ǂݓ͂Ă */
%variable CANNA_MODE_JishuMode	= 4; %	/* ϊĂ */
%variable CANNA_MODE_TankouhoMode = 5; %	/* P\ */
%variable CANNA_MODE_IchiranMode	= 6; %	/* ꗗ\ */
%variable CANNA_MODE_ExtendMode	= 27; %	/* g@\I */

variable CANNA_KEY_Up		= 0x82;
variable CANNA_KEY_Left		= 0x83;
variable CANNA_KEY_Right	= 0x84;
variable CANNA_KEY_Down		= 0x85;
variable CANNA_KEY_Insert	= 0x86;
%variable CANNA_KEY_Rollup	= 0x87;
%variable CANNA_KEY_Rolldown	= 0x88;
%variable CANNA_KEY_Home		= 0x89;
variable CANNA_KEY_Help		= 0x8a;

%_debug_info = 1;
%_traceback = 1;

variable canna_initialized = 0;
variable canna_fence_mode = 0;
variable canna_extend_mode = 0;
variable canna_mode_map = "canna_mode_map";
variable canna_fence_mode_map = "canna_fence_mode_map";
variable canna_minibuffer_map = "canna_minibuffer_map";
variable canna_in_minibuffer;
variable canna_previous_line = "";
%variable canna_ignore_user_abort;

define canna_set_mode_line(mode) {
   set_status_line(strcat(mode, Status_Line_String), 0);
}

variable canna_mode_string;
define canna_is_henkan_mode() {
   return (strcmp(canna_mode_string, canna_control(CANNA_QUERYMODE)) == 0);
}

define canna_do_function(ch) {
   variable mode, revLen, revPos, length, echoStr, buffer, line, lineLength, lineRevPos, lineRevLen;
   variable n;

   ch;  % push ch
   canna_control(CANNA_STRING);
   (buffer, echoStr, length, revPos, revLen, mode, line, lineLength, lineRevPos, lineRevLen) = ();
   if (length == -2) { % error occurs
      error(echoStr);
      return;
   }
   if (canna_fence_mode == 0) {
      canna_fence_mode = 1;
      use_keymap(canna_fence_mode_map);
%      canna_ignore_user_abort = IGNORE_USER_ABORT;
%      IGNORE_USER_ABORT = 1;
%      set_currentbuf_userabort(1);
   } else if (length != -1) {  % delete previous string
      pop_spot();
      push_mark();
      pop_spot();
      del_region();
   }
   insert(buffer);
   if (length > 0) {
      push_spot();
      insert("|");
      insert(echoStr);
      insert("|");
      push_spot();
      if (revLen == 0) {
	 n = left(1);
      } else {
	 n = left(strlen(echoStr) - revPos);
      }
   } else if (andelse {length != -1}
	       {orelse {canna_extend_mode == 0}
		    {andelse {lineRevPos == 0}
			 {canna_is_henkan_mode()}}}){
      canna_fence_mode = 0;
      canna_extend_mode = 0;
      canna_previous_line = "";
%      IGNORE_USER_ABORT = canna_ignore_user_abort;
      if (canna_in_minibuffer) {
	 use_keymap(canna_minibuffer_map);
%	 set_currentbuf_userabort(1);
      } else {
	 use_keymap(canna_mode_map);
      }
   }
   if (strlen(mode) != 0) {
      canna_set_mode_line(mode);
   }
   if (lineLength == -1) {
      line = canna_previous_line;
   } else if (lineRevLen != 0) {
      lineRevPos++;
      line = substr(line, 1, lineRevPos - 1) + "[" 
	+ substr(line, lineRevPos, lineRevLen) + "]"
	+ substr(line, lineRevPos + lineRevLen, -1);
   }
   canna_previous_line = line;
   if (lineLength != 0) {
      message(line);
   }
}

define canna_self_insert_command() {
   canna_do_function(LAST_CHAR);
}

define canna_setmode(n) {
   n;
   canna_control(CANNA_CHANGEMODE);
}

define canna_help_key() {
   canna_extend_mode = 1;
   canna_do_function(CANNA_KEY_Help);
}

define canna_ins_key() {
   canna_extend_mode = 1;
   canna_do_function(CANNA_KEY_Insert);
}

define canna_up_key() {
   canna_do_function(CANNA_KEY_Up);
}

define canna_down_key() {
   canna_do_function(CANNA_KEY_Down);
}

define canna_right_key() {
   canna_do_function(CANNA_KEY_Right);
}

define canna_left_key() {
   canna_do_function(CANNA_KEY_Left);
}

define canna_bs_key() {
   canna_do_function(8);  % ^h
}                                                                              

define canna_define_function_keymap(map) {
   definekey("canna_bs_key", string(char(127)), map);                          
#ifdef OS2
   definekey("canna_up_key", "^@H", map);
   definekey("canna_down_key", "^@P", map);
   definekey("canna_right_key", "^@M", map);
   definekey("canna_left_key", "^@K", map);
#else
   definekey("canna_up_key", "^[[A", map);
   definekey("canna_down_key", "^[[B", map);
   definekey("canna_right_key", "^[[C", map);
   definekey("canna_left_key", "^[[D", map);
#endif
}

variable canna_self_insert = "canna_self_insert_command";
define canna_define_control_keymap(map) {
   variable i;
   for (i = 64; i < 90; i++) {  % define control key
      if (i == 88) {  % exclude "^x"
	 continue;
      }
      definekey(canna_self_insert, strcat("^", string(char(i))), map);
   }
}

define canna_define_alphabet_keymap(map) {
   variable i;
   for (i = 32; i < 127; i++) {
      definekey(canna_self_insert, string(char(i)), map);
   }
   definekey("canna_mode", "^\\", map);
#ifdef OS2
   definekey("canna_help_key", "^@O", map);  % HOME key
   definekey("canna_ins_key", "^@R", map);  % INS key
#else
   definekey("canna_help_key", "^[[H", map);  % HOME key
   definekey("canna_ins_key", "^[[L", map);  % INS key
#endif
}

define canna_setup_keymap() {
   make_keymap(canna_mode_map);
   canna_define_alphabet_keymap(canna_mode_map);
   make_keymap(canna_minibuffer_map);
   canna_define_alphabet_keymap(canna_minibuffer_map);
   definekey("canna_keyboard_quit", "^G", canna_minibuffer_map);
   definekey("canna_newline", "^M", canna_minibuffer_map);
   make_keymap(canna_fence_mode_map);
   canna_define_control_keymap(canna_fence_mode_map);
   canna_define_alphabet_keymap(canna_fence_mode_map);
   canna_define_function_keymap(canna_fence_mode_map);
}

variable canna_popup_buffer = "*canna warning*";
define canna_warning () {
   variable n;
   variable str, buf;
   n = ();
   if (n != 0) {
      buf = pop2buf_whatbuf(canna_popup_buffer);
      loop(n) {
	 str = ();
	 insert(str);
	 insert("\n");
      }
      otherwindow();
      sw2buf(buf);
   }
}

define canna_getmode() {
   canna_control(CANNA_QUERYMODE);
   % return str;
}

define canna_finalize() {
   canna_control(CANNA_FINALIZE);
   canna_warning();
}

define canna_setapp_name (name) {
   name;
   canna_control(CANNA_SETAPPNAME);
}

define canna_setwidth (n) {
   n;
   canna_control(CANNA_SETWIDTH);
}

% buffer local arrays
variable CANNA_MAX_BUF = 10;
variable canna_mode_on;
variable canna_current_local_map;
define canna_initialize() {
   variable i;
   flush("wȁxĂ܂...");
   canna_control(CANNA_INITIALIZE);
   canna_warning();
   1;
   canna_control(CANNA_SETBUNSETSUKUGIRI);
   canna_setup_keymap();
   canna_setapp_name(Sprintf("jed(%d)", getpid(), 1));
   canna_setwidth(SCREEN_WIDTH - 2);
   if (han_to_zen) {
      1;
      canna_control(CANNA_INHIBITHANKAKUKANA);
   }
   canna_mode_on = Integer_Type[CANNA_MAX_BUF];
   for (i = 0; i < CANNA_MAX_BUF; i++) {
      canna_mode_on[i] = 0;
   }
   canna_current_local_map = String_Type[CANNA_MAX_BUF];
   message("wȁxĂ܂...done");
}

variable canna_buf_number = 0;  % 0 means minibuffer
define canna_get_buf_id() {  % return -1 if cannot get more id.
   if (MINIBUFFER_ACTIVE) {
      canna_in_minibuffer = 1;
      return 0;
   }
   canna_in_minibuffer = 0;
   ERROR_BLOCK {
      _clear_error();
      if (canna_buf_number >= CANNA_MAX_BUF) {
	 message("Canna can not be used in any more buffer. Sorry...");
	 return -1;
      }
      create_blocal_var("canna_buf_id", 'i');
      canna_buf_number++;
      set_blocal_var(canna_buf_number, "canna_buf_id");
      return canna_buf_number;
   }
   return get_blocal_var("canna_buf_id");
}

define canna_force_on(id) {
   variable mode, revLen, revPos, length, echoStr, buffer, line, lineLength, lineRevPos, lineRevLen;
   canna_mode_on[id] = 1;
   canna_current_local_map[id] = what_keymap();
   canna_setmode(CANNA_MODE_HenkanMode);
   (buffer, echoStr, length, revPos, revLen, mode, line, lineLength, lineRevPos, lineRevLen) = ();
%   mode = canna_getmode();
   if (strlen(mode) != 0) {
      canna_mode_string = mode;
   }
   canna_set_mode_line(canna_mode_string);
   if (canna_in_minibuffer) {
      use_keymap(canna_minibuffer_map);
%     set_currentbuf_userabort(1);
   } else {
      use_keymap(canna_mode_map);
   }
}

define canna_force_off(id) {
   use_keymap(canna_current_local_map[id]);
   canna_set_mode_line("");
   canna_mode_on[id] = 0;
}

define canna_mode() {
   variable id;

   if (canna_initialized == 0) {
      canna_initialized = 1;
      canna_initialize();
   }
   id = canna_get_buf_id();
   if (id < 0) {
      return;
   }
   if (canna_mode_on[id] == 0) {
      canna_force_on(id);
      set_currentbuf_userabort(1);
   } else {
      canna_force_off(id);
      set_currentbuf_userabort(-1);
   }
}

define canna_keyboard_quit() {  % for minibuffer
   canna_force_off(canna_get_buf_id());
   call("kbd_quit");
}

define canna_newline() {  % for minibuffer
   canna_force_off(canna_get_buf_id());
   call("exit_mini");
}

define exit_hook() {
   canna_finalize();
   exit_jed();
}

define canna_touroku_region () {
   variable mode, revLen, revPos, length, echoStr, buffer, line, lineLength, lineRevPos, lineRevLen;
   variable id;

   if (canna_initialized == 0) {
      canna_initialized = 1;
      canna_initialize();
   }
   id = canna_get_buf_id();
   if (id < 0) {
      return;
   }
   if (canna_mode_on[id] == 0) {
      canna_force_on(id);
   }
   bufsubstr();
   canna_control(CANNA_DEFINEKANJI);
   (buffer, echoStr, length, revPos, revLen, mode, line, lineLength, lineRevPos, lineRevLen) = ();
   canna_extend_mode = 1;
   if (strlen(mode) != 0) {
      canna_set_mode_line(mode);
   }
   if (lineLength == -1) {
      line = canna_previous_line;
   } else if (lineRevLen != 0) {
      lineRevPos++;
      line = substr(line, 1, lineRevPos - 1) + "[" 
	+ substr(line, lineRevPos, lineRevLen) + "]"
	+ substr(line, lineRevPos + lineRevLen, -1);
   }
   canna_previous_line = line;
   if (lineLength != 0) {
      message(line);
   }
}

definekey("canna_mode", "^\\", "global");
