/*  Gaby
 *  Copyright (C) 1998-1999 Frederic Peters
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gaby.h"
#include "f_desc.h"
#include "f_config.h"
#include "gtk_dialogs.h"

#if 0
static gchar* print_plugin_ok(char *filename, char *name)
{
	PrintPluginData *az = g_new0(PrintPluginData, 1);
	char *res = NULL;
	char dirname[PATH_MAX];
	char n[PATH_MAX];
	FILE *f;

	az->handle = g_module_open(filename, 0);
	if ( az->handle == NULL )
		return NULL;

	g_module_symbol(az->handle, "init_print_plugin", \
			(gpointer *)&az->init_print_plugin);
	if ( az->init_print_plugin == NULL )
		return NULL;
	
	if ( az->init_print_plugin(az) ) {
		sprintf(dirname, "%s/print/infos", PLUGINS_DIR);
		f = fopen(dirname, "r");
		strcpy(n, strrchr(filename, '/')+1+3);
		strchr(n, '.')[0] = 0;
		strcpy(dirname, n);
#ifdef DEBUG_GABY
		debug_print("[print_plugin_ok] n : %s\n", n);
#endif
		res = get_plugin_real_name(1, f, dirname);
		/* i18n_name + ' ' + name */
		strcpy(dirname+strlen(dirname)+1, n );
		dirname[strlen(dirname)] = ' ';
		fclose(f);
		return g_strdup(dirname);
	} else {
		g_module_close(az->handle);
		return NULL;
	}

}

GList* print_plugin_get_list(gchar *name)
{
	GList *list = NULL;
	char dirname[PATH_MAX];
	char filename[PATH_MAX];
	DIR *dir;
	struct dirent *ent;
	char *plugin_name;
	
	/* 
	 * why not allow the user to have the possibility to store plug-ins
	 * in his/her home directory (~/.gaby/plug-ins/...), this could be
	 * useful for non-root user who'd like to create one when root
	 * installed Gaby in a read-only directory
	 */
	sprintf(dirname, "%s/print", PLUGINS_DIR );
	
	dir = opendir(dirname);
	if ( dir == NULL ) { /* uh oh*/
		sprintf(filename, _("You don't have %s."), dirname);
		gaby_errno = CUSTOM_WARNING;
		gaby_perror_in_a_box();
		return NULL;
	}
	
	while ( 1 ) {
		ent = readdir(dir);
		if ( ent == NULL ) break;
		if ( strncmp(ent->d_name, "lib", 3) == 0 && \
			strncmp( ent->d_name + strlen(ent->d_name) - 3, \
				".so", 3) == 0 ) {
			sprintf(filename, "%s/%s", dirname, ent->d_name);
#ifdef DEBUG_GABY
			debug_print("[ppgl] Is %s ok ?\n", filename);
#endif
			plugin_name = print_plugin_ok(filename, name);
			if ( plugin_name != NULL ) {
				list = g_list_append(list, plugin_name);
			}
		}
	}

	closedir(dir);

	return list;
}

#endif /* 0 */

static void close_dialog(GtkWidget *but, GtkWidget *dialog)
{
#ifdef USE_GNOME
	gnome_dialog_close(GNOME_DIALOG(dialog));
#else
	gtk_widget_destroy(dialog);
#endif
}

static void print_real(GtkWidget *but, GtkWidget *dialog)
{
	GtkCList *list = gtk_object_get_data(GTK_OBJECT(dialog), "list");
	GList *subtables = list_subtables;
	PrintPluginData *ppd = gtk_object_get_data(GTK_OBJECT(dialog), "ppd");
	int row;
	gchar *text;
	subtable *st;
	char filename[PATH_MAX];
	char message[1000];
	
#ifdef DEBUG_GABY
	debug_print("[print_real] ppd : %p (%s)\n", ppd, ppd->name);
#endif
	if ( list->selection == NULL ) {
		gaby_message = g_strdup(_("You have to select a subtable."));
		gaby_errno = CUSTOM_ERROR;
		gaby_perror_in_a_box();
		return;
	}

	row = GPOINTER_TO_INT(list->selection->data);
	gtk_clist_get_text(list, row, 0, &text);

	st = get_subtable_pointer(subtables, text);

	if ( st == NULL ) /* this shouldn't happen */
		return;

#ifndef FOLLOW_MIGUEL
	if ( ppd->loaded == 0 ) {
#if 0
		sprintf(filename, "%s/print/lib%s.so", PLUGINS_DIR, ppd->name);
#else
		sprintf(filename, PLUGINS_DIR "/print/lib%s.so", ppd->name);
#endif
		ppd->handle = g_module_open(filename, 0);
		if ( ppd->handle == NULL ) {
			gaby_errno = LOAD_PLUGIN_ERROR;
			gaby_message = g_strdup(filename);
			gaby_perror_in_a_box();
			return;
		}
		ppd->loaded++;
	}

	g_module_symbol(ppd->handle, "init_print_plugin",
				(gpointer*)&ppd->init_print_plugin );
	if ( ppd->init_print_plugin == NULL ) {
		char fct_name[1000];
		sprintf(fct_name, "%s_init_print_plugin", ppd->name);
		g_module_symbol(ppd->handle, fct_name,
				(gpointer*)&ppd->init_print_plugin );
		if ( ppd->init_print_plugin == NULL ) {
			g_error("aie aie aie in print plug-in loading, "
				"please warn fpeters@win.be\n");
			close_dialog(but, dialog);
			return;
		}
	}
	ppd->init_print_plugin(ppd);
#endif
	
	if ( get_config_bool("common", "print", "fast", FALSE) ) {
		sprintf(filename, "%s_output", appname);
		ppd->print_fast(st, filename, NULL, &ppd->loaded);
		sprintf(message, _("Output is now in %s."), filename);
		gaby_message = g_strdup(message);
		gaby_errno = CUSTOM_MESSAGE;
		gaby_perror_in_a_box();
	} else {
		ppd->print(st, NULL, NULL, &ppd->loaded);
	}

	close_dialog(but, dialog);
	
}

static void row_changed( GtkCList *clist, gint row, gint column,
			 GdkEventButton *event, GtkWidget *wid)
{
#ifdef USE_GNOME
	gnome_dialog_set_sensitive(GNOME_DIALOG(wid), 0, \
					( clist->selection != NULL ) );
#else
	gtk_widget_set_sensitive(wid, ( clist->selection != NULL ) );
#endif
}

GtkWidget* print_dialog(PrintPluginData *ppd)
{
	static GtkWidget *dialog = NULL;
	GtkWidget *vbox, *list, *label;
#ifndef USE_GNOME
	GtkWidget *buttonok;
	GtkWidget *button;
#endif
	GList *tmp;
	char title[100];
	
/*
	sprintf(plugin_file, "%s/print/lib%s.so", PLUGINS_DIR, ppd->name );
#ifdef DEBUG_GABY
	debug_print("[print_dialog] plugin : %s\n", plugin_file);
#endif
*/
#ifdef DEBUG_GABY
	debug_print("[print_dialog] ppd : %p (%s)\n", ppd, ppd->name);
#endif

	if ( GTK_IS_WINDOW(dialog) == TRUE ) {
		gdk_window_raise((GdkWindow*)dialog->window);
		return dialog;
	}
	
	sprintf(title, "%s %s", _("Printing to"), ppd->i18n_name);
		
#ifdef USE_GNOME
	dialog = gnome_dialog_new(title, \
			GNOME_STOCK_BUTTON_OK, \
			GNOME_STOCK_BUTTON_CANCEL, \
			NULL);
	
	gnome_dialog_button_connect(GNOME_DIALOG(dialog), 0, \
				GTK_SIGNAL_FUNC(print_real), dialog );
	gnome_dialog_button_connect(GNOME_DIALOG(dialog), 1, \
				GTK_SIGNAL_FUNC(close_dialog), dialog );
	
	vbox = GNOME_DIALOG(dialog)->vbox;
	
	gnome_dialog_close_hides(GNOME_DIALOG(dialog), FALSE);
	
#else /* ! USE_GNOME */
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	vbox = GTK_DIALOG(dialog)->vbox;

	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5 );
	
	button = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), \
					button, TRUE, TRUE, 0 );
	gtk_signal_connect(GTK_OBJECT(button), "clicked", \
				GTK_SIGNAL_FUNC(print_real), dialog );
	buttonok = button;
	
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), \
					button, TRUE, TRUE, 0 );
	gtk_signal_connect(GTK_OBJECT(button), "clicked", \
				GTK_SIGNAL_FUNC(close_dialog), dialog );
#endif /* ! USE_GNOME */
	
	label = gtk_label_new(_("Select the subtable you want to print"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 2 );
			
#ifdef DEBUG_GABY
	debug_print("[print_dialog] ppd : %p (%s)\n", ppd, ppd->name);
#endif
	list = gtk_clist_new(1);
	tmp = g_list_first(list_subtables);
	while ( tmp != NULL ) {
		gtk_clist_append(GTK_CLIST(list), \
				&((subtable*)tmp->data)->i18n_name );
		tmp = g_list_next(tmp);
	}
	gtk_widget_show(list);

#ifdef USE_GNOME
	gtk_signal_connect(GTK_OBJECT(list), "select_row", \
						row_changed, dialog );
	gtk_signal_connect(GTK_OBJECT(list), "unselect_row", \
						row_changed, dialog );
	row_changed(GTK_CLIST(list), 0, 0, NULL, dialog);
#else
	gtk_signal_connect(GTK_OBJECT(list), "select_row", \
						row_changed, buttonok );
	gtk_signal_connect(GTK_OBJECT(list), "unselect_row", \
						row_changed, buttonok );
	row_changed(GTK_CLIST(list), 0, 0, NULL, buttonok);
#endif
	
	gtk_box_pack_start(GTK_BOX(vbox), list, TRUE, TRUE, 2 );
	
#ifdef DEBUG_GABY
	debug_print("[print_dialog] ppd : %p (%s)\n", ppd, ppd->name);
#endif
	gtk_object_set_data(GTK_OBJECT(dialog), "ppd", ppd);
	gtk_object_set_data(GTK_OBJECT(dialog), "list", list);
		
	return dialog;
}

