/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

#include "trtab.h"


#define TRTAB_SIZE 23


static unsigned int 
trhash(hashtab_key_t key)
{
	tr_key_t       *keyp;


	keyp = (tr_key_t *) key;

	return (keyp->source_type + (keyp->target_type << 4) + (keyp->object_class << 8)) % TRTAB_SIZE;
}


static int 
trcmp(hashtab_key_t key1, hashtab_key_t key2)
{
	tr_key_t       *keyp1, *keyp2;


	keyp1 = (tr_key_t *) key1;
	keyp2 = (tr_key_t *) key2;

	return !((keyp1->source_type == keyp2->source_type) &&
		 (keyp1->target_type == keyp2->target_type) &&
		 (keyp1->object_class == keyp2->object_class));
}


int 
trtab_init(trtab_t * t)
{
	t->table = hashtab_create(trhash, trcmp, TRTAB_SIZE);
	if (!t->table)
		return -1;
	t->nel = 0;
	return 0;
}


/* FLASK */
