/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/* FLASK */

#ifndef _AVTAB_H_
#define _AVTAB_H_

#include "avdeftab.h"

typedef struct
{
    unsigned int source_type;
    unsigned int target_type;
    unsigned int target_class;
} avtab_key_t;


typedef struct
{
#define AVTAB_ALLOWED    1
#define AVTAB_AUDITALLOW 2
#define AVTAB_AUDITDENY  4
#define AVTAB_NOTIFY     8
    int specified;
    access_vector_t allowed;
#ifdef CONFIG_FLASK_AUDIT
    access_vector_t auditallow;
    access_vector_t auditdeny;
#endif
#ifdef CONFIG_FLASK_NOTIFY
    access_vector_t notify;
#endif
    avdef_datum_t   *avdefdatum;    /* corresponding access vector definition */
} avtab_datum_t;


typedef struct avtab_node_t* avtab_ptr_t;

struct avtab_node_t
{
    avtab_key_t key;
    avtab_datum_t datum;
    avtab_ptr_t next;			       /* link to next node in chain */
};

#define AVTAB_SIZE 1013

typedef struct
{
    avtab_ptr_t htable[AVTAB_SIZE];
    unsigned int nel;		/* number of elements */
    unsigned int ncons;         /* number of constrained elements */
} avtab_t;

int avtab_init(avtab_t *);

int avtab_insert(avtab_t *h, avtab_key_t *k, avtab_datum_t *d);
avtab_datum_t *avtab_search(avtab_t *h, avtab_key_t *k);
void avtab_destroy(avtab_t *h);
int avtab_map(avtab_t *h,
		int (*apply)(avtab_key_t *k,
			     avtab_datum_t *d,
			     void *args),
		void *args);

void avtab_hash_eval(avtab_t *h, char *progname, char *table);

#endif _AVTAB_H_

/* FLASK */
