/*
 * Copyright (c) 1994-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Traditional BSD string functions,
 * not defined in ANSI or POSIX but included in Unix CAE.
 * It is preferable to use the ANSI functions in <string.h> in new code.
 */
#ifndef _OSKIT_C_STRINGS_H_
#define _OSKIT_C_STRINGS_H_

#include <oskit/compiler.h>

OSKIT_BEGIN_DECLS

int bcmp(const void *s1, const void *s2, oskit_size_t n);
void bcopy(const void *from, void *to, oskit_size_t n);
void bzero(void *to, oskit_size_t n);

int ffs(int i);

char *index(const char *s, int c);
char *rindex(const char *s, int c);

int strcasecmp(const char *s1, const char *s2);
int strncasecmp(const char *s1, const char *s2, oskit_size_t n);

/* This isn't in the CAE manual... */
char *strsep(char **stringp, char *delim);

OSKIT_END_DECLS

#endif _OSKIT_C_STRINGS_H_
