/*
 * Copyright (c) 1997-1999 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * this is an example of how to use timer interrupts
 * it took me 10 minutes to write
 */
#include <oskit/dev/dev.h>
#include <oskit/c/stdio.h>
#include <oskit/c/setjmp.h>
#include <oskit/c/stdlib.h>
#include <oskit/clientos.h>

/* these things should be defined elsewhere, I think */
#define TIMER_FREQ 100
extern void osenv_timer_init();

/* we don't really need that longjmp */
static jmp_buf done;

void handler()
{
	static count = 0, sec=0;
	if (++count >= 100) {
		count = 0;
		if (++sec > 10) 
			longjmp(done, 1);
		printf("%d second(s)\n", sec);
	}
}

int main(int ac, char *av[])
{
	oskit_clientos_init();
	/* The clock code needs an osenv */
	start_osenv();

	/* initialize timers */
	osenv_timer_init();

	printf("Counting to ten\n");

	/* register our handler */
	osenv_timer_register(handler, TIMER_FREQ);

	/* wait and exit */
	if (! setjmp(done))
		while (1)
			continue;

	printf("ALL DONE\n");
	exit(0);
}
