/*
 * include/chos.h
 * 
 * Choose-OS common definitions.
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 */
#ifndef _CHOS_H
#define _CHOS_H

#ifndef __ASSEMBLY__
 // These should be somewhere standard...
 #define ulong	unsigned long
 #define uint	unsigned int
 #define ushort	unsigned short
 #define uchar	unsigned char
#endif


#define CHOS_MAJOR	0		// major			
#define CHOS_MINOR	84		// minor			
#define CHOS_VERSIONSTR	"0.84"		// as a string			

#define CHOS_BSECT	1
#define CHOS_LOADER	2
#define CHOS_MAPFILE	3
#define CHOS_MODULE(x)	((x)|0x10)

#define	PARTTABLE_OFF	446		// where partition table starts
#define BOOTSECT_VALID	0xAA55		// valid bootsector signature	

#define SECTORSIZE	512l

#define STAGE2SECTS	5		// changes needed if bigger

#define MAX_INITRD_SIZE	65535		// in sectors

// Boot image Types
//
#define BIT_UNKNOWN	0		// unknown = invalid
#define BIT_BOOTSECT	1		// boot sector	(DOS)  
#define BIT_LINUX	2		// Linux

// Devices
//
#define	MAJOR_FD	2		// floppy major
#define MAJOR_HD	3		// ide hd major
#define MAJOR_SD	8		// scsi hd major
#define MAJOR_XT	13		// hmmm....
#define MAJOR_IDE2	22		// second ide interface

#define INT13H_LOAD	0x2
#define INT13H_WRITE 	0x3
#define INT13H_RESET	0x0
#define INT13H_GEO	0x8

#ifndef __ASSEMBLY__
typedef struct{
	char	code[2];
	char	id[3];
	char	type;
	char	major,minor;
}ChosHeader;
#endif
#endif /* _CHOS_H */