/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.apps;

import com.jtauber.fop.Version;
import com.jtauber.fop.apps.ErrorHandler;
import com.jtauber.fop.apps.FOPException;
import com.jtauber.fop.fo.FOTreeBuilder;
import com.jtauber.fop.fo.StandardElementMapping;
import com.jtauber.fop.layout.AreaTree;
import com.jtauber.fop.layout.FontInfo;
import com.jtauber.fop.render.Renderer;
import com.jtauber.fop.render.pdf.PDFRenderer;
import com.jtauber.fop.svg.SVGElementMapping;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class FOProcessor {
    protected FOTreeBuilder treeBuilder;
    protected Renderer renderer;
    protected ErrorHandler errorHandler;

    protected FOProcessor() {
        this(new PDFRenderer(Version.getVersion()));
    }

    protected FOProcessor(Renderer renderer) {
        this.renderer = renderer;
        this.treeBuilder = new FOTreeBuilder();
        StandardElementMapping.addToBuilder(this.treeBuilder);
        SVGElementMapping.addToBuilder(this.treeBuilder);
    }

    public abstract void format(PrintWriter var1) throws FOPException;

    protected final void layoutput(PrintWriter printWriter) throws FOPException {
        FontInfo fontInfo = new FontInfo();
        this.renderer.setupFontInfo(fontInfo);
        AreaTree areaTree = new AreaTree();
        areaTree.setFontInfo(fontInfo);
        this.treeBuilder.format(areaTree);
        try {
            this.renderer.render(areaTree, printWriter);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException.getMessage());
        }
    }
}

