
#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"
/* #define GDEBUG */


struct readkey
{
      char table[33];
      char nonUnique[2];
      char keyName[33];
      char seq[3];
      char columnName[33];
      char collation[2];
      char cardinality[6];
      char subPart[6];
      struct readkey *next;
};


extern struct setup Setup;
extern struct stat Stat;

extern char *createtable_indexToType(int type);
extern int createtable_typeToIndex(char *type);
extern void createtable_copyfield(struct fields *dest, struct fields *src);

void browsetable_freeList(struct browsetable *it);
void browsetable_getColumns(struct browsetable *it);
void browsetable_getKeys(struct browsetable *it);
void browsetable_setKeys(struct browsetable *it, struct readkey *rkf);
void browsetable_freeSQL(struct browsetable *it);
void browsetable_addSQL(struct browsetable *it, char *sql);
void browsetable_execSQL(struct browsetable *it);
void browsetable_setactive(struct browsetable *it);
void browsetable_setOrder(struct browsetable *it);    /* prepare le choix order by */
void  browsetable_setFields(struct browsetable *it);   /* prepare le browser fields */
void browsetable_closeinput(FL_OBJECT *obj, long data);
void browsetable_makeForm(struct browsetable *it, int type);
void browsetable_modinput(FL_OBJECT *obj, long data);
void browsetable_addinput(FL_OBJECT *obj, long data);
void browsetable_callbackinput(FL_OBJECT *obj, long data);
void browsetable_searchinput(FL_OBJECT *obj, long data);

void browsetable_setactive(struct browsetable *it) 
{ 
   g_activate_form(it->browse->browsetable);
   /* desactive tous les champs */ 
   /* g_deactivate_object(it->browse->database); */
   g_deactivate_object(it->browse->table); 
   g_deactivate_object(it->browse->limitstart);
   g_deactivate_object(it->browse->limitcount); 
   g_deactivate_object(it->browse->previous);
   g_deactivate_object(it->browse->next);
   g_deactivate_object(it->browse->save);
   g_deactivate_object(it->browse->search);
   g_deactivate_object(it->browse->add);
   g_deactivate_object(it->browse->mod);
   g_deactivate_object(it->browse->del);
   g_deactivate_object(it->browse->delall);
   g_deactivate_object(it->browse->order);
   g_deactivate_object(it->browse->go);
   g_deactivate_object(it->browse->browser);
   g_deactivate_object(it->browse->fields);

   /*---------------------------------------------------------*/
   /*---------------------------------------------------------*/
   /*---------------------------------------------------------*/
   /* active les objects selon l'etat des donnees sur l'ecran */
   /*---------------------------------------------------------*/
   /*---------------------------------------------------------*/
   /*---------------------------------------------------------*/

   /*--------------------------------------------------------------*/
   /* si une banque de donnee est selectionnee active object table */
   /*--------------------------------------------------------------*/
   if(fl_get_choice(it->browse->database) > 1)
   {
      g_activate_object(it->browse->table); 
      
      /*------------------------------------------------------*/
      /* si table est selectionnee, active order by et fields */
      /*------------------------------------------------------*/
      if(fl_get_choice(it->browse->table) > 1)
      {
	 g_activate_object(it->browse->order);
	 g_activate_object(it->browse->fields);
	 g_activate_object(it->browse->add);

	 /*-----------------------------------------------------------*/
	 /* si order by et fields est selectionne active limits et go */
	 /*-----------------------------------------------------------*/
	 if(fl_get_choice(it->browse->order) > 1)
	 {
	    int i;
	    int t; /* total de lignes du browser fields */
	    int c; /* nombre de lignes selectionnees    */

	    t = fl_get_browser_maxline(it->browse->fields);
	    for(i = 2, c = 0; i <= t; i++)
	    {
	       if(fl_isselected_browser_line(it->browse->fields, i))
		  c++;
	    } /* fin de bouche cherchant les lignes selectionnees dans fields */
	    
	    if(c > 0) /* si des champs dans fields sont selectionnes */
	    {
	       g_activate_object(it->browse->limitstart);
	       g_activate_object(it->browse->limitcount);
	       g_activate_object(it->browse->previous);
	       g_activate_object(it->browse->next);
	       g_activate_object(it->browse->go);
	       g_activate_object(it->browse->delall);
	       g_activate_object(it->browse->search);

	       /*---------------------------------------------------------*/
	       /* compte le nombre de lignes selectionnes dans le browser */
	       /*---------------------------------------------------------*/
	       t = fl_get_browser_maxline(it->browse->browser);

	       /*-----------------------------------------------------------*/
	       /* s'il y a quelque chose dans browser, active print et save */
	       /*-----------------------------------------------------------*/
	       if(t)
	       {
		  g_activate_object(it->browse->browser);
		  g_activate_object(it->browse->save);
	       }

	       for(i = 1, c = 0; i <= t; i++)
	       {
		  if(fl_isselected_browser_line(it->browse->browser, i))
		     c++;
	       } /* fin de bouche cherchant les lignes selectionnees dans browser */
	    
	       /*------------------------------------------------------------------------------*/
	       /* si une seule ligne est selectionnee, active le champ modifie si champ unique */
	       /*------------------------------------------------------------------------------*/
	       if(c == 1) /* si une ligne est selectionnee */
	       {
		  /* verifie si au moins un des champs selectionnes est unique */
		  struct fields *cur;
		  int unique = 0;
		  cur = it->firstf;
		  while(cur)
		  {
		     if(cur->select && (cur->keyType == 'U' || cur->keyType == 'P'))
		     {
			unique++;
		     }
		     cur = cur->next;
		  }
		  if(unique)
		  {
		     g_activate_object(it->browse->mod);
		     g_activate_object(it->browse->del);
		  }
	       } /* fin de si une ligne est selectionnee */
	       /*-------------------------------------------------------------------------------------*/
	       /* si plus d'une seule ligne est selectionnee, active le champ modifie si champ unique */
	       /*-------------------------------------------------------------------------------------*/
	       if(c > 1) /* si plus une ligne est selectionnee */
	       {
		  /* verifie si au moins un des champs selectionnes est unique */
		  struct fields *cur;
		  int unique = 0;
		  cur = it->firstf;
		  while(cur)
		  {
		     if(cur->select && (cur->keyType == 'U' || cur->keyType == 'P'))
		     {
			unique++;
		     }
		     cur = cur->next;
		  }
		  if(unique)
		  {
		     g_activate_object(it->browse->del);
		  }
	       } /* fin de si plus d'une ligne est selectionnee dans browser */
	    } /* endif si des champs dans fields sont selectionnes */
	 } /* endif order by est selectionne */
      } /* endif si table est selectionnee */
   } /* endif si database est selectionnee */
}


void browsetable_setOrder(struct browsetable *it)    /* prepare le choix order by */
{
   struct fields *cur;
   
   /* efface le choix order by */
   if(fl_get_choice_maxitems(it->browse->order))
   {
      fl_clear_choice(it->browse->order);
   }
  
   fl_addto_choice(it->browse->order, "Order by which column?");
   cur = it->firstf;
   while(cur)
   {
      if(cur->type < 13 || cur->type > 15) /* refuse les blob */
	 fl_addto_choice(it->browse->order, cur->name);
      cur = cur->next;
   }
}
void  browsetable_setFields(struct browsetable *it)   /* prepare le browser fields */
{
   struct fields *cur;
   /* efface le browser des champs */
   if(fl_get_browser_maxline(it->browse->fields))
   {
      fl_clear_browser(it->browse->fields);
   }

   /* place les noms de champs dans le browser */
   fl_add_browser_line(it->browse->fields, "Select columns to display");
   cur = it->firstf;
   while(cur)
   {
      if(cur->type < 13 || cur->type > 15) /* refuse les blob */
	 fl_add_browser_line(it->browse->fields, cur->name);
      cur = cur->next;
   }
}

/*----------------------------------------------------------*/
/* prend la definition des champs et la place dans la liste */
/*----------------------------------------------------------*/
void browsetable_getColumns(struct browsetable *it)
{
   MYSQL connection;
   char sql[81];
   int index = 0;
  
   sprintf(sql, "show columns from %s", it->table);
   if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
   {
      MYSQL_RES *result;
      MYSQL_ROW row;
      char *error;
    
      mysql_select_db(&connection, it->database);
      if(!mysql_query(&connection, sql))
      {
	 result = mysql_store_result(&connection);
	 
	 while ((row=mysql_fetch_row(result)))
	 {
	    memset(it->buff, '\0', sizeof(struct fields));
	    
	    /* row[0] nom du champ */
	    if(row[0])
            {
	       strcpy(it->buff->name, row[0]);
	    }

	    /* row[1] premier mot determine le type de champ */
	    if(row[1])
	    {
	       it->buff->type = createtable_typeToIndex(getSSubstr(row[1], " (),", 0));
	       it->buff->length = atol(getSSubstr(row[1], " (),", 1));
	       it->buff->decimales = atoi(getSSubstr(row[1], " (),", 2));
	       if(strstr(row[1], " unsigned"))
	       {
		  it->buff->funsigned = 1;
	       }
	       if(strstr(row[1], " zerofill"))
	       {
		  it->buff->zeroFill = 1;
	       }
	    }

	    /* null si YES */
	    if(row[2][0] != 'Y')
	    {
	       it->buff->notNull = 1;
	    }

	    /* row[3] key */

	    /* row[4] default */
	    if(row[4])
	       strcpy(it->buff->fdefault, row[4]);
	    else
	       strcpy(it->buff->fdefault, "NULL");

	    /* row[5] extra */
	    if(row[5])
	    {
	       if(strstr(row[5], "increment"))
	       {
		  it->buff->autoIncrement = 1;
		  it->buff->keyType = 'P';
	       }
	    }

	    index++;
	    /*-------------------------------*/
	    /* ajoute le champ dans la liste */
	    /*-------------------------------*/
	    {
	       struct fields *cur;
	       cur = (struct fields *) calloc(1, sizeof(struct fields));
	       if(!it->firstf)
	       {
		  it->firstf = it->lastf = cur;
	       }
	       else
	       {
		  it->lastf->next = cur;
		  cur->prev = it->lastf;
		  it->lastf = cur;
	       }
	       /*--------------------------------*/
	       /* copie les informations saisies */
	       /*--------------------------------*/
	       createtable_copyfield(cur, it->buff);
	    }
	 }  /* end while des lignes */
      
	 mysql_free_result(result);
      }
      else
      {
	 error = mysql_error(&connection);
	 fl_show_alert(error, it->table,"", 1);
      }
      mysql_close(&connection);
   }
   else
   {
      fl_show_alert("Cannot connect to database server","","", 1);
   }
}



/*-----------------------------------------------------*/
/* prend la definitions des index du serveur           */
/* et memorise dans la liste readkeys                  */
/*-----------------------------------------------------*/
void browsetable_getKeys(struct browsetable *it)
{
  char sql[81];
  MYSQL connection;
  struct readkey *rkf, *rkl, *rkp, rkc;

  rkf = rkl = NULL;
  memset(&rkc, '\0', sizeof(struct readkey));
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    MYSQL_RES *result;
    MYSQL_ROW row;
    char *error;
    
    sprintf(sql, "show keys from %s", it->table);
      
    mysql_select_db(&connection, it->database);
    if(!mysql_query(&connection, sql))
    {
      result = mysql_store_result(&connection);
      while ((row=mysql_fetch_row(result)))
      {
	strcpy(rkc.table,       row[0]);
	strcpy(rkc.nonUnique,   row[1]);
	strcpy(rkc.keyName,     row[2]);
	strcpy(rkc.seq,         row[3]);
	strcpy(rkc.columnName,  row[4]);
	strcpy(rkc.collation,   row[5]);
	if(row[6])
	{
	  strcpy(rkc.cardinality, row[6]);
	}
	else
	{
	  strcpy(rkc.cardinality, "0");
	}
	if(row[7])
	{
	  strcpy(rkc.subPart, row[7]);
	}
	else
	{
	  strcpy(rkc.subPart, "0");
	}

        /* cree l'item dans la liste */
	rkp = (struct readkey *) calloc(1, sizeof(struct readkey));
	memcpy(rkp, &rkc, sizeof(struct readkey));
	if(!rkf)
	{
	  rkf = rkl = rkp;
	}
	else
	{
	  rkl->next = rkp;
	  rkl = rkp;
	}
	
      } /* endwhile fetchrow */

      mysql_free_result(result);
    }
    else
    {
      error = mysql_error(&connection);
      fl_show_alert(error, "Cannot retreive keys from", it->table, 1);
    }
    mysql_close(&connection);
    
  }
  else
  {
    fl_show_alert("Cannot connect to database server","","", 1);
  }

  /*----------------------------------------------------------*/
  /* place les index dans la structure fields et compound key */
  /*----------------------------------------------------------*/
  browsetable_setKeys(it, rkf);
  
  /*------------------------------------*/
  /* free la liste temporaire des clees */
  /*------------------------------------*/
  rkp = rkf;
  while(rkp)
  {
    rkf = rkf->next;
    free(rkp);
    rkp = rkf;
  }
}


/*-----------------------------------------------------*/
/* prend la liste readkeys (definition des index) et   */
/* place les index simples dans la liste des champs    */
/* place les index composes dans la liste de compounds */
/*-----------------------------------------------------*/
void browsetable_setKeys(struct browsetable *it, struct readkey *rkf)
{
  struct readkey *rkp;
  int indexc = 0;
  {
    struct readkey *courant;
    int qt;
    
    courant = rkf;
    while(courant)
    {
      indexc++;
      /*-------------------------------------------*/
      /* determine le nombre de parties de la clee */
      /*-------------------------------------------*/
      qt = 0;
      rkp = rkf;
      while(rkp)
      {
	if(!strcmp(rkp->keyName, courant->keyName))
	{
	  qt++;
	}
	rkp = rkp->next;
      }

      /*---------------------------------------------------------*/
      /* si une seule partie, place la clee dans la liste fields */
      /*---------------------------------------------------------*/
      if(qt == 1)
      {
	struct fields *fld;
	
	/* recherche le champ */
	fld = it->firstf;
	while(fld)
	{
	  if(!strcmp(fld->name, courant->columnName))
	  {
	    break;
	  }
	  fld = fld->next;
	}
	
	/* si le champ est trouve, ajoute index a l'element */
	if(fld)
	{
	  if(!strcmp(courant->keyName, "PRIMARY"))
	  {
	    fld->keyType = 'P';
	  }
	  else
	  {
	    if(courant->nonUnique[0] == '0')
	    {
	      fld->keyType = 'U';
	    }
	    else
	    {
	      fld->keyType = 'M';
	    }
	  }
	  
	  strcpy(fld->keyName, courant->keyName);
	  fld->keySize = atoi(courant->subPart);
	  if(!fld->keySize)
	  {
	    if(fld->type == 10 || fld->type == 11)
	    {
	      fld->keySize = (int) fld->length;
	    }
	  }
	} /* endif champ trouve */
	
      } /* endif qt == 1 */
      /*---------------------------------------------------------*/
      /* si plus d'une partie, place la clee dans les compounds  */
      /*---------------------------------------------------------*/
      if(qt > 1)
      {
	struct compoundkey *ck;
	
	/* cree la fiche header de compound */
	ck = (struct compoundkey *) calloc(1, sizeof(struct compoundkey));

	if(!strcmp(courant->keyName, "PRIMARY"))
	{
	  ck->type = 'P';
	}
	else
	{
	  if(courant->nonUnique[0] == '0')
	  {
	    ck->type = 'U';
	  }
	  else
	  {
	    ck->type = 'M';
	  }
	}
	  
	strcpy(ck->nom, courant->keyName);
	ck->index = indexc;
	
	if(!it->firstc)
	{
	  it->firstc = it->lastc = ck;
	}
	else
	{
	  it->lastc->next = ck;
	  ck->prev = it->lastc;
	  it->lastc = ck;
	}

	/*-----------------------------*/
      	/* cree les parties de la clef */
	/*-----------------------------*/
	{
	  int item;
	  struct partkey *pk;
	  
	  for(item = 0; item < qt; item++)
	  {
	    pk = (struct partkey *) calloc(1, sizeof(struct partkey));
	    strcpy(pk->nomField, courant->columnName);
	    pk->index = item + 1;
	    pk->size = atoi(courant->subPart);
	    if(!pk->size)
	    {
	      struct fields *fld;
	
	      /* recherche le champ */
	      fld = it->firstf;
	      while(fld)
	      {
		if(!strcmp(fld->name, courant->columnName))
		{
		  if(fld->type == 10 || fld->type == 11)
		  {
		    pk->size = (int) fld->length;
		  }
		  break;
		}
		fld = fld->next;
	      }
	    }
	    
	    if(!ck->first)
	    {
	      ck->first = ck->last = pk;
	    }
	    else
	    {
	      ck->last->next = pk;
	      pk->prev = ck->last;
	      ck->last = pk;
	    }
	    
	    if(item < qt - 1)
	    {
	      courant = courant->next;
	    }
	  } /* endfor scan de parties de la clef */
	} /* fin block cree les parties de la clef */
      } /* endif qt > 1 */
      
      courant = courant->next;
    } /* fin du scan readkey */
  } /* fin du placement des index */
}

/*-------------------------------------------------*/
/* efface les listes de champs et d'index composes */
/*-------------------------------------------------*/
void browsetable_freeList(struct browsetable *it)
{
  {
    struct fields *cur;
    cur = it->firstf;
    while(cur)
    {
      it->firstf = it->firstf->next;
      free(cur);
      cur = it->firstf;
    }
  }

  {
    struct compoundkey *cur;
    struct partkey *part;
    
    cur = it->firstc;
    while(cur)
    {
      part = cur->first;
      while(part)
      {
	cur->first = cur->first->next;
	free(part);
	part = cur->first;
      }
      
      it->firstc = it->firstc->next;
      free(cur);
      cur = it->firstc;
    }
  }

  it->firstc = it->lastc = NULL; 
  it->firstf = it->lastf = NULL; 

}

/*---------------------------------------*/
/* ajoute une commande sql dans la liste */
/*---------------------------------------*/
void browsetable_addSQL(struct browsetable *it, char *sql)
{
  struct sqlcommands *cur;

  cur = (struct sqlcommands *) calloc(1, sizeof(struct sqlcommands));
  
  if(!it->fsql)
  {
    it->fsql = it->lsql = cur;
  }
  else
  {
    it->lsql->next = cur;
    it->lsql = cur;
  }
  
  cur->sql = (char *) malloc(strlen(sql) + 1);
  strcpy(cur->sql, sql);
}

/*------------------------------------------------*/
/* efface de la memoire la liste de commandes sql */
/*------------------------------------------------*/
void browsetable_freeSQL(struct browsetable *it)
{
  struct sqlcommands *cur;
  cur = it->fsql;
  while(cur)
  {
    it->fsql = it->fsql->next;
    if(cur->sql)
    {
      free(cur->sql);
    }
    free(cur);
    cur = it->fsql;
  }
  it->fsql = NULL;
  it->lsql = NULL;
}

/*---------------------------------------*/
/* affiche la liste des commandes sql et */
/* demande confirmation avant d'executer */
/*---------------------------------------*/
void browsetable_execSQL(struct browsetable *it)
{
  struct sqlcommands *cur;
  char str[41];
  if(!it->fsql)
  {
    return;
  }
  
  /*----------------------------------------------------*/
  /* affiche la liste des commandes dans le command log */
  /*----------------------------------------------------*/
  fl_clear_command_log();
  cur = it->fsql;
  while(cur)
  {
    fl_addto_command_log(cur->sql);
    fl_addto_command_log("\n");
    cur = cur->next;
  }
  fl_show_command_log(FL_TRANSIENT);

  {
    /*------------------------------------------------------*/
    /* altere la table en envoyant les commandes au serveur */
    /*------------------------------------------------------*/
    MYSQL connection;
    fl_addto_command_log("\n");
    fl_addto_command_log("\n");
    fl_addto_command_log("Connecting to server...");
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *error;
      
      fl_addto_command_log(" OK\n");
      mysql_select_db(&connection, it->database);
      fl_addto_command_log("Database \"");
      fl_addto_command_log(it->database);
      fl_addto_command_log("\" selected...\n\n");

      cur = it->fsql;
      while(cur)
      {
	fl_addto_command_log("Executing \"");
	fl_addto_command_log(cur->sql);
	fl_addto_command_log("\" -> ");
	if(!mysql_query(&connection, cur->sql))
	{
	  fl_addto_command_log(" OK\n");
	  result = mysql_store_result(&connection);
	  sprintf(str, "%ld row(s) affected\n\n", 
		  (long) mysql_affected_rows(&connection));
	  fl_addto_command_log(str);
	  mysql_free_result(result);
	}
	else
	{
	  error = mysql_error(&connection);
	  fl_addto_command_log(" * ERROR *\n");
	  fl_addto_command_log(error);
	  fl_addto_command_log("\n\n");
	}
	cur = cur->next;
      }
      mysql_close(&connection);
      fl_addto_command_log("Connection closed.\n");
    }
  }
  
  browsetable_freeSQL(it);
}

void main_browsetable(FL_OBJECT *obj, long data)
{
  struct browsetable *it;
  
  it = (struct browsetable *) calloc(1, sizeof(struct browsetable));

  /*--------------------------------------------------*/
  /* reserve la memoire des structure de travail      */
  /* place les pointeurs de la liste de champs a null */
  /*--------------------------------------------------*/
  it->buff= (struct fields *) calloc(1, sizeof(struct fields));
  it->firstf = it->lastf = NULL;
  it->firstc = it->lastc = NULL;
  
  /*-----------------------------------*/
  /* cree et montre la forme de saisie */
  /*-----------------------------------*/
  it->browse = create_form_browsetable();
  it->browse->vdata = (struct browsetable *) it;
  fl_show_form(it->browse->browsetable, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLadmin browse table");

  fl_freeze_form(it->browse->browsetable);

  /*--------------------------------------*/
  /* change le font du browser des champs */
  /*--------------------------------------*/
  fl_set_browser_fontstyle(it->browse->browser, FL_FIXED_STYLE);
  fl_set_browser_fontsize(it->browse->browser, FL_NORMAL_SIZE);

  /*----------------------*/
  /* desactive les objets */
  /*----------------------*/
  browsetable_setactive(it);

  /*------------------------------------------*/
  /* retrouve la liste de banques de donnees  */
  /* pour les placer dans le champs des choix */
  /*------------------------------------------*/
  choice_getDatabases(it->browse->database);

  fl_unfreeze_form(it->browse->browsetable);
}

void browsetable_database(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  

  fl_freeze_form(it->browse->browsetable);

  /* efface le choix order by */
  if(fl_get_choice_maxitems(it->browse->order))
  {
     fl_clear_choice(it->browse->order);
  }

  /* efface le choix des tables   */
  if(fl_get_choice_maxitems(it->browse->table))
  {
     fl_clear_choice(it->browse->table);
  }

  /* efface le browser des champs */
  if(fl_get_browser_maxline(it->browse->fields))
  {
     fl_clear_browser(it->browse->fields);
  }

  /* si un choix valide de database a ete fait */
  if(fl_get_choice(obj) > 1)
  {
     /* copie ce choix dans la variable de database */
     strcpy(it->database, fl_get_choice_text(obj));
     /* prepare le choix des tables */
     choice_getTables(it->browse->table, it->database);
  }
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);
}
void browsetable_table(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  
  fl_freeze_form(it->browse->browsetable);

  /* efface le choix order by */
  if(fl_get_choice_maxitems(it->browse->order))
  {
     fl_clear_choice(it->browse->order);
  }

  /* efface le browser des champs */
  if(fl_get_browser_maxline(it->browse->fields))
  {
     fl_clear_browser(it->browse->fields);
  }

  /* si un choix valide de table a ete fait */
  if(fl_get_choice(obj) > 1)
  {
     /* copie ce choix dans la variable de database */
     strcpy(it->table, fl_get_choice_text(obj));
     browsetable_freeList(it);
     browsetable_getColumns(it);  /* definition des champs */
     browsetable_getKeys(it);     /* definition des index  */
     browsetable_setOrder(it);    /* prepare le choix order by */
     browsetable_setFields(it);   /* prepare le browser fields */

  }
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);
 
}
void browsetable_fields(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;

  /*--------------------------------------------------------*/
  /* place le select dans cur pour chaque champ selectionne */
  /*--------------------------------------------------------*/
  {
     struct fields *cur;
     int i,j;
     int qt;
     
     qt = fl_get_browser_maxline(obj);
     for(i = 2; i <= qt; i++)
     {
	/* trouve champ correspondant dans la liste */
	cur = it->firstf;
	j = 0;
	while(cur)
	{
	   j++;
	   if(j > i - 2)
	      break;
	   cur = cur->next;
	}

	if(cur) /* si champ dans la liste a ete trouve */
	{
	   if(fl_isselected_browser_line(obj, i))
	   {
	      cur->select = 1;
	   }
	   else
	   {
	      cur->select = '\0';
	   }
	}
     }
  }
  fl_freeze_form(it->browse->browsetable);
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);
}
void browsetable_limitstart(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  
  fl_freeze_form(it->browse->browsetable);
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);
}
void browsetable_limitcount(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;

  fl_freeze_form(it->browse->browsetable);
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);
}
void browsetable_previous(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  
  {
     double start;
     double max;

     start = fl_get_counter_value(it->browse->limitstart);
     max   = fl_get_counter_value(it->browse->limitcount);

     if(max < 1.0) max = 1.0;
     if(start > 0.1) start -= max;
     if(start < 0.0) start = 0.0;

     fl_freeze_form(it->browse->browsetable);
     fl_set_counter_value(it->browse->limitstart, start);
     fl_set_counter_value(it->browse->limitcount, max);
     browsetable_setactive(it);
     fl_unfreeze_form(it->browse->browsetable);
  }
  if(fl_get_browser_maxline(it->browse->browser))
     browsetable_go(obj, data);
}
void browsetable_next(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  
  {
     double start;
     double max;

     start = fl_get_counter_value(it->browse->limitstart);
     max   = fl_get_counter_value(it->browse->limitcount);

     if(max < 1.0) max = 1.0;
     start += max;

     fl_freeze_form(it->browse->browsetable);
     fl_set_counter_value(it->browse->limitstart, start);
     fl_set_counter_value(it->browse->limitcount, max);
     browsetable_setactive(it);
     fl_unfreeze_form(it->browse->browsetable);
  }

  if(fl_get_browser_maxline(it->browse->browser))
     browsetable_go(obj, data);
}

/*--------------------------------------------------------*/
/* si aucune fiche de selectionnee, sauve tout le browser */
/* sinon, sauve toutes les fiches selectionnees           */
/*--------------------------------------------------------*/
void browsetable_save(FL_OBJECT *obj, long data) 
{ 
   const char *file;
   int tot, tb, i;
   struct browsetable *it;
   FD_browsetable *fd;
   fd = (FD_browsetable *) obj->form->fdui;
   it = (struct browsetable *) fd->vdata;

   /*-----------------------------------------------------------------*/
   /* calcule le nombre total de lignes selectionnees dans le browser */
   /*-----------------------------------------------------------------*/
   tot = 0;
   tb = fl_get_browser_maxline(it->browse->browser);
   for(i = 1L; i <= tb; i++)
      if(fl_isselected_browser_line(it->browse->browser, i))
	 tot++;

   /*---------------------------*/
   /* demande le nom du fichier */
   /*---------------------------*/

   file = fl_show_fselector("Enter destinatiion file name", ""/*getenv("HOME")*/ ,"*.*",it->table);
   if(file)
   {
      FILE *f1;
      char *str;
      char *p;
      int qtFld;
      struct fields *cur;

      /*---------------------------------------*/
      /* calcule le nombre de champs par ligne */
      /*---------------------------------------*/
      cur = it->firstf;
      qtFld = 0;
      while(cur)
      {
	 if(cur->select)
	    qtFld++;
	 cur = cur->next;
      }

      /*----------------------*/
      /* ouverture du fichier */
      /*----------------------*/
      f1 = fopen(file, "w");
      if(f1)
      {
	 str = (char *) malloc(8192);

	 /*---------------------------------------*/
	 /* scan du browser et sauve chaque ligne */
	 /*---------------------------------------*/
	 for(i = 1; i <= tb; i++)
	 {
	    if(fl_isselected_browser_line(it->browse->browser, i) || !tot)
	    {
	       p =  (char*) fl_get_browser_line(it->browse->browser, i);
	       if(p)
	       {
		  strcpy(str, p);
		  p = str;
		  while(*p)
		  {
		     if(*p == 127)
			*p = ' ';
		     p++;
		  }
		  printf("%s\n", str);
		  fprintf(f1, "%s\n", str);
	       } /* endif p si ligne retourne par browser */
	    }  /* endif si ligne doit etre selectionnee */
	 } /* endfor scan du browser pour ecriture du fichier */     
	 free(str);
	 fclose(f1);
      } /* endif si fichier ouvert avec succes */
   } /* endif si nom de fichier fourni */
}

void browsetable_search(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;

  browsetable_makeForm(it, 2);
  fl_show_form(it->fedit, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLadmin search mask");
  g_activate_object(it->browse->limitstart);
  g_activate_object(it->browse->limitcount); 
  
}

void browsetable_closeinput(FL_OBJECT *obj, long data)
{
  struct browsetable *it;
  it = (struct browsetable *) obj->form->u_vdata;
  
  fl_hide_form(it->fedit);
  fl_free_form(it->fedit);
  fl_freeze_form(it->browse->browsetable);
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);

}
void browsetable_addinput(FL_OBJECT *obj, long data)
{
   char *str, *sql;
   FL_OBJECT *pobj;
   struct fields *cur;
   struct browsetable *it;
   it = (struct browsetable *) obj->form->u_vdata;

   /*------------------------------------------------*/
   /* verifie si tous les champs requis sont fournis */
   /*------------------------------------------------*/
   pobj = obj->form->first;
   while(pobj)
   {
      if(pobj->objclass == FL_INPUT)
      {
	 cur = (struct fields *) pobj->u_vdata;
	 if(cur->notNull && fl_get_input(pobj) == NULL)
	 {
	    fl_show_alert(cur->name, "is null", "you must enter a value", 1);
	    return;
	 }
      }
      pobj = pobj->next;
   }

   sql = (char *) malloc(16384);
   str = (char *) malloc(512);

   /*----------------------*/
   /* cree la commande sql */
   /*----------------------*/
   {
      sprintf(sql, "insert into %s (", it->table);

      /* liste des champs ayant une valeur entree */
      pobj = obj->form->first;
      while(pobj)
      {
	 if(pobj->objclass == FL_INPUT)
	 {
	    cur = (struct fields *) pobj->u_vdata;
	    if(fl_get_input(pobj) != NULL)
	    {
	       strcat(sql, cur->name);
	       strcat(sql, ",");
	    }
	 }
	 pobj = pobj->next;
      }

      /* enleve la derniere virgule de sql */
      sql[strlen(sql) - 1] = '\0';

      strcat(sql, ") values(");

      /* ajoute donnees saisies */
      pobj = obj->form->first;
      while(pobj)
      {
	 if(pobj->objclass == FL_INPUT)
	 {
	    cur = (struct fields *) pobj->u_vdata;
	    if(fl_get_input(pobj) != NULL)
	    {
	       strcat(sql, "'");
	       strcpy(str, fl_get_input(pobj));
	       g_escapeStr(str);
	       strcat(sql, str);
	       strcat(sql, "',");
	    }
	 }
	 pobj = pobj->next;

      }

      /* enleve la derniere virgule de sql */
      sql[strlen(sql) - 1] = '\0';
      strcat(sql, ")");
   }

   /*-------------------------*/
   /* execute la commande sql */
   /*-------------------------*/
   fl_show_command_log(FL_TRANSIENT);
   if(!util_exec_voidsql(it->database, sql))
      browsetable_closeinput(obj, 0L); 

   free(str); free(sql);
}

void browsetable_modinput(FL_OBJECT *obj, long data)
{
   char *sql;
   char *str;
   FL_OBJECT *pobj;
   struct fields *cur;
   struct browsetable *it;
   it = (struct browsetable *) obj->form->u_vdata;

   /*------------------------------------------------*/
   /* verifie si tous les champs requis sont fournis */
   /*------------------------------------------------*/
   pobj = obj->form->first;
   while(pobj)
   {
      if(pobj->objclass == FL_INPUT)
      {
	 cur = (struct fields *) pobj->u_vdata;
	 if(cur->notNull && fl_get_input(pobj) == NULL)
	 {
	    fl_show_alert(cur->name, "is null", "you must enter a value", 1);
	    return;
	 }
      }
      pobj = pobj->next;
   }

   sql = (char *) malloc(16384);
   str = (char *) malloc(256);

   /*----------------------*/
   /* cree la commande sql */
   /*----------------------*/
   {
      sprintf(sql, "update %s set ", it->table);

      /* liste des champs ayant une valeur entree */
      pobj = obj->form->first;
      while(pobj)
      {
	 if(pobj->objclass == FL_INPUT)
	 {
	    cur = (struct fields *) pobj->u_vdata;
	    if(fl_get_input(pobj) != NULL)
	    {
	       strcat(sql, cur->name);
	       strcat(sql, "= '");
	       strcpy(str, fl_get_input(pobj));
	       g_escapeStr(str);
	       strcat(sql, str);
	       strcat(sql, "',");
	    }
	 }
	 pobj = pobj->next;
      }

      /* enleve la derniere virgule de sql */
      sql[strlen(sql) - 1] = '\0';

      strcat(sql, " where ");

      /* trouve le premier champ unique */
      pobj = obj->form->first;
      while(pobj)
      {
	 if(pobj->objclass == FL_INPUT)
	 {
	    cur = (struct fields *) pobj->u_vdata;
	    if(fl_get_input(pobj) != NULL && (cur->keyType == 'P' || cur->keyType == 'U' ))
	    {
	       strcat(sql, cur->name);
	       strcat(sql, " = '");
	       strcat(sql, fl_get_input(pobj));
	       strcat(sql, "'");
	       break;
	    }
	 }
	 pobj = pobj->next;

      }
   }

   /*-------------------------*/
   /* execute la commande sql */
   /*-------------------------*/
   fl_show_command_log(FL_TRANSIENT);
   if(!util_exec_voidsql(it->database, sql))
   {
      browsetable_closeinput(obj, 0L); 
      browsetable_go(it->browse->go, 0L);
   }

   free(str); free(sql);
  
}

void browsetable_searchinput(FL_OBJECT *obj, long data)
{
   char *str, *sql;
   FL_OBJECT *pobj;
   struct fields *cur;
   struct browsetable *it;
   it = (struct browsetable *) obj->form->u_vdata;

   /*------------------------------------------------*/
   /* verifie si au moins une condition est specifiee*/
   /*------------------------------------------------*/
   pobj = obj->form->first;
   while(pobj)
   {
      if(pobj->objclass == FL_INPUT)
      {
	 cur = (struct fields *) pobj->u_vdata;
	 if(fl_get_input(pobj) != NULL)
	 {
	    break;
	 }
      }
      pobj = pobj->next;
   }

   if(!pobj)
   {
      fl_show_alert("At least one codition must be provided.", "Specify a mask search","",1);
      return;
   }

   sql = (char *) malloc(16384);
   str = (char *) malloc(512);
   sql[0] = '\0';

   strcpy(sql, "select ");

   /* ajoute les champs du select */
   { 
      cur = it->firstf;
      while(cur)
      {
	 if(cur->select)
	 {
	    strcat(sql, cur->name);
	    strcat(sql, ",");
	 }
	 cur = cur->next;
      }
      /* retire la virgule en trop */
      sql[strlen(sql) - 1] = '\0';
   }

   /* from clause */
   strcat(sql, " from ");
   strcat(sql, it->table);

   /*--------------*/
   /* where clause */
   /*--------------*/
   strcat(sql, " where ");
   pobj = obj->form->first;
   while(pobj)
   {
      if(pobj->objclass == FL_INPUT)
      {
	 cur = (struct fields *) pobj->u_vdata;
	 if(fl_get_input(pobj) != NULL)
	 {
	    if(strlen(fl_get_input(pobj)) > 0)
	    {
	       int numerique = 0;
	       switch(cur->type)
	       {
		  case 2: /* tinyint */
		  case 3: /* smallint */
		  case 4: /* mediumint */
		  case 5: /* integer */
		  case 6: /* big integer */
		  case 7: /* float */
		  case 8: /* double */
		  case 9: /* decimal */
		  numerique = 1;
		  break;
		  case 10: /* char */
		  case 11: /* varchar */
		  case 16: /* timestamp */
		  case 18: /* time */
		  case 12: /* tinyblob */
		  case 13: /* blob */
		  case 14: /* mediumblob */
		  case 15: /* longblob */
		  case 17: /* date */
		  case 19: /* enum */
		  case 20: /* set */
		  case 21: /* datetime */
		  case 22: /* text */
		  numerique = 0;
		     break;
	       } /* endswitch cur->type */

	       strcat(sql, cur->name);
	       if(numerique)
	       {
		  strcat(sql, " = ");
		  strcat(sql, fl_get_input(pobj));
	       }
	       else
	       {
		  strcat(sql, " like '");
		  strcpy(str, fl_get_input(pobj));
		  g_escapeStr(str);
		  strcat(sql, str);
		  strcat(sql, "'");
	       }
	       strcat(sql, "  and ");
	    }
	 }
      }
      pobj = pobj->next;
   }
   /* enleve le dernier "and" */
   sql[strlen(sql) - 5] = '\0';

   /* order by clause */
   strcat(sql, " order by ");
   strcat(sql, fl_get_choice_text(it->browse->order));

   /* limit clause */
   {
     double start;
     double max;
     long offset;
     long rows;
     char str2[12];

     start = fl_get_counter_value(it->browse->limitstart);
     max   = fl_get_counter_value(it->browse->limitcount);

     offset = (long) start;
     rows   = (long) max;

     if(offset || rows)
     {
	strcat(sql, " limit ");

	if(offset == 0L)
	{
	   sprintf(str2, "%ld", rows);
	}
	else
	{
	   sprintf(str2, "%ld,%ld", offset, rows);
	}
	strcat(sql, str2);
     }
   }

   /*--------------------*/
   /*--------------------*/
   /* execute le rapport */
   /*--------------------*/
   /*--------------------*/
   fl_show_command_log(FL_TRANSIENT);
   fl_freeze_form(it->browse->browsetable);
   util_exec_sql(it->browse->browser, it->database, sql);
   fl_unfreeze_form(it->browse->browsetable);

   free(sql); free(str);
}


void browsetable_callbackinput(FL_OBJECT *obj, long data)
{
  struct browsetable *it;
  it = (struct browsetable *) obj->form->u_vdata;
  
}

void browsetable_makeForm(struct browsetable *it, int type)
{
   int selected;
   int i,item;
   int tot;
   struct fields *cur;
   FL_OBJECT *obj;
   int tx, ty;
   char nom[128];
   char *pt;
   char *str;
   
   str = (char *) malloc(1024);

   /*------------------------------------------------------*/
   /* calculate total of columns in the table, except blob */
   /*------------------------------------------------------*/
   selected = 0;
   tot = fl_get_browser_maxline(it->browse->fields);
   if(type == 0 || type == 2)
   {
      selected = tot - 1;
   }
   else
   {
      for( i = 2; i <= tot; i++)
      {
	 if(fl_isselected_browser_line(it->browse->fields,i))
	 {
	    selected++;
	 }
      }
   }

   if(selected > 96)
   {
      fl_show_alert("To many fields","Cannot make window", "for now...", 1);
      return;
   }

   /*------------------------------*/
   /* calcule grandeur de la forme */
   /*------------------------------*/
   tx = (200 * ((selected - 1) / 17)) + 240;
   if(selected > 17)
      ty = 400;
   else
      ty = (23 * selected) + 10;

   /*--------------------------*/
   /* construction de la forme */
   /*--------------------------*/
   it->fedit = fl_bgn_form(FL_NO_BOX, tx, ty);
   {
      /*------------------------------------------*/
      /* type de fenetre et boutons close et save */
      /*------------------------------------------*/
      obj = fl_add_box(FL_UP_BOX,0,0,tx,ty,"");
      fl_set_object_resize(obj, FL_RESIZE_Y);
      obj = fl_add_button(FL_NORMAL_BUTTON,tx - 40, ty - 25,35,20,"Abort");
      fl_set_object_callback(obj,browsetable_closeinput,0);
      if(type != 2)
	 obj = fl_add_button(FL_NORMAL_BUTTON,tx - 40, ty - 45,35,20,"Save");
      else
	 obj = fl_add_button(FL_NORMAL_BUTTON,tx - 40, ty - 45,35,20,"Search");

      switch(type)
      {
	 case 0:  fl_set_object_callback(obj, browsetable_addinput,0);     break; /* add    */
	 case 1:  fl_set_object_callback(obj, browsetable_modinput, 0);    break; /* mod    */
	 case 2:  fl_set_object_callback(obj, browsetable_searchinput, 0); break; /* search */
      }
      /*-----------------------------------*/
      /* creation des champs dans la forme */
      /*-----------------------------------*/
      for(item = 0, i = 2; i <= tot; i++)
      {
	 if(type == 0 || type == 2 || fl_isselected_browser_line(it->browse->fields, i))
	 {
	    pt = (char*) fl_get_browser_line(it->browse->fields, i);
	    if(pt)
	    {
	       strcpy(nom, getSubstr(pt, 127, 0));
	       
	       /*--------------------------------------------------------*/
	       /* recherche la definition du champs dans la liste fields */
	       /*--------------------------------------------------------*/
	       cur = it->firstf;
	       while(cur)
	       {
		  if(!strcmp(cur->name, nom))
		     break;
		  cur = cur->next;
	       }

	       if(cur)
	       {
		  ty = ((item % 17) * 23) + 5; 
		  tx = (200 * (item / 17)) + 75;
		  switch(cur->type)
		  {
		     case 2: /* tinyint */
		     case 3: /* smallint */
		     case 4: /* mediumint */
		     case 5: /* integer */
		     case 6: /* big integer */
		     {
			obj = fl_add_input(FL_INT_INPUT, tx, ty, 125, 20, cur->name);
		     }
		     break;
		     case 7: /* float */
		     case 8: /* double */
		     case 9: /* decimal */
		     {
			obj = fl_add_input(FL_FLOAT_INPUT, tx, ty, 125, 20, cur->name);
		     }
		     break;
		     case 10: /* char */
		     case 11: /* varchar */
		     case 16: /* timestamp */
		     case 18: /* time */
		     case 21: /* datetime */
		     case 22: /* text */
		     case 19: /* enum */
		     case 20: /* set */
		     {
			obj = fl_add_input(FL_NORMAL_INPUT, tx, ty, 125, 20, cur->name);
		     }
		     break;
		     case 12: /* tinyblob */
		     case 13: /* blob */
		     case 14: /* mediumblob */
		     case 15: /* longblob */
		     break;
		     case 17: /* date */
		     {
			obj = fl_add_input(FL_NORMAL_INPUT, tx, ty, 125, 20, cur->name);
		     }
		     break;

		  } /* endswitch cur->type */

		  fl_set_input_maxchars(obj, cur->length);
		  fl_set_object_callback(obj,browsetable_callbackinput,0);
		  obj->u_vdata = cur;

		  /*-----------------------------------------------------*/
		  /* setup les valeurs dans les inputs pour modification */
		  /*-----------------------------------------------------*/
		  if(type == 1)
		  {
		     char *ptr = NULL;
		     int i, tot;
		     
		     tot = fl_get_browser_maxline(it->browse->browser);
		     for(i = 1; i <= tot; i++)
		     {
			if(fl_isselected_browser_line(it->browse->browser, i))
			{
			   ptr = (char*) fl_get_browser_line(it->browse->browser, i);
			   break;
			}
		     }
		     if(ptr)
		     {
			strcpy(str, getSubstr(ptr, 127, item));
			leftTrim(str);
			fl_set_input(obj, str);
		     }
		  } /* endif place les valeurs d'input */

	       } /* endif definition du champ trouvee */
	    } /* endif si ligne courante du browser fields retourne un string */
	    item++;  /* compte les champs selectionnes  pour placer les champs dans fenetre */
	 } /* endif si champs doit etre selectionne */
      } /* endfor boucle scannant le browser fields */
   }     
   fl_end_form();
   it->fedit->u_vdata = (struct browsetable *) it;
   free(str);


   /*----------------------------------------------------------------------*/
   /* si on est en mode de modification, desactive le premier champ unique */
   /*----------------------------------------------------------------------*/
   if(type == 1)
   {
      obj = it->fedit->first;
      while(obj)
      {
	 if(obj->objclass == FL_INPUT)
	 {
	    cur = (struct fields *) obj->u_vdata;
	    if(cur->keyType == 'P' || cur->keyType == 'U' )
	    {
	       g_deactivate_object(obj);
	       break;
	    }
	 }
	 obj = obj->next;
      }
   }

   /*---------------------------*/
   /* desactive tous les champs */ 
   /*---------------------------*/
   g_deactivate_form(it->browse->browsetable);
/*    fl_freeze_form(it->browse->browsetable); */
/*    g_deactivate_object(it->browse->database); */
/*    g_deactivate_object(it->browse->table);  */
/*    g_deactivate_object(it->browse->limitstart); */
/*    g_deactivate_object(it->browse->limitcount);  */
/*    g_deactivate_object(it->browse->previous); */
/*    g_deactivate_object(it->browse->next); */
/*    g_deactivate_object(it->browse->save); */
/*    g_deactivate_object(it->browse->search); */
/*    g_deactivate_object(it->browse->add); */
/*    g_deactivate_object(it->browse->mod); */
/*    g_deactivate_object(it->browse->del); */
/*    g_deactivate_object(it->browse->delall); */
/*    g_deactivate_object(it->browse->order); */
/*    g_deactivate_object(it->browse->go); */
/*    g_deactivate_object(it->browse->browser); */
/*    g_deactivate_object(it->browse->fields); */
/*    fl_unfreeze_form(it->browse->browsetable); */
}

void browsetable_add(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;

  browsetable_makeForm(it, 0);
  fl_show_form(it->fedit, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLadmin add row");
}
void browsetable_mod(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  browsetable_makeForm(it, 1);
  fl_show_form(it->fedit, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLadmin modify row");
  
}
void browsetable_del(FL_OBJECT *obj, long data)
{ 
   int tot, i;
   char *str;
   char *sql;
   char sep[2];
   int index;
   struct fields *cur; 

   struct browsetable *it;
   FD_browsetable *fd;
   fd = (FD_browsetable *) obj->form->fdui;
   it = (struct browsetable *) fd->vdata;

   str = (char *) malloc(256);
   sql = (char *) malloc(512);

   /*--------------------------------------------------------*/
   /* recherche parmi les champs selectionnes l'index unique */
   /*--------------------------------------------------------*/
   index = 0;

   cur = it->firstf;
   while(cur)
   {
      if(cur->select)
      {
	 if(cur->keyType == 'P' || cur->keyType == 'U')
	    break;
	 index++;
      }
      cur = cur->next;
   }
   if(!cur) return;


   /*-----------------------------------------------------*/
   /* scanne le browser pour trouver les lignes a effacer */
   /*-----------------------------------------------------*/
   sprintf(sep, "%c", 127);
   tot = fl_get_browser_maxline(it->browse->browser);
   for(i = 1; i <= tot; i++)
   {
      if(fl_isselected_browser_line(it->browse->browser, i))
      {
	 strcpy(str, getSSubstr((char*) fl_get_browser_line(it->browse->browser, i), sep, index));
	 leftTrim(str);

	 sprintf(sql, "delete from %s where %s = '%s'", it->table, cur->name, str);
	 browsetable_addSQL(it, sql);
      } /* endif si ligne du browser est selectionnee */
   } /* endwhile boucle de scan du browser */
  free(sql); free(str);

  /*--------------------*/
  /* execute le rapport */
  /*--------------------*/
  if(fl_show_question("This will delete the selected rows.\nAre you sure?", 0))
  {
     browsetable_execSQL(it);
     browsetable_go(obj, 0L);
  }
}
void browsetable_delall(FL_OBJECT *obj, long data)
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  
  {
     char sql[256];

     sprintf(sql, "delete from %s", it->table);
     browsetable_addSQL(it, sql);
   } /* endwhile boucle de scan du browser */

  /*--------------------*/
  /* execute le rapport */
  /*--------------------*/
  if(fl_show_question("This will delete all rows in this table.\nAre you sure?", 0))
  {
     if(fl_show_question("Aoutch! Really sure?", 0))
     {
	browsetable_execSQL(it);
	browsetable_go(obj, 0L);
     }
  }
}
void browsetable_order(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;

  fl_freeze_form(it->browse->browsetable);
  browsetable_setactive(it);
  fl_unfreeze_form(it->browse->browsetable);
}
void browsetable_go(FL_OBJECT *obj, long data) 
{ 
   char *sql;

   struct browsetable *it;
   FD_browsetable *fd;
   fd = (FD_browsetable *) obj->form->fdui;
   it = (struct browsetable *) fd->vdata;
  
   /*-------------------------*/
   /* construction du rapport */
   /*-------------------------*/
   sql = (char *) malloc(4096);
   sql[0] = '\0';

   strcpy(sql, "select ");

   /* ajoute les champs du select */
   { 
      struct fields *cur;
      cur = it->firstf;
      while(cur)
      {
	 if(cur->select)
	 {
	    strcat(sql, cur->name);
	    strcat(sql, ",");
	 }
	 cur = cur->next;
      }
      /* retire la virgule en trop */
      sql[strlen(sql) - 1] = '\0';
   }

   /* from clause */
   strcat(sql, " from ");
   strcat(sql, it->table);

   /* order by clause */
   strcat(sql, " order by ");
   strcat(sql, fl_get_choice_text(it->browse->order));

   /* limit clause */
   {
     double start;
     double max;
     long offset;
     long rows;
     char str[12];

     start = fl_get_counter_value(it->browse->limitstart);
     max   = fl_get_counter_value(it->browse->limitcount);

     offset = (long) start;
     rows   = (long) max;

     if(offset || rows)
     {
	strcat(sql, " limit ");

	if(offset == 0L)
	{
	   sprintf(str, "%ld", rows);
	}
	else
	{
	   sprintf(str, "%ld,%ld", offset, rows);
	}
	strcat(sql, str);
     }
   }

   /*--------------------*/
   /*--------------------*/
   /* execute le rapport */
   /*--------------------*/
   /*--------------------*/
   fl_show_command_log(FL_TRANSIENT);
   fl_freeze_form(it->browse->browsetable);
   util_exec_sql(it->browse->browser, it->database, sql);
   browsetable_setactive(it);
   fl_unfreeze_form(it->browse->browsetable);
   free(sql);
}
void browsetable_browser(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;

   fl_freeze_form(it->browse->browsetable);
   browsetable_setactive(it);
   fl_unfreeze_form(it->browse->browsetable);
}


void browsetable_close(FL_OBJECT *obj, long data) 
{ 
  struct browsetable *it;
  FD_browsetable *fd;
  fd = (FD_browsetable *) obj->form->fdui;
  it = (struct browsetable *) fd->vdata;
  
  browsetable_freeList(it);
  free(it->buff);
  fl_hide_form(it->browse->browsetable);
  fl_free_form(it->browse->browsetable);
  free(it->browse);
  free(it);
}

