/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  February 1996                            */
/*-----------------------------------------------------------------------*/
/*                    Event RFC Synthesis                                */
/*                                                                       */
/*=======================================================================*/

#include "EST_String.h"
#include "EST.h"
#include "EST_Event.h"
#include "EST_rfc.h"
#include "math.h"

int fill_values(EST_Track &fz, int &j, float amp, float dur, float
		start_f0, float start_pos, float f_shift, EST_String type);


// find event portions of fz in contour, cut out, and send one by one
// to individual labeller.

int fill_values(EST_Track &fz, float amp, float dur, float
		start_f0, float start_pos, float f_shift, EST_String type)
{
    float t;
    // this ensures rounding errors don't multiply
    int j = (int) rint(start_pos / f_shift); 
    
    for (t = 0.0; t < (dur + (f_shift /2.0)); t += f_shift, ++j)
    {
	fz.t(j) = float(j) * f_shift;
	fz.a(j) = unit_curve(type, amp, dur, t) + start_f0;
	cout << j << " : " << fz.t(j) << " a= " << fz.a(j) << endl;
    }

    return 0;
}

void fill_breaks(EST_Track &fz, float start_pos, float dur, float f_shift)
{
    float t;
    int j;
    // this ensures rounding errors don't multiply
    j = (int) rint(start_pos / f_shift); 
    
    for (t = 0.0; t < (dur + (f_shift /2.0)); t += f_shift, ++j)
    {
	fz.t(j) = t + start_pos;
	fz.a(j) = 0.0;
	fz.set_break(j);
    }
}

EST_Track rfc_to_track(EST_Stream &ev, float f_shift, int no_conn)
{
    float t;
    float start_pos, start_f0;
    EST_Track fz;

    fz.resize(100000,1);// REORG - resize properly
    
    fz.set_break_type("MANY");
    EST_Stream_Item *e;
    t = 0.0;

    if (ev.stream_name() != "rfc_event")
    {
	cerr << "Can't create F0 contour from stream type: " 
	    << ev.stream_name() << endl;
	return fz;
    }

    for (e = ev.head(); e != 0; e = next(e))
    {
//	cout << endl << *e << endl;
//	cout << "duration = " << e->dur() << endl;
//	cout << *RFCS(*e) << endl << endl;


	if (RFCS(*e)->type == "RISEFALL")
	{
	    fill_values(fz, RFCS(*e)->rise_amp(), RFCS(*e)->rise_dur(),
			RFCS(*e)->start_f0(), RFCS(*e)->start_pos(), 
			f_shift, "RISE");
	    
	    start_pos = RFCS(*e)->peak_pos();
	    start_f0 = RFCS(*e)->peak_f0();
//	    cout << "start pos = " <<start_pos << endl;
//	    cout << "start amp = " << start_f0 << endl;
//	    cout << "fall dur = " << RFCS(*e)->fall_dur() << endl;

	    fill_values(fz, RFCS(*e)->fall_amp(), RFCS(*e)->fall_dur(),
			start_f0, start_pos, f_shift, "FALL");

	}
	else if (RFCS(*e)->type == "RISE")
	    fill_values(fz, RFCS(*e)->rise_amp(), RFCS(*e)->rise_dur(),
			RFCS(*e)->start_f0(), RFCS(*e)->start_pos(), 
			f_shift, "RISE");
	else if (RFCS(*e)->type =="FALL")
	    fill_values(fz, RFCS(*e)->fall_amp(), RFCS(*e)->fall_dur(),
			RFCS(*e)->start_f0(), RFCS(*e)->start_pos(), 
			f_shift, "FALL");
	else 
	{
	    if ((no_conn) || (RFCS(*e)->type =="SIL"))
	    {

//		cout << "Silence: " << RFCS(*e)->start_pos() << " " 
//		    << e->dur() << endl;

		fill_breaks(fz, RFCS(*e)->start_pos(), e->dur(),
			    f_shift);
	    }
	    else 
		fill_values(fz, RFCS(*e)->amp(), RFCS(*e)->dur(),
			RFCS(*e)->start_f0(), RFCS(*e)->start_pos(), 
			f_shift, "CONN");

	}
    }
    int n = (int)(ev.tail()->end() / f_shift);

    fz.set_num_frames(n);
    fz.set_contour_type(EST_ContourType::F0);

    return fz;
}


