/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1995,1996                       */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                      Author :  Paul Taylor                            */
/*                      Date   :  April 1995                             */
/*-----------------------------------------------------------------------*/
/*                          Event Class                                  */
/*                                                                       */
/*=======================================================================*/

#include "EST.h"
#include "EST_Event.h"

void EventSI::init()
{
    s_f0 = -1.0; s_pos = -1.0; p_f0 = 0.0; p_pos = 0.0, e_f0 =0.0,e_pos =0.0;
    sn = 0;
    sp = 0;
}
    
float EventSI::rise_dur()
{
    if (sn == 0) // end of event list, amplitude uncalcuable.
	return 0.0;

    if (type == "RISE")
	return (sn->start_pos() - start_pos());
    else  if (type == "RISEFALL")
	return (p_pos - start_pos());
    else 
	return 0.0;
}
    
float EventSI::fall_dur()
{
    if (sn == 0) // end of event list, amplitude uncalcuable.
	return 0.0;

    if (type == "FALL")
	return sn->start_pos() - start_pos();
    else  if (type == "RISEFALL")
	return (sn->start_pos() - p_pos);
    else 
	return 0.0;
}
    
float EventSI::fall_amp()
{
    if (sn == 0) // end of event list, amplitude uncalcuable.
	return 0.0;

    if (type == "FALL")
	return sn->s_f0 - s_f0;
    else  if (type == "RISEFALL")
	return sn->s_f0 - p_f0;
    else 
	return 0.0;
}

float EventSI::rise_amp()
{
//    cout << "type = " << type << endl;
    if (sn == 0) // end of event list, amplitude uncalcuable.
	return 0.0;
    cout << "type = " << type << endl;

    if (type == "RISE")
	return sn->s_f0 - s_f0;
    else  if (type == "RISEFALL")
	return  p_f0 - s_f0;
    else 
	return 0.0;
}

float EventSI::amp()
{
    if (sn == 0) // end of event list, amplitude uncalcuable.
	return 0.0;

    return (sn->s_f0 - s_f0);
}

float EventSI::dur()
{
    if (sn == 0) // end of event list, duration uncalcuable.
	return 0.0;

    return (sn->s_pos - s_pos);
}

float EventSI::start_f0()
{
    return s_f0;
}

float EventSI::start_pos()
{
    return s_pos;
}

float EventSI::peak_f0()
{
    return p_f0;
}

float EventSI::peak_pos()
{
    return p_pos;
}

float EventSI::end_f0()
{
    return e_f0;
}

float EventSI::end_pos()
{
    return e_pos;
}

void EventSI::set_start_f0(float a)
{
    s_f0 = a;
}

void EventSI::set_start_pos(float a)
{
    s_pos = a;
}

void EventSI::set_peak_f0(float a)
{
    p_f0 = a;
}

void EventSI::set_peak_pos(float a)
{
    p_pos = a;
}

void EventSI::set_end_f0(float a)
{
    e_f0 = a;
}

void EventSI::set_end_pos(float a)
{
    e_pos = a;
}
/*
void EventSI::set_dur(float a)
{
    sn->s_pos = s_pos + a;
}

void EventSI::set_amp(float a)
{
    sn->s_f0 = s_f0 + a;
}
*/
/*
void EventSI::set_peak_dur(float a)
{
    p_dur = a;
}
*/
void EventTilt::init()
{
    samp = 0.0;
    sdur = 0.0;
    stilt = 0.0;
    spos = 0.0;
    s_pos = 0.0;
    s_f0 = 0.0;
}
    
float EventTilt::amp()
{
    return samp;
}
float EventTilt::dur()
{
    return sdur;
}
float EventTilt::tilt()
{
    return stilt;
}
float EventTilt::pos()
{
    return spos;
}

float EventTilt::start_pos()
{
    return s_pos;
}

float EventTilt::start_f0()
{
    return s_f0;
}

void EventTilt::set_amp(float a)
{
    samp = a;
}

void EventTilt::set_dur(float a)
{
    sdur = a;
}

void EventTilt::set_tilt(float a)
{
    stilt = a;
}

void EventTilt::set_pos(float a)
{
    spos = a;
}

void EventTilt::set_start_f0(float a)
{
    s_f0 = a;
}

void EventTilt::set_start_pos(float a)
{
    s_pos = a;
}

void gc_eventsi(void *w) { delete (EventSI *)w; }
void gc_eventtilt(void *w) { delete (EventTilt *)w; }

