 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Fri May  9 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Enumerated type of symbolic channel names for tracks.                */
 /*                                                                      */
 /************************************************************************/

#ifndef __EST_CHANNELTYPE_H__
#define __EST_CHANNELTYPE_H__

typedef enum EST_ChannelType {
  channel_unknown = 0,
  first_channel_type,

  channel_order			// of analysis
	=first_channel_type,
  channel_power,		// rms power
  channel_peak,			// peak value 
  channel_duration,		// seconds
  channel_length,		// sample points
  channel_f0,			// Hz
  channel_voiced,		// probability
  channel_frame,		// number of related frame in another track
  channel_time,			// time in seconds.
  channel_coef0,		// other coefs assumed sequential in track
  channel_coefN,		// last coef

  num_channel_types		// can be used to size arrays etc.
} EST_ChannelType;

#endif
