 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)		 */
 /*                   Date: Mon Mar  3 1997				 */
 /************************************************************************/
 /*                                                                      */
 /* Abstraction for a chunk of information. We string together units     */
 /* to make an utterance.                                                */
 /*                                                                      */
 /************************************************************************/

class Unit;

#ifndef __UNIT_H__
#define __UNIT_H__

#include "EST.h"
#include "EST_TVector.h"

#if defined(INCLUDE_LISP)
#   include "siod.h"
#   include "festival.h"
#endif

#include "UnitDatabase.h"
#include "SubtypedObject.h"

class Unit : public SubtypedObject<Unit> {

private:
  UnitName p_name;
  UnitProperties p_properties;
  UnitDatabase *p_database;
  Unit *p_underlying;

protected:

  void set_name(EST_String name)  {p_name = name;};
  void set_database(UnitDatabase *database)  {p_database = database;};
  void set_underlying(Unit *unit)  {p_underlying = unit;};
  void set_unit_properties(UnitProperties properties) {p_properties = properties;};

  // required by the FestivalObject interface, but not useful for units.
  EST_read_status fill_from(FILE *) {return misc_read_error; };
  void set_filename(EST_String) { };
public:

  Unit(void);
  virtual ~Unit(void);

  EST_String name(void) const {return p_name;};
  UnitDatabase *database(void) const {return p_database;};
  Unit *underlying(void) const {return p_underlying; };
  UnitProperties &properties(void) {return p_properties;};

  virtual void associate_database(UnitDatabase *db);

  virtual int set_property(EST_String property, ValueType value);

  virtual SchemeObject *gc_master_pointer(void) { return p_database?(SchemeObject *)p_database:(SchemeObject *)this;};

  virtual int length(void);			// in arbitrary units;
  virtual EST_TVector<int> *segment_ends(void);  // in the same units

  virtual Unit *derived_unit(void);

#if defined(INCLUDE_LISP)
  //lisp interface
  static void lisp_print(LISP, FILE *);
  static void lisp_print_string(LISP, char *);
  static void lisp_declare(void);
#endif

  friend class SubtypedObject<Unit>;
  friend class UnitDatabase;
};

#endif
