
/*
 * LIB/XMAP.C
 *
 * Some machines fail if mmap() is passed with odd arguments.  The xmap() calls
 * page-align everything, allowing non-aligned offsets and sizes to be 
 * requested.
 */

#include "defs.h"

Prototype void *xmap(void *addr, size_t len, int prot, int flags, int fd, off_t offset);
Prototype void xunmap(void *addr, size_t len);

static int XPageMask;

void *
xmap(void *addr, size_t len, int prot, int flags, int fd, off_t offset)
{
    int n;
    void *ptr;
    struct stat st;

    if (XPageMask == 0)
	XPageMask = getpagesize() - 1;
    n = offset & XPageMask;
    offset -= n;
    len += n;
    len = (len + XPageMask) & ~XPageMask;

    st.st_size = 0;
    fstat(fd, &st);
    if (offset + len > ((st.st_size + XPageMask) & ~XPageMask)) {
        ptr = NULL;
    } else {
        ptr = (void *)mmap((caddr_t)addr, len, prot, flags, fd, offset);
    }
    if (ptr == (void *)-1)
	ptr = NULL;
    if (ptr)
	return((char *)ptr + n);
    return(NULL);
}

void
xunmap(void *ptr, size_t len)
{
    long n;				/* assume sizeof(long) == sizeof(ptr)*/

    if (XPageMask == 0)
	XPageMask = getpagesize() - 1;
    n = (long)ptr & XPageMask;
    ptr = (char *)ptr - n;
    len += n;
    len = (len + XPageMask) & ~XPageMask;

    munmap((caddr_t)ptr, len);
}

