/*
 *		     PLEASE DO NOT EDIT THIS FILE
 *		see documentation for more information
 *
 *
 *                  System Independent Trojka Core 
 *                Copyright (c) 1989-1996 Maarten Los
 *                             --------
 */
static char *_TROJKA_CORE_TAG_ = "System Independent Trojka Core 1.1";

#include "tr_core.h"

#include <stdlib.h>
#include <time.h>

/*
 *	variables
 */
tt_char		tv_field[tc_v_xsize][tc_v_ysize];  /* the playing matrix */
tt_char		tv_shadow[tc_v_xsize][tc_v_ysize]; /* shadow of it for scan */
tt_int		tv_shape;		/* the current block */
tt_long		tv_block_count[tc_blocks];	/* blocks/type */
tt_long		tv_blocks;		/* total blocks */
tt_long		tv_last_blocks;		/* total blocks */
tt_bool		tv_blocks_reset;	/* true if tv_blocks > MAXLONG */
tt_int		tv_x;		/* x position in field */
tt_int		tv_y;		/* y position in field */
tt_int		tv_speed;	/* current speed (0-9) */
tt_int		tv_ticks;	/* number of ticks in milliseconds for delay */
tt_int		tv_stacklevel;	/* height of the block stack */
tt_long		tv_score;	/* the score */
tt_long		tv_last_score;	/* the last score */
tt_bool		tv_score_reset;	/* true  if tv_score > MAXLONG */
tt_long		tv_trojkas;	/* number of trojka's */
tt_long		tv_last_trojkas;	/* the last number of trojkas */
tt_bool		tv_trojkas_reset;	/* true if tv_trojkas > MAXLONG */
tt_long		tv_wipes;	/* number of wipes */
tt_long		tv_last_wipes;	/* number of wipes */
tt_long		tv_wipes_reset;	/* true if tv_wipes > MAXLONG */
tt_long		tv_speed_switch;	/* score for spead increase */
tt_long		tv_wizard_switch;	/* score for next layout */
tt_bool		tv_is_wizard;	/* are we in wizard mode? */
tt_bool		tv_is_gaps;	/* are there gaps in the field pattern? */
tt_int		tv_lran_q_ptr;	/* layout random pointer */
tt_int		tv_lran_q[tc_layouts];
tt_int 		tv_layout[tc_layouts][5] =
{	{ 011331, 024413, 040000,      0,      0 },
	{ 010101, 040303, 010101, 040303, 010101 },
	{ 001210, 040004, 030003, 030003, 002120 },
	{ 010101, 000003, 030303, 000000, 040404 },
	{ 020202, 005050, 040404, 003030, 010101 },
	{ 035353, 041014, 040204,      0,      0 },
	{ 054245, 050005, 050005, 002020, 000200 },
	{ 010001, 031013, 011011, 031013, 010001 },
	{ 030003, 001130, 003110, 001130, 030003 },
	{ 011511, 040004, 020202, 040004, 011511 },
	{ 025341, 050000, 030350, 040010, 014320 },
	{ 010201, 021212, 003003, 001010, 010001 },
	{ 000300, 000300, 000300, 000300, 054345 },
	{      0, 005050, 033133, 005050,      0 },
	{ 000400, 000300, 000200, 000300, 000400 },
	{ 000300, 001010, 040004, 001010, 000300 },
	{ 013531, 002520, 000400, 002520, 013531 },
	{ 000300, 000400, 010501, 005050, 000500 },
	{ 000200, 000400, 033533, 000400, 000200 },
	{ 030303, 001010, 000400, 000200, 000200 },
	{ 010001, 003030, 000100, 003030, 010001 },
	{ 004240, 030003,      0, 004040,      0 },
	{ 000100, 004040, 030303, 020202, 050505 },
	{ 050505, 053535, 003030, 023232, 020202 },
	{ 055355, 005000, 000300, 000050, 055355 },
	{ 053535, 030203, 052525, 030203, 053535 },
	{ 052505, 030303, 010101, 030303, 050525 },
	{      0,      0,      0,      0, 055455 },
	{ 004253,      0, 031450,      0, 002143 },
	{ 053035, 002120, 053035, 002120, 053035 },
	{ 012121, 004340, 000300, 004340, 012121 },
	{ 005250, 020502, 012021, 020502, 005250 },
	{ 011022, 011022,      0, 033055, 033055 },
	{ 010001, 053035, 012421, 053035, 010001 },
	{ 043035, 020003, 020003, 020003, 043035 },
	{ 000055, 003300, 020000, 001100, 000044 },
	{ 033033, 000500, 005050, 002020, 004040 },
	{ 011000, 001100, 000440, 000044,      0 },
	{ 010001, 000300, 003530, 000300, 010001 },
	{ 000550, 000550, 033000, 033000,      0 },
	{ 055055, 044044, 033033, 022022, 011011 },
	{ 055110, 033550, 022330, 044220, 011440 }
};

/*
 *	function prototypes
 */
int	trojka_api(tt_command*);
void	tf_init(int, int);
int	tf_block_down(void);
void	tf_block_left(void);
void	tf_block_right(void);
void	tf_drop_block(void);
void	tf_check_speed(void);
void	tf_inc_speed(void);
void	tf_set_speed_var(void);
void	tf_check_wizard(void);
void	tf_set_wizard_switch(void);
void	tf_inc_score(int, tt_long);
void	tf_scan(void);
int	tf_field_scan(void);
void	tf_check_spider(void);
tt_bool	tf_has_gaps(void);
void	tf_shift_blocks(void);
void	tf_shift_down(int, int);
void	tf_explode(int, int);
int	tf_get_stack_level(void);
tt_bool tf_empty_row(int);
void	tf_reset_shadow(void);
void	tf_reset_block(void);
void	tf_build_layout(void);
void	tf_init_layout_random_q(void);
void	tf_draw_field(void);
int	tf_get_layout_random(void);
void	tf_constrain_speed(tt_int);


/********************************************************************
 * MAIN FUNCTIONS                                                   *
 ********************************************************************/


int trojka_api(cmd)
tt_command *cmd;
{
	/*
	 *	this is the main api to the core. The function can
	 *	be given multiple commands.
	 *	The return value and the parameters passed depend
	 *	on the command. See documentation.
	 */
	int res;	/* call-result */

	res = tc_res_normal;


	switch(cmd->command) {
		case tc_c_init:
			tf_init((tt_int)cmd->param1, (tt_bool)cmd->param2);
			break;

		case tc_c_drawfield:
			tf_draw_field();
			break;

		case tc_c_blockdown:
			res = tf_block_down();
			break;

		case tc_c_blockleft:
			tf_block_left();
			break;
	
		case tc_c_blockright:
			tf_block_right();
			break;

		case tc_c_dropblock:
			tf_drop_block();
			break;

		case tc_c_speedup:
			tf_inc_speed();
			break;
		
		case tc_c_setspeed:
			tf_constrain_speed((tt_int)cmd->param1);
			tf_set_speed_var();
			break;

		case tc_c_setwizard:
			tv_is_wizard = 1;
			break;

	}

	return res;
}


/*********************************************************************
 *	basic functions, called by the api.
 *********************************************************************/


void tf_init(speed, wizard)
tt_int speed;
tt_bool wizard;
/*
 *	initialize the game
 */
{
	int x,y;
	
	/*
	 *	reset the variables
 	 */
	tv_stacklevel = 0;
	tv_blocks = tv_last_blocks = (tt_long)0;
	tv_trojkas = tv_last_trojkas = (tt_long)0;
	tv_wipes = tv_last_wipes = (tt_long)0;
	tv_score = tv_last_score = (tt_long)0;
	tv_is_wizard = wizard;

	tf_set_wizard_switch();

	tv_blocks_reset = 0;
	tv_trojkas_reset = 0;
	tv_wipes_reset = 0;
	tv_score_reset = 0;
	
	tf_constrain_speed(speed);

	tf_set_speed_var();
	tf_reset_block();

	for(x = 0; x < tc_blocks; x++)
		tv_block_count[x] = (tt_long)0;


	/* 
	 *	clear the playfield
	 */
	for(x = 0; x < tc_v_xsize; x++)	/* clear virt. field */
		for(y = 1; y < tc_v_ysize; y++)
			tv_field[x][y] = tc_clear;
	for(x = 0;x < tc_v_xsize; x++)		/* fill bottom-line */
		tv_field[x][0] = tc_tagged;

	/*
	 *	init the layout queue 
	 */
	tf_init_layout_random_q(); 
	
	if(tv_is_wizard)
		tf_build_layout();
}



void tf_draw_field(void)
/*
 *	draws the field, and puts a layout on it, if in 
 *	wizard mode
 */
{
	int x,y;

	/*
	 *	draw all the blocks in the entire field
	 */
	for(y = tc_pm_top; y >= tc_pm_bottom; y--) {
		for(x = 0; x < tc_v_xsize; x++)
			trojka_make_block_callback(x,y,tv_field[x][y]);
	}

	if(tv_y <= tc_pm_top + 1)
		trojka_make_block_callback(tv_x, tv_y, tv_shape);
}



int tf_block_down(void)
/*
 *	move the block one down
 *
 *	returns one of the following:
 *		tc_res_touchdown	a block hit the ground
 *		tc_res_gameover		the game is over
 *		tc_res_normal		continue normal play
 *
 */
{
	tv_y--;
	if(tv_field[tv_x][tv_y] != tc_clear) {

		/*
		 *	the block has hit something
		 */

		tv_field[tv_x][tv_y + 1] = tv_shape;
		

		if(tv_blocks_reset)
			tv_blocks_reset = 0;
		if(tv_blocks < tv_last_blocks) {
			tv_blocks = (tt_long)0;
			tv_blocks_reset = 1;
		}
		tv_last_blocks = tv_blocks;
		tv_blocks++;


		tv_block_count[tv_shape-1]++;

		tf_check_speed();

		tf_reset_block();

		tf_inc_score(tc_i_touchdown,0);

		tf_scan();

		if(tv_stacklevel == tc_pm_top)
			return tc_res_gameover;

		tf_check_wizard();

		return tc_res_touchdown;

	} else {
		trojka_wipe_block_callback(tv_x, tv_y+1);
		trojka_make_block_callback(tv_x, tv_y, tv_shape);

		return tc_res_normal;
	}
}



void tf_block_left(void)
/*
 *	this function move the block one position to the left,
 *	if possible
 */
{
	if((tv_x > 0) && (tv_field[tv_x-1][tv_y] == tc_clear)) {

			trojka_wipe_block_callback(tv_x, tv_y); 
			tv_x--;
			trojka_make_block_callback(tv_x, tv_y, tv_shape); 
	}
}


void tf_block_right(void)
/*
 *	this function move the block one position to the right,
 *	if possible
 */
{
	if((tv_x < tc_v_xsize-1) && (tv_field[tv_x+1][tv_y] == tc_clear)) {
		trojka_wipe_block_callback(tv_x, tv_y);
		tv_x++;
		trojka_make_block_callback(tv_x, tv_y, tv_shape);
	}
}


void tf_drop_block(void)
/*
 *	drop a block until the bottom is reached 
 */
{
	tf_inc_score(tc_i_dropblock, 0);

	trojka_wipe_block_callback(tv_x, tv_y);
	while(tv_field[tv_x][tv_y] == tc_clear)
		tv_y--;
	tv_y++;
	trojka_make_block_callback(tv_x, tv_y, tv_shape);
}


/**********************************************************************
 *	support functions
 **********************************************************************/


void tf_check_speed(void)
/*
 *	Increase the game speed if possible
 */
{
	if(tv_blocks > tv_speed_switch) 
		tf_inc_speed();
}


void tf_inc_speed(void)
/*
 *	increase the speed. This function is called forcedly
 *	on a manual speed increase, and implicitely by 
 *	'tf_check_speed()'
 */
{
	if(tv_speed < tc_max_speed) {
		tv_speed++;
		tf_set_speed_var();
		trojka_speedup_callback(tv_speed);
	}
}


void tf_set_speed_var(void)
/*
 *	this function sets the parameters depending on speed
 */
{
	tv_ticks = 200 - ((tv_speed)*15);
	tv_speed_switch = tc_speed_switch * tv_speed;
}


void tf_check_wizard(void)
/*
 *	See if wizard needs a layout. If so, put a new layout
 *	in the playfield.
 *	Returns 1 on wizard change, 0 otherwise
 *	Only call after a tf_scanfield() ! ! ! ! !
 */
{
	if(!tv_is_wizard)
		return;

	if((!tv_is_gaps) && (tv_score > tv_wizard_switch)
	&& (tv_stacklevel <= 9)) {
		tf_build_layout();	
		tf_draw_field();
		tf_set_wizard_switch();
	}	
}

void tf_set_wizard_switch()
/*
 *	set the wizard switch. (it is called from 'check_wizard' and
 *	'init_game()'
 */
{
	tv_wizard_switch = tv_score + (tt_long)(2+((rand()%10))*500)+2000;
}

void tf_inc_score(type, amount)
int type;
tt_long amount;
/*
 *	increase the score depending on the type in the call:
 *	tc_i_touchdown:	the block has just normally hit another block
 *			or the ground
 *	tc_i_dropblock:	the drop is forcedly dropped
 *	tc_i_force:	add the amount 'amount' to the score.	
 */
{
	tt_long add;

	switch(type) {

	  case tc_i_touchdown:
		add = (tt_long)((((tv_shape*tv_speed)+(tv_speed-1))/3)+1);
		break;

	  case tc_i_dropblock:
		add =  (tt_long)((tv_y * tv_speed) / 5);
		break;

	  case tc_i_force:
		add = amount;
		break;
	}

	if(tv_is_wizard)
		add += 2 + (rand() % tc_blocks);

	if(tv_score_reset)
		tv_score_reset = 0;

	if(tv_last_score > tv_score) {
		tv_score_reset = 1;
		tv_score = (tt_long)0;
	}
	tv_last_score = tv_score;
	tv_score += add;
	
}



void tf_scan(void)
{
/*
 *	NOTE: this is a very inefficient algorithm!
 *	Return values:
 *		height of blockstack
 *
 */
	tt_long	trojka_score;

	int wipe_bonus, wipe_count, wiped;

	tv_stacklevel = tf_get_stack_level();
	wiped = 0;


	trojka_score = (tt_long)tc_trojkabonus;
	wipe_bonus = 1;
	wipe_count = 0;
	tf_reset_shadow();
	
	while((wiped = tf_field_scan()) > 0) {

		tf_shift_blocks();

		wipe_bonus *= 2;
		tf_inc_score(tc_i_force, (tt_long)(wipe_bonus*wiped*10));

		wipe_count++;
		if(((int)wipe_count % tc_trojka) == 0) {

			tf_inc_score(tc_i_force, trojka_score);
			trojka_trojka_callback(trojka_score);
		
			trojka_score *= 2;

			if(tv_trojkas_reset)
				tv_trojkas_reset = 0;
			if(tv_trojkas < tv_last_trojkas) {
				tv_trojkas = (tt_long)0;
				tv_trojkas_reset = 1;
			}
			tv_last_trojkas = tv_trojkas;
			tv_trojkas++;

		}

		if(tv_wipes_reset)
			tv_wipes_reset = 0;
		if(tv_wipes < tv_last_wipes) {
			tv_wipes = (tt_long)0;
			tv_wipes_reset = 1;
		}
		tv_last_wipes = tv_wipes;
		tv_wipes++;
	}

	if((tv_stacklevel <= tc_pm_bottom) && (tv_wipes > 0)
	&& (tf_empty_row(tc_pm_bottom)))
	{
		tf_inc_score(tc_i_force, tc_bottombonus);
		trojka_bottom_callback(tc_bottombonus);
	}

	tv_is_gaps = tf_has_gaps();

}



int tf_field_scan(void)
/*
 *	do an actual scan of the playing matrix
 *	returns the number of wipes times 3.
 */
{
	tt_int x,y, wiped;
	tt_char cur;
	
	tv_stacklevel = tf_get_stack_level();


	wiped = 0;

	tf_check_spider();

	for(x = 1; x < tc_v_xsize - 1; x++) {
		for(y = tv_stacklevel; y >= tc_pm_bottom; y--) {
			if((cur = tv_field[x][y]) > 0) {
/* "\" */			if ((tv_field[x-1][y-1] == cur)
				&& (tv_field[x+1][y+1] == cur)) {
				   tv_shadow[x-1][y-1] 
					= tv_shadow[x+1][y+1] 
					= tv_shadow[x][y] = tc_tagged;
				   wiped++;
				}
/* "/" */			if ((tv_field[x-1][y+1] == cur)
				&& (tv_field[x+1][y-1] == cur)) {
				   tv_shadow[x-1][y+1]
					= tv_shadow[x][y]
					= tv_shadow[x+1][y-1] = tc_tagged;
				   wiped++;
				}
/* "--" */			if ((tv_field[x-1][y] == cur)
				&& (tv_field[x+1][y] == cur)) {
				   tv_shadow[x-1][y]
					= tv_shadow[x+1][y]
					= tv_shadow[x][y] = tc_tagged;
				   wiped++;
				}
			}
		}
	}
	return wiped * 3;
}


void tf_check_spider(void)
{
	tt_long spider_score;
	tt_char cur;
	tt_int y;

	for(y = tv_stacklevel; y >= (tc_pm_bottom + 2); y--) {
	/*
	 *	ok, what follows is not your typical fine art of programming,
	 *	but it should do it.
	 */
		spider_score = (tt_long)0;
		if((cur = tv_field[tc_virt_middle][y]) <= 0)
			cur = -9;

		if((cur == tv_field[tc_virt_middle-1][y+1])
		&& (cur == tv_field[tc_virt_middle-2][y+2])
		&& (cur == tv_field[tc_virt_middle+1][y+1])
		&& (cur == tv_field[tc_virt_middle+2][y+2])
		&& (cur == tv_field[tc_virt_middle+1][y-1])
		&& (cur == tv_field[tc_virt_middle+2][y-2])
		&& (cur == tv_field[tc_virt_middle-1][y-1])
		&& (cur == tv_field[tc_virt_middle-2][y-2])) {
			
			spider_score = tc_spiderbonus;

			if((cur == tv_field[tc_virt_middle-1][y]) 
			&& (cur == tv_field[tc_virt_middle-2][y])
			&& (cur == tv_field[tc_virt_middle+1][y])
			&& (cur == tv_field[tc_virt_middle+2][y])) {

				spider_score = tc_bigspiderbonus;	

			}

			tf_inc_score(tc_i_force, spider_score);
			trojka_spider_callback(spider_score);
		
		}
	}
}


tt_bool tf_has_gaps(void)
{
	int x,y;
	tt_bool gap_found;

	for(x = 0; x < tc_v_xsize; x++) {
		gap_found = 0;
		for(y = tc_pm_bottom; y < tv_stacklevel; y++) {
			if((tv_field[x][y] > 0) && (gap_found))
				return 1;
			else if(tv_field[x][y] == 0)
				gap_found = 1;
		}
	}
	return 0;
}


void tf_shift_blocks(void)
/*
 *	shift all the blocks in the playing field,
 *	after a collapse.
 */
{
	int x, y;

	for(x = 0; x < tc_v_xsize; x++) {
		for(y = tv_stacklevel; y > 0; y--) {
			if(tv_shadow[x][y] == tc_tagged) {
				tf_explode(x, y);
				tf_shift_down(x, y);
				tv_shadow[x][y] = tc_clear;
			}
		}
	}
}



void tf_shift_down(x, y)
int x, y;
/*
 *	shift down a row of blocks, both  on-screen and in the matrix
 */
{
	while(tv_field[x][y] != tc_clear) {
		tv_field[x][y] = tv_field[x][y+1];
		trojka_make_block_callback(x, y, tv_field[x][y]);
		y++;
	}
}


void tf_explode(x, y)
int x, y;
{
	trojka_explode_callback(x,y);
	trojka_wipe_block_callback(x,y);
}


int tf_get_stack_level(void)
/*
 *	returns the last empty line in the virtual field
 */
{
	int y = tc_pm_top;

	while(tf_empty_row(y))
		y--;

	return y ;
}


tt_bool tf_empty_row(y)
int y;
{
	int x;

	for(x = 0; x < tc_v_xsize; x++)
		if(tv_field[x][y] != tc_clear)
			return 0;
	return 1;
}


void tf_reset_shadow(void)
{
	int x,y;

	for(x = 0; x < tc_v_xsize;x++)
		for(y = 0; y < tc_v_ysize;y++)
			tv_shadow[x][y] = tc_clear;
}


void tf_reset_block(void)
/*
 *	reset the falling block to the top of the playing field
 *	
 */
{
	tv_y = tc_pm_top + 1;
	tv_x = tc_virt_middle;
	tv_shape = (rand() % tc_blocks) + 1;

}

/**********************************************************************
 *	layout functions
 **********************************************************************/


void tf_build_layout(void)
/*
 *	put a layout patter in the playing field (but don't draw it)
 */
{
	int x,y;
	int pattern;
	tt_char block;
	int layout = tf_get_layout_random();

	for(y = tc_pm_bottom; y < (tc_pm_bottom + 5); y++) {
		for(x = 0; x < tc_blocks; x++) {
			pattern = tv_layout[layout][y-1];
			block = (pattern >> (x*3)) & tc_layout_mask;
			tv_field[x][y] = block;
		}
	}
}



void tf_init_layout_random_q(void)
/*
 *	initialize the random queue
 */
{
	int i;
	srand(time(0));
	
	tv_lran_q_ptr = tc_layouts;
	for(i = 0; i < tv_lran_q_ptr; i++)
		tv_lran_q[i] = i;
}


int tf_get_layout_random(void)
/*
 *	get a random queue element, and swap it with one already
 *	used
 */
{
	int rnd;

	rnd = tv_lran_q[rand() % tv_lran_q_ptr];

	tv_lran_q[rnd] = tv_lran_q[--tv_lran_q_ptr];
	tv_lran_q[tv_lran_q_ptr] = rnd;

	if(tv_lran_q_ptr == 0)
		tf_init_layout_random_q();

	return rnd;
}


void tf_constrain_speed(speed)
int speed;
/*
 * constrain the speed between a value of 1 and 9
 */
{
	tv_speed = (speed > tc_max_speed) ? tc_max_speed : 
					(speed < tc_min_speed) ? 1 : speed;
}
