/* 
 * update_display.c
 *
 * routines to perform the refresh of an XImage
 * they are put in a separate file due to very special ones: most of them are
 * a collection of special cases in order to get most accuracy
 *
 */

#define __UPDATE_DSP_C_

/* nonsense in linux SuperVga code */
#ifndef svgalib

#include "xmame.h"

#define max(x,y) (((x)>(y))?(x):(y))
#define min(x,y) (((x)<(y))?(x):(y))

static int (*update_display_func)(void);
static char *copybuffer;

#define MAX_DIRTYLINES 2048
struct _dirty_lines {
	int x,y;
	char *start;
	char *end;
} dirty[MAX_DIRTYLINES]; /* dirty, should be done via malloc */

int osd_init_dirty(void) {
    int i;
    memset((void *)&dirty[0],0,MAX_DIRTYLINES*sizeof(struct _dirty_lines));
    for (i=0;i<MAX_DIRTYLINES;i++) dirty[i].y=i;
    return 0;
}

void  osd_mark_dirty(int sx,int sy, int ex, int ey, int ui) {
#ifdef USE_DIRTY
	int line;
	char *spt,*ept;
	for (line=sy; line<=ey; line++) {
	    spt = (char *)bitmap->_private + line*bitmap->width + sx;
	    ept = (char *)bitmap->_private + line*bitmap->width + ex+1;
	    if ( !dirty[line].start) dirty[line].start=spt;
	    else dirty[line].start = min(dirty[line].start,spt);
	    if ( !dirty[line].end) dirty[line].end=ept;
	    else dirty[line].end = max(dirty[line].end,ept);
	    if ( !dirty[line].x) dirty[line].x=sx;
	    else dirty[line].x = max(dirty[line].x,sx);
	}
#endif
	return;
}

/*
 * Since *we* control the bitmap buffer and a pointer to the data is stored
 * in 'image', all we need to do is a XPutImage.
 *
 * For compatibility, we accept a parameter 'bitmap' (not used).
 */

/* used when expose events received */
void osd_refresh_screen(void) {
#ifdef USE_MITSHM
    if (mit_shm_avail) {
	XShmPutImage (display, window, gc, image, 0, 0, 0, 0, image->width, image->height, FALSE);
    } else { /* no shm: just use XPutImage */
#endif
        XPutImage (display, window, gc, image, 0, 0, 0, 0, image->width, image->height);
#ifdef USE_MITSHM
    }
#endif
   /* some games "flickers" with XFlush, so command line option is provided */
   if(use_xsync) XSync (display,False); /* be sure to get request processed */
   else XFlush (display); 		/* flush buffer to server */
}

void osd_refresh_dirty_screen(void) {
    int line,lineto;
#ifdef USE_MITSHM
    if (mit_shm_avail) {
	/* just parse every dirty lines and send it to X-Server */
	for (line=0; line<bitmap->height; line++) {
	    if (!dirty[line].start) continue; 
	    /* go till next non-dirty line */
	    for(lineto=line; dirty[lineto].start; lineto++);
	    XShmPutImage (display, window, gc, image, 
			0, line*heightscale, 0, line*heightscale , 
			image->width, (lineto-line)*heightscale, FALSE);
	    /* now mark parsed lines as clean */
	   memset((void *)&dirty[line],0,(lineto-line)*sizeof(struct _dirty_lines) );
	   line=lineto;
	   /*
	   for(; line<lineto; line++) {
	       dirty[line].start=dirty[line].end = (char *) NULL;
	       dirty[line].x = 0;
	   }
	   */
	}
    } else { /* no shm: just use XPutImage */
#endif
	for (line=0; line<bitmap->height; line++) {
	    if (!dirty[line].start) continue; 
	    /* go till next non-dirty line */
	    for(lineto=line; dirty[lineto].start; lineto++);
            XPutImage (display, window, gc, image, 
			0, line*heightscale, 0, line*heightscale, 
			image->width, (lineto-line)*heightscale);
	    /* now mark parsed lines as clean */
	   memset((void *)&dirty[line],0,(lineto-line)*sizeof(struct _dirty_lines) );
	   line=lineto;
	   /*
	   for(; line<lineto; line++) {
	       dirty[line].start=dirty[line].end = (char *) NULL;
	       dirty[line].x = 0;
	   }
	   */
	}
#ifdef USE_MITSHM
    }
#endif
   /* some games "flickers" with XFlush, so command line option is provided */
   if(use_xsync) XSync (display,False); /* be sure to get request processed */
   else XFlush (display); 		/* flush buffer to server */
}

/* invoked by main tree code ro update bitmap into screen */
void osd_update_display(void)
{
    int needupdate;
    /* if F12 pressed, make a snapshot of the screen */
    if(osd_key_pressed(OSD_KEY_F12) ) osd_snapshot(); 
    /* call propper update routine */
    needupdate = (*update_display_func)();
    /* no longer needed */
    /* if (needupdate) osd_refresh_screen(); */
}

int do_update_pseudo_dirty_scale1(void) {
	char *pt;
	int line;
	for (line=0; line<bitmap->height; line++) {
	   for (pt=dirty[line].start; pt<dirty[line].end; pt++)
	      *( scaled_buffer_ptr+(pt - (char *)bitmap->_private) ) = (char)xpixel[*pt];
#ifndef DIRTY_RFSH
	   dirty[line].start=dirty[line].end = (char *) NULL;
	   dirty[line].x = 0;
	}
	osd_refresh_screen();
#else
	}
	osd_refresh_dirty_screen();
#endif
	return 0;
}

int do_update_pseudo_scale1(void) {
	long *spt=(long *)bitmap->_private;
	long *dpt=(long *)copybuffer;
	byte *dpypt=scaled_buffer_ptr;	
	long *end=(long *)( (char *)bitmap->_private+bitmap->width*bitmap->height );
	for (;spt<end;spt++,dpt++,dpypt+=4) if (*spt!=*dpt) break;
	if (spt==end) return 0; /* no need to update display */
	for (;spt<end;spt++,dpt++,dpypt+=4) {
	    if (*spt!=*dpt) {
		*dpypt=xpixel[0xff & *((char *)spt)];	
		*(dpypt+1)=xpixel[0xff & *((char *)spt+1)];	
		*(dpypt+2)=xpixel[0xff & *((char *)spt+2)];	
		*(dpypt+3)=xpixel[0xff & *((char *)spt+3)];	
		*dpt=*spt;
	    }
	}
	osd_refresh_screen();
	return 0;
}

int do_update_pseudo_generic(void) {
	int i;
	int x,y,px,py;
	long color;
	byte *dpypt;
	char *bytept;
	long *spt=(long *)bitmap->_private;
	long *dpt=(long *)copybuffer;
	long *end=(long *)( (char*)bitmap->_private+bitmap->width*bitmap->height);
	/* do a long compare to speed-up code ( malloc suppossed to provide aligned buffers ..) */
	for (;spt<end;spt++,dpt++) if (*spt!=*dpt) break;
	if (spt==end) return 0;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		for (bytept=(char *)spt,i=0;i<4;i++,bytept++) {
		    if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
		    /* now perform a byte-by-byte search in current long pt */
		    color=xpixel[0xff & *bytept];
		    /* evaluate pixel coordinates */
		    x =( (bytept - (char *) bitmap->_private) % bitmap->width );
		    y =( (bytept - (char *) bitmap->_private) / bitmap->width );
		    dpypt=scaled_buffer_ptr + heightscale*y*image->bytes_per_line + x*widthscale;
		    for(py=0;py<heightscale;py++) 
		        for(px=0;px<widthscale;px++) 
			    *(dpypt+py*image->bytes_per_line+px)=color;
	        } /* for byte */
		*dpt=*spt;
	    } /* if long is not equal */
	} /* for buffer */
	osd_refresh_screen();
	return 0;
}

int do_update_pseudo_dirty_generic(void) {
    char *pt;
    byte *dpt,*auxpt;
    int line;
    int i;
    for (line=0; line<bitmap->height; line++) {
       if( ! dirty[line].start ) continue;
       dpt = auxpt = scaled_buffer_ptr + heightscale*line*image->bytes_per_line + widthscale*dirty[line].x;
       for(pt=dirty[line].start;pt<dirty[line].end;pt++,dpt+=widthscale)
	   for(i=0;i<widthscale;i++) *(dpt+i)=(char)xpixel[0xff & *pt];
       /* and now perform a memcpy to next lines */
       for (i=1;i<heightscale;i++)
           memcpy(auxpt+i*image->bytes_per_line,auxpt,widthscale*(dirty[line].end-dirty[line].start));
#ifndef DIRTY_RFSH
       /* finaly reset dirty entry */
       dirty[line].start = dirty[line].end = (char *) NULL;
       dirty[line].x = 0;
    }
    osd_refresh_screen();
#else
    }
    osd_refresh_dirty_screen();
#endif
    return 0;
}

int do_update_pseudo_dirty_scale2(void) {
    char *pt;
    byte *dpt,*auxpt;
    int line;
    for (line=0; line<bitmap->height; line++) {
       if( ! dirty[line].start ) continue;
       dpt = auxpt =
	    scaled_buffer_ptr + 2*line*image->bytes_per_line + 2*dirty[line].x;
       for(pt=dirty[line].start;pt<dirty[line].end;pt++,dpt+=2) {
	   *dpt    =(char)xpixel[0xff & *pt];
	   *(dpt+1)=(char)xpixel[0xff & *pt];
       }
       /* and now perform a memcpy to next line */
       memcpy(auxpt+image->bytes_per_line,auxpt,2*(dirty[line].end-dirty[line].start));
#ifndef DIRTY_RFSH
       /* finaly reset dirty entry */
       dirty[line].start = dirty[line].end = (char *) NULL;
       dirty[line].x = 0;
    }
    osd_refresh_screen();
#else
    }
    osd_refresh_dirty_screen();
#endif
    return 0;
}

int do_update_pseudo_scale2(void) {
	int i;
	int x,y;
	long color;
	byte *dpypt;
	char *bytept;
	long *spt=(long *)bitmap->_private;
	long *dpt=(long *)copybuffer;
	long *end=(long *)( (char*)bitmap->_private+bitmap->width*bitmap->height);
	/* do a long compare to speed-up code ( malloc suppossed to provide aligned buffers ..) */
	for (;spt<end;spt++,dpt++) if (*spt!=*dpt) break;
	if (spt==end) return 0;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		for (bytept=(char *)spt,i=0;i<4;i++,bytept++) {
		    if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
		    /* now perform a byte-by-byte search in current long pt */
		    color=xpixel[0xff & *bytept];
		    /* evaluate pixel coordinates */
		    x =( (bytept - (char *) bitmap->_private) % bitmap->width );
		    y =( (bytept - (char *) bitmap->_private) / bitmap->width );
		    dpypt=scaled_buffer_ptr + 2*y*image->bytes_per_line + x*2;
		    /* and draw pixel in image */
		    *dpypt=color;*(dpypt+1)=color; 
		    dpypt+=image->bytes_per_line;
		    *dpypt=color; *(dpypt+1)=color;
                } /* for byte */
		*dpt=*spt; /* mark long as updated */
	    } /* if long is not equal */
	} /* for buffer */
	osd_refresh_screen();
	return 0;
}

int do_update_pseudo_dirty_scale3(void) {
    char *pt;
    byte *dpt,*auxpt;
    int line;
    for (line=0; line<bitmap->height; line++) {
       if( ! dirty[line].start ) continue;
       dpt = auxpt =
	    scaled_buffer_ptr + 3*line*image->bytes_per_line + 3*dirty[line].x;
       for(pt=dirty[line].start;pt<dirty[line].end;pt++,dpt+=3) {
	   *dpt    =(char)xpixel[0xff & *pt];
	   *(dpt+1)=(char)xpixel[0xff & *pt];
	   *(dpt+2)=(char)xpixel[0xff & *pt];
       }
       /* and now perform a memcpy to next line */
       memcpy(auxpt+image->bytes_per_line,auxpt,3*(dirty[line].end-dirty[line].start));
       memcpy(auxpt+2*image->bytes_per_line,auxpt,3*(dirty[line].end-dirty[line].start));
#ifndef DIRTY_RFSH
       /* finaly reset dirty entry */
       dirty[line].start = dirty[line].end = (char *) NULL;
       dirty[line].x = 0;
    }
    osd_refresh_screen();
#else
    }
    osd_refresh_dirty_screen();
#endif
    return 0;
}

int do_update_pseudo_scale3(void) {
	int i;
	int x,y;
	long color;
	byte *dpypt;
	char *bytept;
	long *spt=(long *)bitmap->_private;
	long *dpt=(long *)copybuffer;
	long *end=(long *)( (char*)bitmap->_private+bitmap->width*bitmap->height);
	/* do a long compare to speed-up code ( malloc suppossed to provide aligned buffers ..) */
	for (;spt<end;spt++,dpt++) if (*spt!=*dpt) break;
	if (spt==end) return 0;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		for (bytept=(char *)spt,i=0;i<4;i++,bytept++) {
		    if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
		    /* now perform a byte-by-byte search in current long pt */
		    color=xpixel[0xff & *bytept];
		    /* evaluate pixel coordinates */
		    x =( (bytept - (char *) bitmap->_private) % bitmap->width );
		    y =( (bytept - (char *) bitmap->_private) / bitmap->width );
		    dpypt=scaled_buffer_ptr + 3*y*image->bytes_per_line + x*3;
		    /* and draw pixel in image */
		    *dpypt=color;*(dpypt+1)=color; *(dpypt+2)=color;
		    dpypt+=image->bytes_per_line;
		    *dpypt=color;*(dpypt+1)=color; *(dpypt+2)=color;
		    dpypt+=image->bytes_per_line;
		    *dpypt=color;*(dpypt+1)=color; *(dpypt+2)=color;
                } /* for byte */
		*dpt=*spt; /* mark long as updated */
	    } /* if long is not equal */
	} /* for buffer */
	osd_refresh_screen();
	return 0;
}

int do_update_truec_generic(void) {
	int i,j;
	int x,y;
	long color;
	char *spt=(char *)bitmap->_private;
	char *dpt=copybuffer;
	char *end=(char *)bitmap->_private+bitmap->width*bitmap->height;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		*dpt=*spt;
		color=xpixel[0xff & *spt];
		/* evaluate pixel coordinates */
		x = widthscale * ( (long)(spt - (char *) bitmap->_private) % bitmap->width );
		y = heightscale * ( (long)(spt - (char *) bitmap->_private) / bitmap->width );
		for(j=0;j<heightscale;j++) 
		    for(i=0;i<widthscale;i++) XPutPixel(image,x+i,y+j,color);
	    }
	}
	osd_refresh_screen();
	return 0;
}

int do_update_truec_dirty_scale1(void) {
	char *pt;
	int line;
	int x,y;
	for (line=0; line<bitmap->height; line++) {
	   if (!dirty[line].start) continue;
	   x = widthscale * ( (dirty[line].start - (char *)bitmap->_private) % bitmap->width );
	   y = heightscale * ( (dirty[line].start - (char *)bitmap->_private) / bitmap->width );
	   for (pt=dirty[line].start; pt<dirty[line].end; pt++,x++)
		XPutPixel(image,x,y,xpixel[*pt]);
#ifndef DIRTY_RFSH
	   dirty[line].start=dirty[line].end = (char *) NULL;
	}
	osd_refresh_screen();
#else
	}
	osd_refresh_dirty_screen();
#endif
	return 0;
}

int do_update_truec_scale1(void) {
	int x,y;
	long color;
	char *spt=(char *)bitmap->_private;
	char *dpt=copybuffer;
	char *end=(char *)bitmap->_private+bitmap->width*bitmap->height;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		*dpt=*spt;
		color=xpixel[0xff & *spt];	
		x = widthscale * ( (long)(spt - (char *) bitmap->_private) % bitmap->width );
		y = heightscale * ( (long)(spt - (char *) bitmap->_private) / bitmap->width );
		XPutPixel(image,x,y,color);
	    }
	}
	osd_refresh_screen();
	return 0;
}

int do_update_truec_scale2(void) {
	int x,y;
	long color;
	char *spt=(char *)bitmap->_private;
	char *dpt=copybuffer;
	char *end=(char *)bitmap->_private+bitmap->width*bitmap->height;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		*dpt=*spt;
		color=xpixel[0xff & *spt];	
		x = 2 * ( (long)(spt - (char *) bitmap->_private) % bitmap->width );
		y = 2 * ( (long)(spt - (char *) bitmap->_private) / bitmap->width );
		XPutPixel(image,x,y,color); XPutPixel(image,x+1,y,color);
		XPutPixel(image,x,y+1,color); XPutPixel(image,x+1,y+1,color);
	    }
	}
	osd_refresh_screen();
	return 0;
}

int do_update_truec_scale3(void) {
	int x,y;
	long color;
	char *spt=(char *)bitmap->_private;
	char *dpt=copybuffer;
	char *end=(char *)bitmap->_private+bitmap->width*bitmap->height;
	for (;spt<end;spt++,dpt++) {
	    if (*spt!=*dpt) {
		*dpt=*spt;
		color=xpixel[0xff & *spt];	
		x = 3 * ( (long)(spt - (char *) bitmap->_private) % bitmap->width );
		y = 3 * ( (long)(spt - (char *) bitmap->_private) / bitmap->width );
		/* sure that there are better ways to do, but no time to investigate :-( */
		XPutPixel(image,x,y,color);   XPutPixel(image,x+1,y,color);   XPutPixel(image,x+2,y,color);
		XPutPixel(image,x,y+1,color); XPutPixel(image,x+1,y+1,color); XPutPixel(image,x+2,y+1,color);
		XPutPixel(image,x,y+2,color); XPutPixel(image,x+1,y+2,color); XPutPixel(image,x+2,y+2,color);
	    }
	}
	osd_refresh_screen();
	return 0;
}

#define DSP_SCALE_GENERIC 	0
#define DSP_SCALE_1	      	1
#define DSP_SCALE_2		2
#define DSP_SCALE_3		3

#define DSP_USE_TRUECOLOR	4
#define DSP_USE_DIRTY    	8

int (*update_funcs[])(void) = {
/* normal ( parsing image bitmap strategy */
	 do_update_pseudo_generic,
	 do_update_pseudo_scale1,
	 do_update_pseudo_scale2,
	 do_update_pseudo_scale3,
	 do_update_truec_generic,
	 do_update_truec_scale1,
	 do_update_truec_scale2,
	 do_update_truec_scale3,
/* dirty_lines strategy */
	 do_update_pseudo_dirty_generic,
	 do_update_pseudo_dirty_scale1,
	 do_update_pseudo_dirty_scale2,
	 do_update_pseudo_dirty_scale3,
	 do_update_truec_generic,
	 do_update_truec_dirty_scale1,
	 do_update_truec_scale2,
	 do_update_truec_scale3
};

int eval_update_display_func(void) {
	int index=0;
#ifdef USE_DIRTY
	fprintf(stderr,"Using dirty_buffer strategy");
#ifdef DIRTY_RFSH
	fprintf(stderr," & screen refresh\n");
#else
	fprintf(stderr,"\n");
#endif
	osd_init_dirty();
	if (force_truecolor)	     index |= DSP_USE_DIRTY;
#endif
	if (force_truecolor)	     index |= DSP_USE_TRUECOLOR;
	if (heightscale!=widthscale) index |= DSP_SCALE_GENERIC;
	else {
	    if (heightscale > 3)     index |= DSP_SCALE_GENERIC;
	    else                     index |= heightscale;
	}
	/* now set update_display pointer */
	update_display_func=update_funcs[index];
	copybuffer=(char *)malloc( (bitmap->width) * (bitmap->height) * sizeof(char) );
	if (!copybuffer) {
	    fprintf(stderr,"Cannot allocate space for copybuffer\n");
	    return OSD_NOT_OK;
	}
	return OSD_OK;
}

/* if not defined svgalib */
#endif
