/*
 ******************* X-Mame header file *********************
 * file "xmame.h"
 *
 * by jantonio@dit.upm.es
 *
 ************************************************************
*/

#ifndef __XMAME_H_
#define __XMAME_H_

#ifdef __MAIN_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/*
 * Include files.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <ctype.h>
#include <pwd.h>

#ifdef linux
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined FREEBSD && ( ! defined BSDi )
#include <machine/soundcard.h>
#else
#include <sys/soundcard.h>
#endif
#include <sys/ioctl.h>
#include <errno.h>
#endif

#ifndef svgalib 
/* the svgalib version doesn't need these X-includes */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#ifdef X11_JOYSTICK
#include <X11/extensions/XI.h>
#include <X11/extensions/XInput.h>
/* event types returned by XSelecExtensionEvent() */
int num_x_buttons;
int devicebuttonpress;
int devicebuttonrelease;
int devicemotionnotify;
int devicebuttonmotion;
/* ifdef X11_JOYSTICK */
#endif

#ifdef USE_MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#ifdef HAS_XPM
#include <X11/xpm.h>
#endif

/* notdef svgalib */
#endif

#include "osdepend.h"

/*
 * Definitions.
 */

typedef unsigned char		byte;

#define OSD_NUMKEYS		(100)

#ifndef TRUE
#define	TRUE			(1)
#endif

#ifndef FALSE
#define FALSE			(0)
#endif

#define OSD_OK			(0)
#define OSD_NOT_OK		(1)

#define DEBUG(x)


/*
 * Global variables.
 */

#ifndef svgalib 
/* some more X-stuff we don't need for svgalib */

#ifdef USE_MITSHM
EXTERN XShmSegmentInfo 	shm_info;
#endif
EXTERN Display 		*display;
EXTERN Window 		 window;
EXTERN Screen 		*screen;
EXTERN Colormap 	 colormap;
EXTERN XImage 		*image;
EXTERN GC 		 gc;
EXTERN int             eval_update_display_func(void);
EXTERN byte  		*scaled_buffer_ptr ;
EXTERN unsigned long 	*xpixel; /* Pixel index values */
EXTERN byte		*buffer_ptr;

/* ndef svgalib */
#endif

/* global variables and miscellaneous flags */

EXTERN unsigned int 	widthscale;    /* X scale */
EXTERN unsigned int 	heightscale;   /* Y SCALE */
EXTERN int 		mit_shm_avail; /* use mitshm if available */
EXTERN char 		*displayname;   /* default is use local */
EXTERN char		*mamedir;       /* home directory of mame tree */
EXTERN char		*spooldir;      /* directory to store high scores */
EXTERN char		*towns_pad_dev; /* name of FM-TOWNS device */
EXTERN char 		*x11joyname;
EXTERN char             *audiodevice;   /* /dev/dsp or /dev/audio */
EXTERN int		joyfilter;
EXTERN int		swapjoyaxis;
EXTERN int		use_joystick;
EXTERN int		use_trakball;
EXTERN int		use_mouse;
EXTERN int		play_sound;
EXTERN int		use_private_cmap;
EXTERN int		use_xsync;
EXTERN int		video_mode;
EXTERN int		force_truecolor;
EXTERN unsigned char	No_FM;
EXTERN int              showconfig;

EXTERN int		video_sync;
EXTERN int 		snapshot_no;
EXTERN struct osd_bitmap *bitmap;

#ifndef svgalib
/*
 * Workaround: in DO$, the Allegro library maintains this array.
 * In X, we'll have to do it ourselves. Bummer.
 *
 * Note: this can be speeded up considerably (see the enormous switch
 * statement in osd_key_pressed).
 */

EXTERN byte			 key[OSD_NUMKEYS];
/*notdef svgalib*/
#endif

/* system dependent functions */

int sysdep_init(void);
void sysdep_exit(void);

/* audio related */
int start_timer();
int sysdep_audio_initvars(void);
long sysdep_get_audio_freespace(void);
int sysdep_play_audio(byte *buf, int size);
void sysdep_fill_audio_buffer(long *in,char *out,int start,int end);

/* keyboard related */
int sysdep_keyboard_init(void);
void sysdep_keyboard_close(void);
int sysdep_mapkey(int from, int to);

/* mouse related */
int sysdep_mouse_init(void);
void sysdep_mouse_close(void);

/* trakball related */
int sysdep_trakball_init(void);
void sysdep_trakball_close(void);
void sysdep_poll_trakball(void);

/* joystick related */
int sysdep_joy_initvars(void);
int x11_joystick_init(void);
void sysdep_joy_close(void);

/* miscelaneous */
#ifndef svgalib
void process_mouse_event(XEvent *event);
void process_x11_joy_event(XEvent *event);
int osd_snapshot(void);
void osd_refresh_screen(void);
#endif

#undef EXTERN
#endif
