// Copyright (c) 1997 Philip A. Hardin (pahardin@cs.utexas.edu)
//
// You may reuse and/or modify this source code for non-profit,
// non-commercial purposes without further permission from the author,
// provided that the source code retains this copyright/permission notice.
// Use of the source code for any other purpose requires prior permission
// from the author.


#include <iostream.h>
#include "bsppanel3d.h"



/***************************************************************************/
bspPanel3d::bspPanel3d(const Polygon3f& poly, fastPts& pts,
		       const bspPanel3d& panel) {
  table<int> newPtNums;
  newPtNums.Add( (int) panel.doubleSided);

  forii(poly.numverts) {
    int ptNum= pts.Add(pt3d(poly.verts[i][0],
			    poly.verts[i][1],
			    poly.verts[i][2]));
    newPtNums.Add(ptNum);
  }
  newPtNums.Add(-1);
  int *ptNumsArray= newPtNums.Array();
  panel3d::Init(ptNumsArray,pts.Array());
}


/*-------------------------------------------------------------------------*/
Polygon3f bspPanel3d::asPolygon3f(pt3d pts[]) {
  Polygon3f poly;
  
  if (ptNums.Num() >MAXPOLYVERT) {
    cerr << "too many panel3d points (" << ptNums.Num()
	 << ") for a Polygon3f (max " << MAXPOLYVERT << ")." << endl;
    poly.numverts= 0;
  }
  else {
    poly.numverts= ptNums.Num();
    forii(ptNums.Num())
      pt3d2Vec3f(pts[ptNums[i]],poly.verts[i]);
  }

  pt3d2Vec3f(normal,poly.plane_normal);
  poly.material_index= (int) this;
  return poly;
}

