/*
 * read.S
 *
 * read functions.
 *
 * Copyright (c) Tuomo Valkonen 1997.
 */
 

// Load the sector told in the image descriptor
/////////////////////////////////////////////////
load_1st_sector:
	mov	si,image
	mov	cl,(si+BID_DRIV_OFF)
	mov	ax,(si+BID_ADDR_OFF)
	mov	dx,(si+BID_ADDR_OFF+2)	
	mov	bx,#MAP_OFF
	call	read_linear
	
	ret

// Loads next map file sector
///////////////////////////////
load_next_map:
	pusha
	push	es

	push	ds
	pop	es
	
	seg	es
	mov	ax,[MAP_OFF+508]
	seg	es
	mov	dx,[MAP_OFF+510]
	mov	cl,chos_map_drive
	mov	bx,#MAP_OFF
	call	read_linear
	
	pop	es
	popa
	
	ret

// Load sector ax,dx of map file.
///////////////////////////////////
load_map:
	pusha
	push	es
	
	push	ds
	pop	es
	
	mov	cl,chos_map_drive
	mov	bx,#MAP_OFF
	call	read_linear
	
	pop	es
	popa
	
	ret

// Read sectors at ES:BX
// si=pointer to sectors, cl=drive, secno=max sectors to read
///////////////////////////////////////////////////////////////
load_sects:
	mov	ax,(si)
	mov	dx,(si+2)
	call	read_linear
	jc	load_sects_done
	add	bh,#2
	add	si,#4
	dec	byte ptr secno
	jnz	load_sects
load_sects_done:
	ret

// This is used to load ramdisks,kernels
//////////////////////////////////////////
load_it:
	cmp	di,#MF_SIZEENTS+MAP_OFF	// Load next map sector ?
	jb	load_it_map_still_valid
	call	load_next_map
	//xor	di,di
	mov	di,#MAP_OFF
load_it_map_still_valid:
	mov	cl,drive		// get next sector
	mov	ax,(di)
	mov	dx,(di+2)
	call	read_linear
	jc	load_it_done
	add	di,#4			// next...
	add	bx,#SECTORSIZE
	jnz	load_it
	
	cmp	byte ptr load_high,#0
	je	load_it_low
	call	copy_to_extmem
	jmp	load_it_high_cont
load_it_low:
	mov	bx,es			// Next 64k DMA page
	add	bh,#0x10		// = add bx,#0x1000
	mov	es,bx
load_it_high_cont:	
	xor	bx,bx
	call	print_period
	jmp	load_it
load_it_done:
	cmp	byte ptr load_high,#0
	je	load_it_really_done
	call	copy_to_extmem
load_it_really_done:

	mov	si,#text_done
	call	print

	//mov	dl,drive
	//call	reset_drive

	ret
