/* this is a structure so can add other kill options later */
typedef struct {
	int hilines;	/* nr of lines max article length */
	int lowlines;	/* nr of lines min article length */
	char *path;	/* which hosts in path to kill */
	char *from;	/* look for name in from to kill */
	char *subj;	/* look for words in subj to kill */
	int nrgrps;	/* max nr of grps (to prevent spams) */
	char quote;	/* character to use as quote (for case compare */
} OneKill, *POneKill;

typedef struct {
	OneKill match;
	int delkeep;
	char *group;	/* dynamically allocated */
} Group, *PGroup;
 
typedef struct {
	OneKill master;
	int nrgrps;
	PGroup grps;	/* dynamicly allocated array */
} KillStruct, *PKillStruct;

/* function prototypes */
int get_one_article_kill(PMaster, int, PKillStruct);
PKillStruct parse_killfile(void);
void free_killfile(PKillStruct);

