/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
typedef enum {
    PostStatusOk,
    PostStatusBroken,
    PostStatusOpen,
    PostStatusFailed,
    PostStatusStart
} PostStatus;

typedef enum {
    MailStatusOk,
    MailStatusFailed,
    MailStatusStart,
    MailStatusFork,
    MailStatusOpen
} MailStatus;

struct PostContext;

extern PostStatus post_article(struct PostContext*, char*);
extern PostStatus post_to_agent(struct PostContext*, char*, char*);
extern MailStatus mail_article(struct PostContext*, char*);
