#!/usr/bin/perl
#
# Send-Uucp.pl - create news batches from the outgoing files
# This is a rewritten version from the send-uucp shell script that is
# shipped with INN. Four times faster :-)
# It's a little more verbose when creating the batches.
#
# Author: Edvard Tuinder <ed@ow.org>
#
# Copyright (C) 1994 Edvard Tuinder - The OpenWorld Foundation
# Copyright (C) 1995 Miquel van Smoorenburg - Cistron Internet Services
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version
# 2 of the License, or (at your option) any later version.
#

require '/etc/news/innperlvars';

$CF_FILE = '/etc/news/send-uucp.cf';
$BATCH_LOG = $MOST_LOGS . '/news.admin';
$MAXSIZE = 150000;

$Vers = 1.15;

sub logit {
  print LOG "$PROGNAME[$$]: $_[0]\n";
  #print "$PROGNAME[$$]: $_[0]\n";
}

sub do_end {
  unlink $LOCK;
  ($sec, $min, $hour, $mday, $mon, $year) = localtime(time);
  printf LOG "$PROGNAME[$$]: end %02d/%02d/$year %02d:%02d:%02d\n", $mday, $mon, $hour, $min, $sec;
  exit 0;
}

sub read_cf {
  unless (open (CF, $CF_FILE)) {
    &logit ("can't open `$CF_FILE'");
    return 1;
  }
  local (@TIME, $I);
  while (<CF>) {
    chop; if ((index ($_, "#")) != 0) {
      s/\t\t/\t/g;
      s/\t\t/\t/g;
      s/\t\t/\t/g;
      ($Site, $Compress, $Size, $Time) = split (/\t/);

      $Compress = $COMPRESS if ($Compress eq "");
      $Size = $MAXSIZE if ($Size eq "");

      if ($Want_Site eq $Site) {
        push (@SITELIST, $Site);
        push (@COMPLIST, $Compress);
        push (@SIZELIST, $Size);
	close CF;
	return 0;
      } 
      if ($Want_Site eq "") {
        if ($Time cmp "") {
          @TIME = split (',', $Time);
          $I = 0;
          while ($I <= $#TIME) {
            if ($TIME[$I] == $hour) {
              push (@SITELIST, $Site);
              push (@COMPLIST, $Compress);
              push (@SIZELIST, $Size);
            }
            $I++;
          }
        } else {
          push (@SITELIST, $Site);
          push (@COMPLIST, $Compress);
          push (@SIZELIST, $Size);
        }
      }
    }
  }
  close CF;
  return 0;
}

# Main section
$PROGNAME='send-uucp';
$LOCK = $LOCKS."/LOCK.$PROGNAME";
$LOG = $MOST_LOGS."/$PROGNAME.log";

$ENV{'PATH'}='/usr/lib/news/bin:/bin:/usr/bin:/sbin:/usr/ucb';

$MAXJOBS = 200;
$UUXFLAGS = '- -z -r -gd';
unless (open (LOG, ">> $LOG")) {
  print "$PROGNAME[$$]: Couldn't open log file\n";
  exit 0;
}

($sec, $min, $hour, $mday, $mon, $year) = localtime(time);
printf LOG "$PROGNAME(%.2f)[$$]: begin %02d/%02d/$year %02d:%02d:%02d\n", $Vers, $mday, $mon, $hour, $min, $sec;
unless (chdir ($BATCH)) {
  &logit ("Can't access $BATCH: $!");
  exit 0;
}

if (-e $LOCK) {
   unless (open(LOCK, $LOCK)) {
     &logit ("can't open $LOCK");
     close LOG;
     exit 0;
   }
   $_ = <LOCK>;
   &logit ("locked by process $_");
   close LOCK;
   close LOG;
   exit 0;
}

unless (open(LOCK, "> $LOCK")) {
  &logit ("can't create LOCK FILE");
  close LOG;
  exit 0;
}
print LOCK "$$";
close LOCK;

if ($#ARGV != -1) {
  @LIST = @ARGV;
  $I = 0;
  while ($I <= $#LIST) {
    $Want_Site = $LIST[$I++];
    $ret = &read_cf;
    if ($ret == 1 || $#SITELIST == -1) {
      print "Site `$Want_Site' not found. Ignored\n";
    }
  }
} else {
  $ret = &read_cf;
  if ($#SITELIST == -1 || $ret == 1) {
    &logit ("nothing to do");
    &do_end;
  }
}

# Perform the real work
&run_site while ($Site = pop(@SITELIST));
&do_end;

#end of main section
sub run_site {
  &logit ("checking site $Site");
  rename ($Site, "$Site.work");
  system ("$NEWSBIN/ctlinnd -s -t30 flush $Site");
  if (-z "$Site.work") {
    &logit ("no articles for $Site");
    $Size = pop @SIZELIST;	# still need to remove them @%^&# entries !
    $Compress = pop @COMPLIST;
    unlink ("$Site.work");
  } else {
    $Size = pop @SIZELIST;
    $Compress = pop @COMPLIST;
    if ($Compress cmp "none") {
      system ("batcher -v -b $Size -p\"(echo '#! cunbatch' ; exec $Compress ) | uux $UUXFLAGS %s!rnews\" $Site $Site.work >> $BATCH_LOG");
    } else {
      system ("batcher -v -b $Size -p\"uux $UUXFLAGS %s!rnews\" $Site $Site.work >> $BATCH_LOG");
    }
    unlink ("$Site.work");
    &logit ("batched for $Site");
  }
}
