/* A lexical scanner for NetHack generated by flex */

/* scanner skeleton version:
 * flexhack.skel 3.1.3 (from .../flex/RCS/flex.skel,v 2.16 90/08/03 14:09:36)
 */
#define FLEXHACK_SCANNER

/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */
#define ECHO (void)fwrite((genericptr_t)yytext, yyleng, 1, yyout)

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
	if ((result = fread((genericptr_t)buf, 1, max_size, yyin)) <= 0 && \
	    !feof(yyin))  YY_FATAL_ERROR( "fread(yyin) in flex scanner failed" );
#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */
#define YY_FATAL_ERROR(msg) \
	do { \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
	} while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
	do { \
		yy_init_buffer( yy_current_buffer, yyin ); \
		yy_load_buffer_state(); \
	} while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int NDECL(yylex)

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR char
#define INITIAL 0
/*	SCCS Id: @(#)lev_lex.c	3.1	93/06/17	*/
/*	Copyright (c) 1989 by Jean-Christophe Collet */
/* NetHack may be freely redistributed.  See license for details. */

#define LEV_LEX_C

#include "hack.h"
#include "lev_comp.h"
#include "sp_lev.h"

/* Most of these don't exist in flex, yywrap is macro and
 * yyunput is properly declared in flex.skel.
 */
#if !defined(FLEX_SCANNER) && !defined(FLEXHACK_SCANNER)
int FDECL(yyback, (int *, int));
int NDECL(yylook);
int NDECL(yyinput);
int NDECL(yywrap);
int NDECL(yylex);
	/* Traditional lexes let yyunput() and yyoutput() default to int;
	 * newer ones may declare them as void since they don't return
	 * values.  For even more fun, the lex supplied as part of the
	 * newer unbundled compiler for SunOS 4.x adds the void declarations
	 * (under __STDC__ or _cplusplus ifdefs -- otherwise they remain
	 * int) while the bundled lex and the one with the older unbundled
	 * compiler do not.  To detect this, we need help from outside --
	 * sys/unix/Makefile.utl.
	 */
# if defined(NeXT) || defined(SVR4)
#  define VOIDYYPUT
# endif
# if !defined(VOIDYYPUT)
#  if defined(POSIX_TYPES) && !defined(BOS) && !defined(HISX) && !defined(_M_UNIX)
#   define VOIDYYPUT
#  endif
# endif
# if !defined(VOIDYYPUT) && defined(WEIRD_LEX)
#  if defined(SUNOS4) && defined(__STDC__) && (WEIRD_LEX > 1) 
#   define VOIDYYPUT
#  endif
# endif
# ifdef VOIDYYPUT
void FDECL(yyunput, (int));
void FDECL(yyoutput, (int));
# else
int FDECL(yyunput, (int));
int FDECL(yyoutput, (int));
# endif
#endif	/* !FLEX_SCANNER && !FLEXHACK_SCANNER */

void FDECL(init_yyin, (FILE *));
void FDECL(init_yyout, (FILE *));

#ifdef MICRO
#undef exit
extern void FDECL(exit, (int));
#endif

/*
 * This doesn't always get put in lev_comp.h
 * (esp. when using older versions of bison).
 */
extern YYSTYPE yylval;

int line_number = 1, colon_line_number = 1;

/*
 * This is *** UGLY *** but I can't think a better way to do it;
 * I really need a huge buffer to scan maps...
 * (This should probably be `#ifndef FLEX_SCANNER' since it's lex-specific.)
 */
#ifdef YYLMAX
#undef YYLMAX
#endif
#define YYLMAX	2048

/*
 *	This is a hack required by Michael Hamel to get things
 *	working on the Mac.
 */
#if defined(applec) && !defined(FLEX_SCANNER) && !defined(FLEXHACK_SCANNER)
#undef input
#undef unput
#define unput(c) { yytchar = (c); if (yytchar == 10) yylineno--; *yysptr++ = yytchar; }
# ifndef YYNEWLINE
# define YYNEWLINE 10
# endif

char
input()		/* Under MPW \n is chr(13)! Compensate for this. */
{
	if (yysptr > yysbuf) return(*--yysptr);
	else {
		yytchar = getc(yyin);
		if (yytchar == '\n') {
		    yylineno++;
		    return(YYNEWLINE);
		}
		if (yytchar == EOF) return(0);
		else		    return(yytchar);
	}
}
#endif	/* applec && !FLEX_SCANNER && !FLEXHACK_SCANNER */

#define MAPC 1

/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
	yytext = yy_bp; \
	yytext -= yy_more_len; \
	yyleng = yy_cp - yytext; \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
	do { \
		/* undo effects of setting up yytext */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
	} while ( 0 )

#define unput(c) yyunput((int)c, yytext)


struct yy_buffer_state {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;		/* input buffer */
    YY_CHAR *yy_buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters */
    int yy_buf_size;

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
};

static YY_BUFFER_STATE yy_current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern YY_CHAR *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

YY_CHAR *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 106
typedef int yy_state_type;
static const short int yy_accept[573] =
    {   0,
        0,    0,    0,    0,  106,  104,  102,  101,  104,  104,
      104,   99,    4,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,    2,
      102,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  102,    0,  100,    0,   99,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   84,    0,
        0,    3,    0,    2,  102,    0,    0,    0,    0,    0,
        0,    0,    2,    0,  103,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,   71,    0,
        0,   66,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   64,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   16,
        0,    0,    0,    0,    0,   39,    0,    0,    0,    6,
        0,    0,   41,    0,    0,    0,   32,    0,    0,    0,
       35,   31,    0,    0,    0,   15,    0,    0,    0,    0,
        0,    0,    0,    0,   90,    0,    0,    0,    0,   85,
       88,   50,    0,    0,    0,    0,    0,    0,   59,    0,

        0,    0,    0,    0,   91,    0,    0,    0,    0,    0,
       54,    0,    0,    0,   44,    0,    0,    0,    0,    0,
        0,    0,    0,   87,    0,    0,    0,   52,   12,    0,
        0,   24,    0,    0,    0,    0,    0,   10,    0,    0,
        0,    0,    8,    0,    0,    0,    7,    0,    0,    0,
        0,    0,    0,   26,    0,    0,    0,   58,   83,    0,
       77,    0,    0,    0,    0,   73,    0,    0,    0,   86,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   49,    0,    0,    0,   57,    0,
       63,    0,    0,    0,   51,    0,    0,   67,    0,    0,

       29,   42,    0,    0,    0,    0,    0,    0,   25,    0,
        0,    0,    0,    0,   13,   27,    0,   20,    0,    0,
        0,   76,    0,   65,   48,   61,   45,   94,    0,   68,
        0,    0,    0,    0,    0,   46,    0,    0,    0,    0,
        0,    0,   47,   97,    0,   55,    0,   53,    0,    0,
       82,    0,    0,    1,    0,    0,    0,    0,    0,    0,
        0,    5,   14,    0,    0,    0,   36,    0,   19,   92,
       89,    0,    0,    0,   75,    0,    0,    0,    0,   56,
       72,   70,    0,    0,   81,    0,    0,    0,   38,    0,
        0,   30,   11,    9,   18,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,   80,    0,
       74,    0,   93,   69,    0,   40,    0,    0,    0,    0,
        0,    0,    0,   60,    0,   96,   43,   78,   79,    0,
        0,   17,    0,    0,    0,    0,    0,    0,    0,   62,
       95,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       33,   34,    0,    0,    0,    0,    0,   98,    0,    0,
        0,   23,    0,    0,    0,   21,    0,    0,   22,   28,
       37,    0
    } ;

static const YY_CHAR yy_ec[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    5,    6,    1,    1,    1,    7,    1,
        1,    1,    8,    1,    9,   10,    1,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   12,    1,    1,
        1,    1,    1,    1,   13,   14,   15,   16,   17,   18,
       19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
        1,   29,   30,   31,   32,   33,   34,    1,   35,   36,
        1,   10,    1,    1,   37,    1,   38,   39,   40,   41,

       42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
       52,   53,    1,   54,   55,   56,   57,   58,   59,    1,
        1,    1,   10,   10,   10,    1,    1
    } ;

static const YY_CHAR yy_meta[60] =
    {   0,
        1,    2,    3,    2,    1,    2,    1,    2,    2,    2,
        1,    1,    2,    2,    2,    1,    1,    1,    1,    2,
        2,    1,    2,    2,    1,    1,    1,    2,    1,    2,
        1,    1,    1,    2,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1
    } ;

static const short int yy_base[577] =
    {   0,
        0,   54,   77,   57,  674,  675,   60,  675,  668,    0,
      661,  660,  675,  646,  640,   41,   38,  642,   42,   57,
      641,   58,   76,   75,  652,  638,   82,   83,   79,  651,
       57,   68,   79,   20,   72,   32,   75,   88,   81,   87,
       92,   93,  100,   99,   89,   96,  621,  659,  135,  675,
      151,  154,  156,  158,  161,  166,  635,  163,  168,  152,
      156,  161,  191,  171,  655,  675,  652,  647,  626,  643,
      642,  625,  626,  639,  632,  637,  617,  621,  623,  625,
      629,  611,  607,  612,  615,  615,  166,  617,  169,  612,
      618,  609,  609,  621,  619,  608,  618,  606,  157,  580,

      590,  585,  570,  573,  570,  572,  584,  569,  566,  560,
      563,  562,  572,  566,  565,  153,  558,  553,  165,  555,
      570,  166,  555,  557,  550,  179,  559,  563,  566,  565,
      551,  557,  549,  170,  542,  545,  540,  188,  675,  541,
      592,  675,  198,  675,  236,  239,  241,  167,   57,  232,
      233,  234,  675,    0,  675,  581,  567,  566,  562,  561,
      555,  559,  568,  560,  560,  568,  552,  566,  564,  563,
      549,  548,  560,  563,  538,  557,  549,  541,  555,  549,
      544,  545,  546,  537,  548,  536,  539,  518,  523,  518,
      511,  503,  501,  508,  504,  498,  501,  497,  496,  499,

      493,  492,  493,  491,  496,  501,  502,  486,  675,  485,
      486,  675,  491,  496,  485,  497,  487,  479,  477,  483,
      479,  480,  487,  472,  485,  484,  474,  484,  483,  481,
      476,  480,  465,  472,  461,  675,  474,  458,  468,  467,
      456,  508,  239,  485,  240,  480,  493,  492,  485,  675,
      491,  491,  473,  471,  484,  675,  463,  482,  474,  463,
      483,  464,  675,  466,  238,  478,  675,  479,  464,  463,
      675,  675,  460,  461,  459,  675,  465,  434,  430,  441,
      440,  426,  428,  437,  675,  436,  422,  434,  433,  675,
      675,  675,  436,  431,  430,  462,  427,  423,  675,  426,

      425,  428,  414,  417,  675,  407,  408,  415,  408,  421,
      675,  413,  408,  416,  675,  413,  412,  401,  396,  395,
      394,  398,  403,  675,  393,  397,  389,  675,  675,  431,
      250,  675,  423,  425,  425,  411,  406,  675,  425,  406,
      411,  406,  675,  421,  414,  415,  675,  410,  417,  398,
      404,  402,  400,  675,  398,  397,  405,  675,  675,  369,
      675,  379,  370,  368,  364,  675,  376,  375,  357,  675,
      373,  178,  364,  363,  367,  369,  353,  353,  365,  364,
      367,  360,  349,  349,  675,  359,  344,  356,  675,  348,
      675,  340,  341,  353,  675,  339,  344,  675,  364,  256,

      675,  675,  364,  369,  368,  367,  358,  373,  675,  361,
      367,  354,  363,  351,  675,  675,  343,  675,  354,  349,
      342,  675,  335,  675,  675,  675,  675,  675,  333,  675,
      332,  327,  320,  329,  324,  675,  312,  312,  327,  312,
      316,  313,  675,  675,  310,  675,  305,  675,  311,  314,
      675,  317,  316,  675,  328,  340,  329,  328,  318,  324,
      328,  675,  675,  331,  319,  253,  675,  317,  675,  675,
      675,  304,  302,  293,  675,  292,  289,  300,  285,  675,
      675,  675,  288,  290,  675,  294,  296,  295,  675,  316,
      315,  675,  675,  675,  675,  320,  298,  304,  303,  315,

      304,  290,  270,  280,  270,  272,  280,  267,  675,  266,
      675,  274,  675,  675,  301,  675,  303,  303,  286,  288,
      291,  299,  282,  675,  254,  675,  675,  675,  675,  253,
      252,  675,  283,  282,  276,  274,  286,  287,  284,  675,
      675,  258,  282,  274,  276,  265,  280,  277,  274,  251,
      675,  675,  263,  260,  245,  245,  249,  675,  235,  232,
      230,  675,  228,  207,  180,  675,  124,  102,  675,  675,
      675,  675,  281,  284,  286,  288
    } ;

static const short int yy_def[577] =
    {   0,
      572,    1,    1,    3,  572,  572,  572,  572,  573,  574,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  575,  572,  572,
      576,  576,  576,  576,  576,  576,  572,  576,  576,   56,
       56,   59,  575,  572,  573,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      575,  572,  572,  572,  576,  576,  576,   59,  572,   59,
       59,   59,  572,   63,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,   59,  572,   59,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
       59,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,   59,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,    0,  572,  572,  572,  572
    } ;

static const short int yy_nxt[735] =
    {   0,
        6,    7,    8,    7,    9,    6,   10,   11,   11,    6,
       12,   13,   14,   15,   16,   17,   18,   19,   20,    6,
       21,    6,    6,   22,   23,   24,   25,   26,   27,   28,
       29,    6,    6,   30,    6,    6,    6,   31,   32,   33,
       34,   35,   36,    6,   37,    6,    6,    6,   38,   39,
       40,   41,   42,   43,   44,   45,   46,    6,   47,   48,
       71,   64,   63,   64,   73,   76,   74,   72,   77,  114,
       81,  110,  244,   78,   82,  162,  111,  115,   49,   50,
       51,   49,   52,   79,   53,   53,   52,   86,   83,   54,
       55,   56,   84,   57,   90,   96,   52,   58,   91,   52,

       59,   87,   85,   93,   60,   99,   61,   97,   92,  112,
       62,  100,  116,   94,   95,  101,  102,  122,  123,  103,
      106,  104,  113,  107,  105,  118,  117,  108,  125,  119,
      127,  571,  124,  120,  129,  109,  133,  131,  126,  121,
      136,  130,  137,  134,  128,  132,  138,  143,  139,  570,
      135,   84,   64,  144,  145,  572,  144,  572,  144,  572,
      144,   85,  572,  144,  572,  144,   68,  572,  144,  572,
      144,  146,   64,  152,   64,  146,  151,  572,   89,  243,
      150,  147,  572,  572,   82,  148,   94,   95,   80,   70,
      174,  175,   72,  153,  154,  177,  154,  178,  154,  154,

      154,  206,  188,  154,  154,  154,  207,  210,  214,  569,
      154,  154,  189,  154,  154,  215,  220,  216,  154,  221,
      154,  233,  211,  234,  154,  242,  431,  238,  222,  223,
      239,  432,  224,  170,  225,  568,  240,   64,  144,  145,
      572,  144,  572,  144,  146,  146,  146,  168,  572,  572,
      572,  146,  146,  348,  567,  572,  572,  245,  182,  566,
      565,  564,  146,  331,  248,  349,  572,  498,  146,  563,
      400,  156,  572,  421,  562,  561,  560,  499,  559,  500,
      501,   65,   65,   65,   67,   67,  141,  141,  141,  146,
      146,  558,  557,  556,  555,  554,  553,  552,  551,  550,

      549,  548,  547,  546,  545,  544,  543,  542,  541,  540,
      539,  538,  537,  536,  535,  534,  533,  532,  531,  530,
      529,  528,  527,  526,  525,  524,  523,  522,  521,  520,
      519,  518,  517,  516,  515,  514,  513,  512,  511,  510,
      509,  508,  507,  506,  505,  504,  503,  502,  497,  496,
      495,  494,  493,  492,  491,  490,  489,  488,  487,  486,
      485,  484,  483,  482,  481,  480,  479,  478,  477,  476,
      475,  474,  473,  472,  471,  470,  469,  468,  467,  466,
      465,  464,  463,  462,  461,  460,  459,  458,  457,  456,
      455,  454,  453,  452,  451,  450,  449,  448,  447,  446,

      445,  444,  443,  442,  441,  440,  439,  438,  437,  436,
      435,  434,  433,  430,  429,  428,  427,  426,  425,  424,
      423,  422,  421,  420,  419,  418,  417,  416,  415,  414,
      413,  412,  411,  410,  409,  408,  407,  406,  405,  404,
      403,  402,  401,  399,  398,  397,  396,  395,  394,  393,
      392,  391,  390,  389,  388,  387,  386,  385,  384,  383,
      382,  381,  380,  379,  378,  377,  376,  375,  374,  373,
      372,  371,  370,  369,  368,  367,  366,  365,  364,  363,
      362,  361,  360,  359,  358,  357,  356,  355,  354,  353,
      352,  351,  350,  347,  346,  345,  344,  343,  342,  341,

      340,  339,  338,  337,  336,  335,  334,  333,  332,  330,
      329,  328,  327,  326,  325,  324,  323,  322,  321,  320,
      319,  318,  317,  316,  315,  314,  313,  312,  311,  310,
      309,  308,  307,  306,  305,  304,  303,  302,  301,  300,
      299,  298,  297,  296,  295,  294,  293,  292,  291,  290,
      289,  288,  287,  286,  285,  284,  283,  282,  281,  280,
      279,  278,  277,  276,  275,  274,  273,  272,  271,  270,
      269,  268,  267,  266,  265,  264,  263,  262,  261,  260,
      259,  258,  257,  256,  255,  254,  253,  252,  251,  250,
      249,  248,  247,  246,  142,  241,  237,  236,  235,  232,

      231,  230,  229,  228,  227,  226,  219,  218,  217,  213,
      212,  209,  208,  205,  204,  203,  202,  201,  200,  199,
      198,  197,  196,  195,  194,  193,  192,  191,  190,  187,
      186,  185,  184,  183,  182,  181,  180,  179,  176,  173,
      172,  171,  170,  169,  168,  167,  166,  165,  164,  163,
      162,  161,  160,  159,  158,  157,  156,   68,  155,   66,
      149,  142,  140,   98,   89,   88,   80,   75,   70,   69,
       68,   68,   66,  572,    5,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572
    } ;

static const short int yy_chk[735] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
       16,    7,    4,    7,   17,   19,   17,   16,   19,   36,
       22,   34,  149,   20,   22,  149,   34,   36,    2,    3,
        3,    4,    3,   20,    3,    3,    3,   24,   23,    3,
        3,    3,   23,    3,   27,   29,    3,    3,   27,    3,

        3,   24,   23,   28,    3,   31,    3,   29,   27,   35,
        3,   31,   37,   28,   28,   31,   32,   39,   39,   32,
       33,   32,   35,   33,   32,   38,   37,   33,   40,   38,
       41,  568,   39,   38,   42,   33,   44,   43,   40,   38,
       45,   42,   45,   44,   41,   43,   46,   49,   46,  567,
       44,   49,   51,   51,   51,   52,   52,   53,   53,   54,
       54,   49,   55,   55,   58,   58,   53,   56,   56,   59,
       59,   60,   64,   62,   64,   61,   61,   62,   60,  148,
       59,   54,   61,  148,   59,   56,   61,   61,   58,   55,
       87,   87,   56,   63,   63,   89,   63,   89,   63,   63,

       63,  116,   99,   63,   63,   63,  116,  119,  122,  565,
       63,   63,   99,   63,   63,  122,  126,  122,   63,  126,
       63,  134,  119,  134,   63,  143,  372,  138,  126,  126,
      138,  372,  126,  143,  126,  564,  138,  145,  145,  145,
      146,  146,  147,  147,  150,  151,  152,  150,  150,  151,
      152,  243,  245,  265,  563,  243,  245,  152,  151,  561,
      560,  559,  331,  245,  243,  265,  331,  466,  400,  557,
      331,  147,  400,  400,  556,  555,  554,  466,  553,  466,
      466,  573,  573,  573,  574,  574,  575,  575,  575,  576,
      576,  550,  549,  548,  547,  546,  545,  544,  543,  542,

      539,  538,  537,  536,  535,  534,  533,  531,  530,  525,
      523,  522,  521,  520,  519,  518,  517,  515,  512,  510,
      508,  507,  506,  505,  504,  503,  502,  501,  500,  499,
      498,  497,  496,  491,  490,  488,  487,  486,  484,  483,
      479,  478,  477,  476,  474,  473,  472,  468,  465,  464,
      461,  460,  459,  458,  457,  456,  455,  453,  452,  450,
      449,  447,  445,  442,  441,  440,  439,  438,  437,  435,
      434,  433,  432,  431,  429,  423,  421,  420,  419,  417,
      414,  413,  412,  411,  410,  408,  407,  406,  405,  404,
      403,  399,  397,  396,  394,  393,  392,  390,  388,  387,

      386,  384,  383,  382,  381,  380,  379,  378,  377,  376,
      375,  374,  373,  371,  369,  368,  367,  365,  364,  363,
      362,  360,  357,  356,  355,  353,  352,  351,  350,  349,
      348,  346,  345,  344,  342,  341,  340,  339,  337,  336,
      335,  334,  333,  330,  327,  326,  325,  323,  322,  321,
      320,  319,  318,  317,  316,  314,  313,  312,  310,  309,
      308,  307,  306,  304,  303,  302,  301,  300,  298,  297,
      296,  295,  294,  293,  289,  288,  287,  286,  284,  283,
      282,  281,  280,  279,  278,  277,  275,  274,  273,  270,
      269,  268,  266,  264,  262,  261,  260,  259,  258,  257,

      255,  254,  253,  252,  251,  249,  248,  247,  246,  244,
      242,  241,  240,  239,  238,  237,  235,  234,  233,  232,
      231,  230,  229,  228,  227,  226,  225,  224,  223,  222,
      221,  220,  219,  218,  217,  216,  215,  214,  213,  211,
      210,  208,  207,  206,  205,  204,  203,  202,  201,  200,
      199,  198,  197,  196,  195,  194,  193,  192,  191,  190,
      189,  188,  187,  186,  185,  184,  183,  182,  181,  180,
      179,  178,  177,  176,  175,  174,  173,  172,  171,  170,
      169,  168,  167,  166,  165,  164,  163,  162,  161,  160,
      159,  158,  157,  156,  141,  140,  137,  136,  135,  133,

      132,  131,  130,  129,  128,  127,  125,  124,  123,  121,
      120,  118,  117,  115,  114,  113,  112,  111,  110,  109,
      108,  107,  106,  105,  104,  103,  102,  101,  100,   98,
       97,   96,   95,   94,   93,   92,   91,   90,   88,   86,
       85,   84,   83,   82,   81,   80,   79,   78,   77,   76,
       75,   74,   73,   72,   71,   70,   69,   68,   67,   65,
       57,   48,   47,   30,   26,   25,   21,   18,   15,   14,
       12,   11,    9,    5,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,

      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572
    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
static int yy_more_flag = 0;
static int yy_doing_yy_more = 0;
static int yy_more_len = 0;
#define yymore() { yy_more_flag = 1; }
#define YY_MORE_ADJ (yy_doing_yy_more ? yy_more_len : 0)

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type NDECL(yy_get_previous_state);
static yy_state_type FDECL(yy_try_NUL_trans, (yy_state_type));
static int NDECL(yy_get_next_buffer);
#if 0		/* not needed for NetHack */
static int NDECL(yyinput);
static void FDECL(yyunput, (int,YY_CHAR *));
#endif
void FDECL(yyrestart, (FILE *));
void FDECL(yy_switch_to_buffer, (YY_BUFFER_STATE));
void NDECL(yy_load_buffer_state);
YY_BUFFER_STATE FDECL(yy_create_buffer, (FILE *,int));
void FDECL(yy_delete_buffer, (YY_BUFFER_STATE));
void FDECL(yy_init_buffer, (YY_BUFFER_STATE,FILE *));

#define yy_new_buffer yy_create_buffer

YY_DECL
{
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



    if ( yy_init )
	{
	YY_USER_INIT;

	if ( ! yy_start )
	    yy_start = 1;	/* first start state */

	if ( ! yyin )
	    yyin = stdin;

	if ( ! yyout )
	    yyout = stdout;

	if ( yy_current_buffer )
	    yy_init_buffer( yy_current_buffer, yyin );
	else
	    yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_load_buffer_state();

	yy_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	yy_more_len = 0;
	yy_doing_yy_more = yy_more_flag;
	if ( yy_doing_yy_more )
	    {
	    yy_more_len = yyleng;
	    yy_more_flag = 0;
	    }
	yy_cp = yy_c_buf_p;

	/* support of yytext */
	*yy_cp = yy_hold_char;

	/* yy_bp points to the position in yy_ch_buf of the start of the
	 * current run.
	 */
	yy_bp = yy_cp;

	yy_current_state = yy_start;
	if ( yy_bp[-1] == '\n' )
	    ++yy_current_state;
yy_match:
	do
	    {
	    register YY_CHAR yy_c = yy_ec[*yy_cp];
	    if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = yy_def[yy_current_state];
		if ( yy_current_state >= 573 )
		    yy_c = yy_meta[yy_c];
		}
	    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	    ++yy_cp;
	    }
	while ( yy_current_state != 572 );
	yy_cp = yy_last_accepting_cpos;
	yy_current_state = yy_last_accepting_state;

yy_find_action:
	yy_act = yy_accept[yy_current_state];

	YY_DO_BEFORE_ACTION;
	YY_USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( yy_act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *yy_cp = yy_hold_char;
	    yy_cp = yy_last_accepting_cpos;
	    yy_current_state = yy_last_accepting_state;
	    goto yy_find_action;

case 1:
{
#ifdef FLEX23_BUG
		  /*
		   * There is a bug in Flex 2.3 patch level < 6
		   * (absent in previous versions)
		   * that results in the following behaviour :
		   * Once you enter an yymore(), you never exit from it.
		   * This should do the trick!
		   */
		  extern int yy_more_len;

		  yy_more_len = 0;
#endif	/* FLEX23_BUG */
		  BEGIN(INITIAL);
		  yylval.map = (char *) alloc(yyleng-5);
		  strncpy(yylval.map, yytext,yyleng-6);
		  yylval.map[yyleng-6] = 0;
		  return MAP_ID;
		}
	YY_BREAK
case 2:
{ line_number++; yymore(); }
	YY_BREAK
case 3:
{ line_number++; }
	YY_BREAK
case 4:
{ colon_line_number = line_number; return ':'; }
	YY_BREAK
case 5:
return MESSAGE_ID;
	YY_BREAK
case 6:
return MAZE_ID;
	YY_BREAK
case 7:
return NOMAP_ID;
	YY_BREAK
case 8:
return LEVEL_ID;
	YY_BREAK
case 9:
return LEV_INIT_ID;
	YY_BREAK
case 10:
return FLAGS_ID;
	YY_BREAK
case 11:
return GEOMETRY_ID;
	YY_BREAK
case 12:
{ BEGIN(MAPC); line_number++; }
	YY_BREAK
case 13:
return OBJECT_ID;
	YY_BREAK
case 14:
return MONSTER_ID;
	YY_BREAK
case 15:
return TRAP_ID;
	YY_BREAK
case 16:
return DOOR_ID;
	YY_BREAK
case 17:
return DRAWBRIDGE_ID;
	YY_BREAK
case 18:
return MAZEWALK_ID;
	YY_BREAK
case 19:
return WALLIFY_ID;
	YY_BREAK
case 20:
return REGION_ID;
	YY_BREAK
case 21:
return RANDOM_OBJECTS_ID;
	YY_BREAK
case 22:
return RANDOM_MONSTERS_ID;
	YY_BREAK
case 23:
return RANDOM_PLACES_ID;
	YY_BREAK
case 24:
return ALTAR_ID;
	YY_BREAK
case 25:
return LADDER_ID;
	YY_BREAK
case 26:
return STAIR_ID;
	YY_BREAK
case 27:
return PORTAL_ID;
	YY_BREAK
case 28:
return TELEPRT_ID;
	YY_BREAK
case 29:
return BRANCH_ID;
	YY_BREAK
case 30:
return FOUNTAIN_ID;
	YY_BREAK
case 31:
return SINK_ID;
	YY_BREAK
case 32:
return POOL_ID;
	YY_BREAK
case 33:
return NON_DIGGABLE_ID;
	YY_BREAK
case 34:
return NON_PASSWALL_ID;
	YY_BREAK
case 35:
return ROOM_ID;
	YY_BREAK
case 36:
return SUBROOM_ID;
	YY_BREAK
case 37:
return RAND_CORRIDOR_ID;
	YY_BREAK
case 38:
return CORRIDOR_ID;
	YY_BREAK
case 39:
return GOLD_ID;
	YY_BREAK
case 40:
return ENGRAVING_ID;
	YY_BREAK
case 41:
return NAME_ID;
	YY_BREAK
case 42:
return CHANCE_ID;
	YY_BREAK
case 43:
return LEV;
	YY_BREAK
case 44:
{ yylval.i=D_ISOPEN; return DOOR_STATE; }
	YY_BREAK
case 45:
{ yylval.i=D_CLOSED; return DOOR_STATE; }
	YY_BREAK
case 46:
{ yylval.i=D_LOCKED; return DOOR_STATE; }
	YY_BREAK
case 47:
{ yylval.i=D_NODOOR; return DOOR_STATE; }
	YY_BREAK
case 48:
{ yylval.i=D_BROKEN; return DOOR_STATE; }
	YY_BREAK
case 49:
{ yylval.i=W_NORTH; return DIRECTION; }
	YY_BREAK
case 50:
{ yylval.i=W_EAST; return DIRECTION; }
	YY_BREAK
case 51:
{ yylval.i=W_SOUTH; return DIRECTION; }
	YY_BREAK
case 52:
{ yylval.i=W_WEST; return DIRECTION; }
	YY_BREAK
case 53:
{ yylval.i = -1; return RANDOM_TYPE; }
	YY_BREAK
case 54:
{ yylval.i = -2; return NONE; }
	YY_BREAK
case 55:
return O_REGISTER;
	YY_BREAK
case 56:
return M_REGISTER;
	YY_BREAK
case 57:
return P_REGISTER;
	YY_BREAK
case 58:
return A_REGISTER;
	YY_BREAK
case 59:
{ yylval.i=1; return LEFT_OR_RIGHT; }
	YY_BREAK
case 60:
{ yylval.i=2; return LEFT_OR_RIGHT; }
	YY_BREAK
case 61:
{ yylval.i=3; return CENTER; }
	YY_BREAK
case 62:
{ yylval.i=4; return LEFT_OR_RIGHT; }
	YY_BREAK
case 63:
{ yylval.i=5; return LEFT_OR_RIGHT; }
	YY_BREAK
case 64:
{ yylval.i=1; return TOP_OR_BOT; }
	YY_BREAK
case 65:
{ yylval.i=5; return TOP_OR_BOT; }
	YY_BREAK
case 66:
{ yylval.i=1; return LIGHT_STATE; }
	YY_BREAK
case 67:
{ yylval.i=0; return LIGHT_STATE; }
	YY_BREAK
case 68:
{ yylval.i=0; return FILLING; }
	YY_BREAK
case 69:
{ yylval.i=1; return FILLING; }
	YY_BREAK
case 70:
{ yylval.i= AM_NONE; return ALIGNMENT; }
	YY_BREAK
case 71:
{ yylval.i= AM_LAWFUL; return ALIGNMENT; }
	YY_BREAK
case 72:
{ yylval.i= AM_NEUTRAL; return ALIGNMENT; }
	YY_BREAK
case 73:
{ yylval.i= AM_CHAOTIC; return ALIGNMENT; }
	YY_BREAK
case 74:
{ yylval.i=1; return MON_ATTITUDE; }
	YY_BREAK
case 75:
{ yylval.i=0; return MON_ATTITUDE; }
	YY_BREAK
case 76:
{ yylval.i=1; return MON_ALERTNESS; }
	YY_BREAK
case 77:
{ yylval.i=0; return MON_ALERTNESS; }
	YY_BREAK
case 78:
{ yylval.i= M_AP_FURNITURE; return MON_APPEARANCE; }
	YY_BREAK
case 79:
{ yylval.i= M_AP_MONSTER;   return MON_APPEARANCE; }
	YY_BREAK
case 80:
{ yylval.i= M_AP_OBJECT;    return MON_APPEARANCE; }
	YY_BREAK
case 81:
{ yylval.i=2; return ALTAR_TYPE; }
	YY_BREAK
case 82:
{ yylval.i=1; return ALTAR_TYPE; }
	YY_BREAK
case 83:
{ yylval.i=0; return ALTAR_TYPE; }
	YY_BREAK
case 84:
{ yylval.i=1; return UP_OR_DOWN; }
	YY_BREAK
case 85:
{ yylval.i=0; return UP_OR_DOWN; }
	YY_BREAK
case 86:
{ yylval.i=0; return BOOLEAN; }
	YY_BREAK
case 87:
{ yylval.i=1; return BOOLEAN; }
	YY_BREAK
case 88:
{ yylval.i=DUST; return ENGRAVING_TYPE; }
	YY_BREAK
case 89:
{ yylval.i=ENGRAVE; return ENGRAVING_TYPE; }
	YY_BREAK
case 90:
{ yylval.i=BURN; return ENGRAVING_TYPE; }
	YY_BREAK
case 91:
{ yylval.i=MARK; return ENGRAVING_TYPE; }
	YY_BREAK
case 92:
{ yylval.i=1; return CURSE_TYPE; }
	YY_BREAK
case 93:
{ yylval.i=2; return CURSE_TYPE; }
	YY_BREAK
case 94:
{ yylval.i=3; return CURSE_TYPE; }
	YY_BREAK
case 95:
{ yylval.i=NOTELEPORT; return FLAG_TYPE; }
	YY_BREAK
case 96:
{ yylval.i=HARDFLOOR; return FLAG_TYPE; }
	YY_BREAK
case 97:
{ yylval.i=NOMMAP; return FLAG_TYPE; }
	YY_BREAK
case 98:
{ yylval.i=SHORTSIGHTED; return FLAG_TYPE; }
	YY_BREAK
case 99:
{ yylval.i=atoi(yytext); return INTEGER; }
	YY_BREAK
case 100:
{ yytext[yyleng-1] = 0; /* Discard the trailing \" */
		  yylval.map = (char *) alloc(strlen(yytext+1)+1);
		  strcpy(yylval.map, yytext+1); /* Discard the first \" */
		  return STRING; }
	YY_BREAK
case 101:
{ line_number++; }
	YY_BREAK
case 102:
;
	YY_BREAK
case 103:
{ yylval.i = yytext[1]; return CHAR; }
	YY_BREAK
case 104:
{ return yytext[0]; }
	YY_BREAK
case 105:
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(MAPC):
    yyterminate();

	    case YY_END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int yy_amount_of_matched_text = yy_cp - yytext - 1;

		/* undo the effects of YY_DO_BEFORE_ACTION */
		*yy_cp = yy_hold_char;

		/* note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in yyinput().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
		    /* this was really a NUL */
		    {
		    yy_state_type yy_next_state;

		    yy_c_buf_p = yytext + yy_amount_of_matched_text;

		    yy_current_state = yy_get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * yy_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    yy_next_state = yy_try_NUL_trans( yy_current_state );

		    yy_bp = yytext + YY_MORE_ADJ;

		    if ( yy_next_state )
			{
			/* consume the NUL */
			yy_cp = ++yy_c_buf_p;
			yy_current_state = yy_next_state;
			goto yy_match;
			}

		    else
			{
			    yy_cp = yy_last_accepting_cpos;
			    yy_current_state = yy_last_accepting_state;
			goto yy_find_action;
			}
		    }

		else switch ( yy_get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			yy_did_buffer_switch_on_eof = 0;

			if ( yywrap() )
			    {
			    /* note: because we've taken care in
			     * yy_get_next_buffer() to have set up yytext,
			     * we can now set up yy_c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * YY_NULL, it'll still work - another YY_NULL
			     * will get returned.
			     */
			    yy_c_buf_p = yytext + YY_MORE_ADJ;

			    yy_act = YY_STATE_EOF((yy_start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! yy_did_buffer_switch_on_eof )
				YY_NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			yy_c_buf_p = yytext + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_match;

		    case EOB_ACT_LAST_MATCH:
			yy_c_buf_p =
			    &yy_current_buffer->yy_ch_buf[yy_n_chars];

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", yy_act );
#endif
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
}


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH -
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
{
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
	YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - yytext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	yy_n_chars = 0;

    else
	{
	int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
		  yy_n_chars, num_to_read );
	}

    if ( yy_n_chars == 0 )
	{
	if ( number_to_move - YY_MORE_ADJ == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    yy_current_buffer->yy_eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    yy_current_buffer->yy_eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
}


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()
{
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    register YY_CHAR *yy_bp = yytext;

    yy_current_state = yy_start;
    if ( yy_bp[-1] == '\n' )
	++yy_current_state;

    for ( yy_cp = yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
	{
	register YY_CHAR yy_c = (*yy_cp ? yy_ec[*yy_cp] : 1);
	if ( yy_accept[yy_current_state] )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	    {
	    yy_current_state = yy_def[yy_current_state];
	    if ( yy_current_state >= 573 )
		yy_c = yy_meta[yy_c];
	    }
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	}

    return ( yy_current_state );
}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
{
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register YY_CHAR yy_c = 1;
    if ( yy_accept[yy_current_state] )
	{
	yy_last_accepting_state = yy_current_state;
	yy_last_accepting_cpos = yy_cp;
	}
    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	{
	yy_current_state = yy_def[yy_current_state];
	if ( yy_current_state >= 573 )
	    yy_c = yy_meta[yy_c];
	}
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam = (yy_current_state == 572);

    return ( yy_is_jam ? 0 : yy_current_state );
}


#if 0		/* not needed for NetHack */

static void yyunput( in_c, yy_bp )
int in_c;		/* YY_CHAR c; */
register YY_CHAR *yy_bp;
{
    register YY_CHAR *yy_cp = yy_c_buf_p;
    YY_CHAR c = (YY_CHAR)in_c;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
	register YY_CHAR *dest =
	    &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
	register YY_CHAR *source =
	    &yy_current_buffer->yy_ch_buf[number_to_move];

	while ( source > yy_current_buffer->yy_ch_buf )
	    *--dest = *--source;

	yy_cp += dest - source;
	yy_bp += dest - source;
	yy_n_chars = yy_current_buffer->yy_buf_size;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
	yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
}


static int yyinput()
{
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{
	/* yy_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
	    /* this was really a NUL */
	    *yy_c_buf_p = '\0';

	else
	    { /* need more input */
	    yytext = yy_c_buf_p;
	    ++yy_c_buf_p;

	    switch ( yy_get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( yywrap() )
			{
			yy_c_buf_p = yytext + YY_MORE_ADJ;
			return ( EOF );
			}

		    YY_NEW_FILE;

		    return ( yyinput() );
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    yy_c_buf_p = yytext + YY_MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
		    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
		}
	    }
	}

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
}

#endif	/* 0 */


void yyrestart( input_file )
FILE *input_file;
{
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
}


void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
{
    if ( yy_current_buffer == new_buffer )
	return;

    if ( yy_current_buffer )
	{
	/* flush out information for old buffer */
	*yy_c_buf_p = yy_hold_char;
	yy_current_buffer->yy_buf_pos = yy_c_buf_p;
	yy_current_buffer->yy_n_chars = yy_n_chars;
	}

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
}


void yy_load_buffer_state()
{
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
}


YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
{
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) alloc( sizeof( struct yy_buffer_state ) );
    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) alloc( (unsigned) (b->yy_buf_size + 2) );
    yy_init_buffer( b, file );

    return ( b );
}


void yy_delete_buffer( b )
YY_BUFFER_STATE b;
{
    if ( b == yy_current_buffer )
	yy_current_buffer = (YY_BUFFER_STATE) 0;

    free((genericptr_t)b->yy_ch_buf);
    free((genericptr_t)b);
}


void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
{
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
}

#ifdef	AMIGA
long *alloc(n)
	unsigned n;
{
	return ((long *)malloc (n));
}
#endif

/* routine to switch to another input file; needed for flex */
void init_yyin( input_f )
FILE *input_f;
{
#if defined(FLEX_SCANNER) || defined(FLEXHACK_SCANNER)
	if (yyin)
	    yyrestart(input_f);
	else
#endif
	    yyin = input_f;
}
/* analogous routine (for completeness) */
void init_yyout( output_f )
FILE *output_f;
{
	yyout = output_f;
}

