/*
 * selection.h : Defs for manipulating items selected in the browser
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#ifndef SELECTION_H
#define SELECTION_H

#include "db.h"

typedef struct SelectedItem_s {
    DbEntry *entry;
    int list_index;
    struct SelectedItem_s *next,*prev;
} SelectedItem;

extern void resetSelections();
extern void redrawSelectionsForPane(),resetSelectionsForPane();
extern void addSelection(),addSelectionInPane(),removeSelection();
extern SelectedItem *getSelection();
extern Boolean isSelected(),isSelectedInPane();
extern Boolean hasSelection(),hasSelectionInPane();
extern void forEachSelectedItemAtDepth(),forEachSelectedItem();

#endif
