/*
 * actions.c : Widget action procedures
 *
 * Other modules also define actions, and call XtAppAddActions() when
 * they are initialized.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 2 Nov 1991.
 * Version 2.0: 23 Apr 1993.
 * 30 Jun 1993: Use sindex() from support.c rather than strstr(3).
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include "xarchie.h"
#include "browser.h"
#include "types.h"
#include "appres.h"
#include "actions.h"
#include "file-panel.h"
#include "ftp-actions.h"
#include "about.h"
#ifdef HELP
# include "help.h"
#endif
#include "query.h"
#include "regex.h"
#include "xutil.h"
#include "stringdefs.h"
#include "alert.h"
#include "confirm.h"
#include "debug.h"
extern void abortDirsend();		/* dirsend.c */
extern void ftpAbortTransfer();		/* ftp-actions.c */
extern char *sindex();			/* support.c (replaces strstr(3)) */

/*
 * Functions defined here
 */
void initActions();

static void quitAction();
static void queryAction(),abortAction(),queryOrAbortAction();
static void queryHostAction(),queryLocationAction();
static void shiftDownAction(),shiftUpAction(),shiftTopAction();
static void openAllAction(),openFilesAction(),openDirectoriesAction();
static void getAction();

/*
 * Data defined here:
 */
static XtActionsRec actionTable[] = {
    { "quit",			quitAction },
    { "query",			queryAction },
    { "abort",			abortAction },
    { "query-or-abort",		queryOrAbortAction },
    { "query-host",		queryHostAction },
    { "query-location",		queryLocationAction },
    { "browser-down",		shiftDownAction },
    { "browser-up",		shiftUpAction },
    { "browser-top",		shiftTopAction },
    { "browser-open-files",	openFilesAction },
    { "browser-open-directories",	openDirectoriesAction },
    { "browser-open-all",	openAllAction },
    { "ftp-get",		getAction },
};

/*	-	-	-	-	-	-	-	-	*/

void
initActions()
{
    XtAppAddActions(appContext,actionTable,XtNumber(actionTable));
    initFtpActions();
    initFilePanelActions();
    initAboutActions();
#ifdef HELP
    initHelpActions();
#endif
}

/*	-	-	-	-	-	-	-	-	*/

#define ACTION_PROC(NAME)	void NAME(w,event,params,num_params) \
					Widget w; \
					XEvent *event; \
					String *params; \
					Cardinal *num_params;

/*ARGSUSED*/
static
ACTION_PROC(quitAction)
{
    bye(0);
}

/*ARGSUSED*/
static
ACTION_PROC(queryAction)
{
    char *s;
    int len;
    Boolean gif;

    if (getBrowserState() != BROWSER_READY) {
	/* Don't do anything using popups since we could be in dirsend()
	   by now. */
	XBell(display,0);
	return;
    }
    if ((s=getWidgetString(searchText)) == NULL || *s == '\0') {
	alert0("No search term specified.");
	return;
    }
#ifndef DONT_CATCH_GIFS
    len = strlen(s);
    gif = False;
    switch (appResources.searchType) {
	case GfExact:
	    gif = ((len > 4 &&
		    (!strcmp(s+len-4,".gif") || !strcmp(s+len-4,".GIF"))) ||
		   (len > 6 &&
		    (!strcmp(s+len-6,".gif.Z") || !strcmp(s+len-6,".GIF.Z"))));
	    break;
	case GfSubstr:
	case GfExactSubstr:
	case GfSubcase:
	case GfExactSubcase:
	    gif = (sindex(s,"gif") || sindex(s,"GIF"));
	    break;
	case GfRegexp:
	case GfExactRegexp:
	    gif = (re_comp(s) == NULL &&
		   (re_exec("@PrObAbLyNoTaFiLe@.gif") ||
		    re_exec("@PrObAbLyNoTaFiLe@.gif.Z")));
	    break;
    }
    if (gif) {
	if (!confirm0("Your search term will match GIFs. Do it anyway?"))
	    return;
	else if (appResources.niceLevel <= 0 &&
		 !confirm0("Really do it without increasing niceness?"))
	    return;
    }
#endif /* DONT_CATCH_GIFS */
    /* We're about to do the query, so disable querying */
    setBrowserState(BROWSER_DIRSEND);
    queryItemAndParse(s);
    /* Re-enable querying */
    setBrowserState(BROWSER_READY);
}

/*ARGSUSED*/
static
ACTION_PROC(abortAction)
{
    DEBUG0("abortAction...\n");
    XtSetSensitive(abortButton,False);
    switch (getBrowserState()) {
	case BROWSER_DIRSEND:
	    abortDirsend();
	    break;
	case BROWSER_FTP:
	    ftpAbortTransfer();
	    break;
    }
    DEBUG0("abortAction: done\n");
}

/*ARGSUSED*/
static
ACTION_PROC(queryOrAbortAction)
{
    DEBUG0("queryOrAbortAction...\n");
    if (getBrowserState() == BROWSER_READY)
	XtCallActionProc(toplevel,"query",NULL,NULL,0);
    else
	XtCallActionProc(toplevel,"abort",NULL,NULL,0);
    DEBUG0("queryOrAbortAction: done\n");
}

/*ARGSUSED*/
static
ACTION_PROC(queryHostAction)
{
    char *host;

    if (getBrowserState() != BROWSER_READY) {
	XBell(display,0);
	return;
    }
    if ((host=getWidgetString(hostText)) == NULL || *host == '\0') {
	alert0("No host specified.");
	return;
    }
    /* We're about to do the query, so disable querying */
    setBrowserState(BROWSER_DIRSEND);
    queryHostAndParse(host);
    /* Re-enable querying */
    setBrowserState(BROWSER_READY);
}

/*ARGSUSED*/
static
ACTION_PROC(queryLocationAction)
{
    char *host,*loc;

    if (getBrowserState() != BROWSER_READY) {
	XBell(display,0);
	return;
    }
    if ((host=getWidgetString(hostText)) == NULL || *host == '\0') {
	alert0("No host specified.");
	return;
    }
    if ((loc=getWidgetString(locationText)) == NULL || *loc == '\0') {
	alert0("No host specified.");
	return;
    }
    /* We're about to do the query, so disable querying */
    setBrowserState(BROWSER_DIRSEND);
    queryLocationAndParse(host,loc);
    /* Re-enable querying */
    setBrowserState(BROWSER_READY);
}

/*	-	-	-	-	-	-	-	-	*/

/*ARGSUSED*/
static
ACTION_PROC(shiftDownAction)
{
    shiftBrowserDown();
}

/*ARGSUSED*/
static
ACTION_PROC(shiftUpAction)
{
    shiftBrowserUp();
}

/*ARGSUSED*/
static
ACTION_PROC(shiftTopAction)
{
    shiftBrowserTop();
}

/*ARGSUSED*/
static
ACTION_PROC(openAllAction)
{
    if (getBrowserState() != BROWSER_READY) {
	XBell(display,0);
	return;
    }
    if (openBrowserAll() == 1)
	shiftBrowserDown();
}

/*ARGSUSED*/
static
ACTION_PROC(openDirectoriesAction)
{
    if (getBrowserState() != BROWSER_READY) {
	XBell(display,0);
	return;
    }
    if (openBrowserDirectories() == 1)
	shiftBrowserDown();
}

/*ARGSUSED*/
static
ACTION_PROC(openFilesAction)
{
    if (getBrowserState() != BROWSER_READY) {
	XBell(display,0);
	return;
    }
    openBrowserFiles();
}

/*	-	-	-	-	-	-	-	-	*/

/*ARGSUSED*/
static
ACTION_PROC(getAction)
{
    if (getBrowserState() != BROWSER_READY) {
	XBell(display,0);
	return;
    }
    DEBUG0("getAction...\n");
    ftpGetSelectedItems();
    DEBUG0("getAction: done\n");
}
