/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

/*
** shift.c
**
** Larch shift sequence manager
**
**	Tokens are sent by the parser to this module.  Here they are saved
**	for awhile in a stack, and delivered on demand during reduce actions.
**	The coordination between what the parser sends here and what reduce
**	consumes here must be maintained by the programmer.
**
*/

# include "lclintMacros.nf"
# include "llbasic.h"
# include "shift.h"

/*@constant static int SHIFTMAX;@*/
# define SHIFTMAX 200

static o_ltoken Shifts[SHIFTMAX];
static int shiftIndex;

static bool Parsing_LSLinit = TRUE;

static bool
LSLGenIsEmptyShiftStack (void)
{
  return (shiftIndex == 0);
}

extern void
LSLGenShift (ltoken tok)
{
  if (shiftIndex < SHIFTMAX)
    {
      Shifts[shiftIndex] = ltoken_copy (tok);
      shiftIndex++;
    }
  else
    {
      llbuglit ("LSLGenShift: needs MoreMem ()");
    }
}

extern void
LSLGenShiftOnly (/*@only@*/ ltoken tok)
{
  if (shiftIndex < SHIFTMAX)
    {
      Shifts[shiftIndex] = tok;
      shiftIndex++;
    }
  else
    {
      llbuglit ("LSLGenShift: needs MoreMem ()");
    }
}

extern ltoken
LSLGenTopPopShiftStack (void)
{
  if (LSLGenIsEmptyShiftStack ())
    {
      lclfatalbug ("LSLGenTopPopShiftStack: Empty stack");
    }

  /*@-retalias@*/
  return Shifts[--shiftIndex];
  /*@=retalias@*/
}

void
LSLGenInit (bool LSLParse)
{
  Parsing_LSLinit = LSLParse;
}

