/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** out.c
**
** LCL general output routines.
**
**  AUTHORS:
**
**	Gary Feldman, Technical Languages and Environments, DECspec project
**	Steve Garland, Massachusetts Institute of Technology, Larch project
**	Joe Wild, Technical Languages and Environments, DECspec project
**
**  CREATION DATE:
**
**	15 April 1991
*/

# include "lclintMacros.nf"
# include "basic.h"
# include "out.h"

/*@dependent@*/ /*@null@*/ FILE *out_open (char *name, char *suffix)
{
  char *fullname = (char *)
    mstring_create (size_toInt (strlen (name) + strlen (suffix)));
  FILE *ret;

  strcpy (fullname, name);
  strcat (fullname, suffix);
  ret = fopen (fullname, "w+");
  sfree (fullname);
  return ret;
}

