/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** fcnNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

fcnNodeList
  fcnNodeList_new ()
{
  return fcnNodeList_undefined;
}

static /*@notnull@*/ /*@only@*/ fcnNodeList
fcnNodeList_newEmpty (void)
{
  fcnNodeList s = (fcnNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = fcnNodeListBASESIZE;
  s->elements = (fcnNode *) dmalloc (sizeof (*s->elements) * fcnNodeListBASESIZE);

  return (s);
}

static void
fcnNodeList_grow (/*@notnull@*/ fcnNodeList s)
{
  int i;
  fcnNode *newelements;

  s->nspace = fcnNodeListBASESIZE + s->nspace;
  newelements = (fcnNode *) dmalloc (sizeof (*newelements) 
				     * (s->nelements + fcnNodeListBASESIZE));

  if (newelements == (fcnNode *) 0)
    {
      llfatalerror (cstring_makeLiteral ("fcnNodeList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

fcnNodeList
fcnNodeList_add (fcnNodeList s, fcnNode el)
{
  if (fcnNodeList_isUndefined (s))
    {
      s = fcnNodeList_newEmpty ();
    }

  if (s->nspace <= 0)
    fcnNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
fcnNodeList_unparse (fcnNodeList s)
{
  int i;
  cstring st = cstring_undefined;

  if (fcnNodeList_isDefined (s))
    {
      for (i = 0; i < s->nelements; i++)
	{
	  st = message ("%q%q\n", st, fcnNode_unparse (s->elements[i]));
	}
    }

  return st;
}

void
fcnNodeList_free (/*@null@*/ /*@only@*/ fcnNodeList s)
{
  if (s != NULL)
    {
      int i;
      for (i = 0; i < s->nelements; i++)
	{
	  fcnNode_free (s->elements[i]); 
	}
      
      sfree (s->elements);
      sfree (s);
    
    }
}
