/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef termNodeLIST_H
# define termNodeLIST_H

typedef /*@only@*/ termNode o_termNode;

struct _termNodeList
{
  int nelements;
  int nspacehigh;
  int nspacelow;
  int current;
  /*@reldef@*/ /*@only@*/ /*@relnull@*/ o_termNode *elements;
} ;

/*@iter termNodeList_elements (sef termNodeList x, yield exposed termNode el); @*/
# define termNodeList_elements(x, m_el) \
   { int m_ind; termNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { termNode m_el = *(m_elements++); 

# define end_termNodeList_elements }}

extern int termNodeList_size (/*@sef@*/ termNodeList);
# define termNodeList_size(s)  (termNodeList_isDefined (s) ? (s)->nelements : 0)

extern bool termNodeList_empty (/*@sef@*/ termNodeList);
# define termNodeList_empty(s) (termNodeList_size(s) == 0)

extern /*@falsenull@*/ bool termNodeList_isDefined (termNodeList t);
# define termNodeList_isDefined(s) ((s) != (termNodeList) 0)

extern /*@only@*/ termNodeList termNodeList_new(void);
extern termNodeList termNodeList_push (/*@returned@*/ termNodeList s, 
				       /*@keep@*/ termNode el) ;

extern void termNodeList_addh (termNodeList s, /*@keep@*/ termNode el) ;
extern void termNodeList_addl (termNodeList s, /*@keep@*/ termNode el) ;

extern void termNodeList_reset (termNodeList s) 
   /*@modifies s@*/ ;   
extern void termNodeList_finish (termNodeList s) 
   /*@modifies s@*/ ; 
extern void termNodeList_advance (termNodeList s) 
   /*@modifies s@*/ ; 

extern /*@exposed@*/ termNode termNodeList_getN (termNodeList s, int n) /*@*/ ;

extern /*@only@*/ cstring termNodeList_unparse (termNodeList s) ;
extern /*@only@*/ cstring termNodeList_unparseTail (termNodeList s);
extern /*@only@*/ cstring termNodeList_unparseToCurrent (termNodeList s);
extern /*@only@*/ cstring termNodeList_unparseSecondToCurrent (termNodeList s);

extern void termNodeList_free (/*@only@*/ termNodeList s) ;

extern /*@exposed@*/ termNode termNodeList_head (termNodeList s) ;
extern /*@exposed@*/ termNode termNodeList_current (termNodeList s) ;

extern /*@only@*/ termNodeList termNodeList_copy (termNodeList s) ; 

/*@constant int termNodeListGROWLOW;@*/
# define termNodeListGROWLOW 4 /* addl used in abstract.c */

/*@constant int termNodeListGROWHI;@*/
# define termNodeListGROWHI 4

/*@constant int termNodeListBASESIZE;@*/
# define termNodeListBASESIZE (termNodeListGROWLOW + termNodeListGROWHI)

# else
# error "Multiple include"
# endif




