/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** filestack.h
*/

# ifndef FILESTACK_H
# define FILESTACK_H

typedef struct _fentry
{
  /*@null@*/ /*@dependent@*/ FILE  *fin;
  /*@null@*/ /*@dependent@*/ FILE  *fout;
  /*@null@*/ /*@dependent@*/ FILE  *fdef;
  fileId curfile;
  int curline;
} *fentry;

typedef /*@only@*/ fentry o_fentry;

abst_typedef struct __fileStack
{
  int       nentries;
  int       nfree;
  int       oentries;
  int       ofree;
  /*@reldef@*/ /*@only@*/ o_fentry *entries;
  /*@reldef@*/ /*@only@*/ fileId   *oldentries;
} *fileStack;

/*@constant int FILESTACKBASESIZE; @*/
# define FILESTACKBASESIZE 16

extern /*@only@*/ fileStack fileStack_create (void) /*@*/ ;
extern void fileStack_push (fileStack f, /*@null@*/ /*@dependent@*/ FILE *in, 
			    /*@null@*/ /*@dependent@*/  FILE *out, 
			    fileId curf, int curline,
			    /*@null@*/ /*@dependent@*/ FILE *def);

typedef /*@dependent@*/ FILE *dFILE;

extern fileId fileStack_pop (fileStack f, 
			     /*@out@*/ dFILE *infile, /*@out@*/ dFILE *ofile,
			     /*@out@*/ dFILE *def)
   /*@modifies f, *infile, *ofile, *def; @*/ ;

extern /*@unused@*/ void fileStack_print (fileStack f);
extern void fileStack_annihilate (/*@only@*/ fileStack f);
extern bool fileStack_contains (fileStack f, fileId fid);
extern void fileStack_pushOld (fileStack f, fileId curf);

# else
# error "Multiple include"
# endif










