/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef DECLARATORNODELIST_H
# define DECLARATORNODELIST_H

typedef /*@only@*/ declaratorNode o_declaratorNode;

abst_typedef struct _declaratorNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_declaratorNode  *elements;
} *declaratorNodeList ;

/*@iter declaratorNodeList_elements (sef declaratorNodeList x, yield exposed declaratorNode el); @*/
# define declaratorNodeList_elements(x, m_el) \
   { int m_ind; declaratorNode *m_elements = &((x)->elements[0]); \
       for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	 { declaratorNode m_el = *(m_elements++);

# define end_declaratorNodeList_elements }}


extern /*@only@*/ declaratorNodeList declaratorNodeList_new(void);
extern declaratorNodeList 
  declaratorNodeList_add (/*@returned@*/ declaratorNodeList x, /*@only@*/ declaratorNode n);

extern /*@only@*/ cstring declaratorNodeList_unparse (declaratorNodeList s) ;
extern void declaratorNodeList_free (/*@only@*/ declaratorNodeList s) ;
extern declaratorNodeList declaratorNodeList_copy (declaratorNodeList s) ;

/*@constant int declaratorNodeListBASESIZE;@*/
# define declaratorNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




