/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# if !defined(BOOL_H)

# define BOOL_H

# ifndef FALSE
# define FALSE 0
# endif

# ifndef TRUE
# define TRUE (! FALSE)
# endif

extern /*@observer@*/ cstring bool_unparse (bool b) /*@*/ ;
extern /*@observer@*/ cstring bool_dump (bool b) /*@*/ ;
extern /*@unused@*/ bool bool_not (bool b) /*@*/ ;
extern bool bool_equal (bool b1, bool b2) /*@*/ ;
extern int bool_compare (bool b1, bool b2) /*@*/ ;
extern bool bool_fromInt (int i) /*@*/ ;
extern int bool_toInt (bool b) /*@*/ ;

/*@access bool@*/

# define bool_unparse(b)   (cstring_makeLiteralTemp ((b) ? "true" : "false" ))
# define bool_dump(b)      (cstring_makeLiteralTemp ((b) ? "1" : "0" ))
# define bool_not(b)       ((b) ? FALSE : TRUE)
# define bool_equal(a,b)   ((a) ? (b) : !(b))
# define bool_compare(a,b) ((a) ? ((b) ? 0 : 1) : ((b) ? -1 : 0))
# define bool_fromInt(i)   (((i) != 0) ? TRUE : FALSE)
# define bool_toInt(b)     ((b) ? 1 : 0)

# else
# error "Multiple include"
# endif




