/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# if !defined(YNM_H)
# define YNM_H

typedef enum { NO, YES, MAYBE } ynm;

extern /*@observer@*/ cstring ynm_unparse (/*@sef@*/ ynm b) /*@*/ ;
extern /*@observer@*/ cstring ynm_unparseCode (/*@sef@*/ ynm b) /*@*/ ;
extern bool ynm_toBoolStrict (ynm b) /*@*/ ;
extern bool ynm_toBoolRelaxed (ynm b) /*@*/ ;
extern ynm ynm_fromBool (bool b) /*@*/ ;
extern bool ynm_isOff (ynm b) /*@*/ ;
extern bool ynm_isOn (ynm b) /*@*/ ;
extern bool ynm_isMaybe (ynm b) /*@*/ ;
extern int ynm_compare (ynm x, ynm y) /*@*/ ;
extern ynm ynm_fromCodeChar (char c) /*@*/ ;

# define ynm_unparse(b) \
  (cstring_makeLiteralTemp (((b) == NO) ? "no" : ((b) == YES) ? "yes" : "maybe"))
# define ynm_unparseCode(b) \
  (cstring_makeLiteralTemp (((b) == NO) ? "-" : ((b) == YES) ? "+" : "="))

# define ynm_toBoolStrict(y) ((y) == YES)
# define ynm_toBoolRelaxed(y) ((y) != NO)
# define ynm_fromBool(b)   ((b) ? YES : NO)
# define ynm_isOff(y)      ((y) == NO)
# define ynm_isOn(y)       ((y) == YES)
# define ynm_isMaybe(y)    ((y) == MAYBE)

# else
# error "Multiple include"
# endif

