/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** sort.h
*/

# ifndef sort_H
# define sort_H

/*@constant observer char *BEGINSORTTABLE;@*/
# define BEGINSORTTABLE		"%LCLSortTable"

/*@constant observer char *SORTTABLEEND;@*/
# define SORTTABLEEND		"%LCLSortTableEnd"

typedef enum {
  SRT_FIRST,
  SRT_NONE,        
  SRT_HOF,        
  SRT_PRIM,
  SRT_SYN,
  SRT_PTR,
  SRT_OBJ,
  SRT_ARRAY,
  SRT_VECTOR,
  SRT_STRUCT,
  SRT_TUPLE,
  SRT_UNION,
  SRT_UNIONVAL,
  SRT_ENUM,
  SRT_LAST
} sortKind;

typedef struct _smemberInfo {
    lsymbol name;
    sort sort;
    /*@reldef@*/ lsymbol sortname; /* useful for sort_imports (yuk!) */
    /*@null@*/ /*@dependent@*/ struct _smemberInfo *next;
} smemberInfo;

/*@constant null smemberInfo *smemberInfo_undefined; @*/
# define smemberInfo_undefined 	((smemberInfo *)NULL)

typedef struct _sortNode
{
  sortKind	kind;  

  /* Handle for this sort in the table of known sorts */
  sort          handle; 

  /*
  ** if SRT_PRIM then name is gotten from LSL traits.
  **  elseif SRT_SYN then it is derived from a user-given typdef name, add _.
  **  elseif SRT_NONE then may contain "_error".
  **  elseif keeps the name of this sort (unique) 
  */
  
  lsymbol	name;    

  /* 
  ** if {STRUCT, UNION, ENUM} and name field is non-nil
  ** then it is the tag name.  Kept to make printing and 
  ** debugging easier, for now.  
  */
  
  /*@reldef@*/ lsymbol tag;
  /*@reldef@*/ bool realtag; 

  /* 
  ** if SRT_SYN then keeps handle for synonym sort,  
  ** elseif {OBJ, PTR, ARRAY, VECTOR} then keeps the element sort.
  ** elseif {TUPLE, UNIONVAL} then keeps the baseSort which is a
  ** record or union sort. 
  */

  sort          baseSort;   

  /*
  ** Only for VECTOR sort, gives its array sort, 
  ** not used otherwise. 
  */

  /*@reldef@*/ sort   objSort; 

  /* First member of struct, union, or enum */
  /*@null@*/ smemberInfo *members;   

  bool export;   /* TRUE if sort is exported by this spec */
  bool mutable;  /* TRUE if sort represents a mutable sort */
  bool abstract; /* TRUE if sort represents an LCL abstract type */
  bool imported; /* TRUE if sort was imported */
} sortNode;

extern cstring sort_unparse (sort s) /*@*/ ;
extern /*@exposed@*/ cstring sort_unparseName (sort s) /*@*/ ;
extern sort sort_makeSort(ltoken t, lsymbol n) /*@*/ ;
extern sort sort_makeSyn(ltoken t, sort s, lsymbol n) /*@*/ ;
extern sort sort_makeFormal(sort s) /*@*/ ;
extern sort sort_makeGlobal(sort s) /*@*/ ;
extern sort sort_makePtr (ltoken t, sort s) /*@*/ ;
extern sort sort_makePtrN (sort s, int pointers) /*@*/ ;
extern sort sort_makeVal(sort s) /*@*/ ;
extern sort sort_makeObj(sort s) /*@*/ ;

extern void sort_destroyMod (void) /*@modifies internalState@*/ ;

extern sort sort_makeArr (ltoken t, sort s) /*@*/ ;
extern sort sort_makeVec (ltoken t, sort s) /*@*/ ;
extern sort sort_makeMutable (ltoken t, lsymbol name) /*@*/ ;
extern sort sort_makeImmutable (ltoken t, lsymbol name) /*@*/ ;

extern sort sort_makeStr (ltoken opttagid) /*@*/ ;
extern sort sort_makeUnion (ltoken opttagid) /*@*/ ;
extern sort sort_makeEnum (ltoken opttagid) /*@*/ ;

extern bool 
  sort_updateStr (sort s, /*@null@*/ /*@only@*/ smemberInfo *info)
  /*@modifies internalState@*/ ;
extern bool
  sort_updateUnion (sort s, /*@null@*/ /*@only@*/ smemberInfo *info)
  /*@modifies internalState@*/ ;
extern bool 
  sort_updateEnum (sort s, /*@null@*/ /*@only@*/ smemberInfo *info)
  /*@modifies internalState@*/ ;

extern sort sort_makeTuple (ltoken t, sort s) /*@modifies internalState@*/ ;
extern sort sort_makeUnionVal (ltoken t, sort s) /*@modifies internalState@*/ ;

extern lsymbol sort_getLsymbol (sort s) /*@*/ ;
extern /*@observer@*/ char *sort_getName (sort s) /*@*/ ;
extern /*@observer@*/ sortNode sort_lookup (sort s) /*@*/ ; 
extern /*@observer@*/ sortNode sort_quietLookup (sort sor) /*@*/ ;
extern sort sort_lookupName (lsymbol name) /*@*/ ;
extern void sort_dump(FILE *f, bool lco) /*@modifies f@*/ ;
extern void sort_init(void) /*@modifies internalState@*/ ;

extern bool sort_compatible(sort s1, sort s2) /*@*/ ;
extern bool sort_compatible_modulo_cstring(sort s1, sort s2) /*@*/ ;
extern sort sort_getUnderlying (sort s) /*@*/ ;
extern bool sort_mutable (sort s) /*@*/ ;
extern sort sort_makeNoSort(void) /*@modifies internalState@*/ ;

extern sort sort_makeHOFSort(sort base) /*@*/ ; 
extern bool sort_isHOFSortKind(sort s) /*@*/ ; 
extern bool sort_isNoSort(sort s) /*@*/ ;
extern bool sort_isValidSort(sort s) /*@*/ ;
extern bool sort_setExporting (bool flag) /*@modifies internalState@*/ ;

# define sort_isNoSort(s)       ((s) == 0)
/* assume NOSORTHANDLE is #define to 0 in sort.c */

extern /*@unused@*/ void sort_printStats(void) /*@modifies stderr@*/ ;

extern bool sort_equal (sort *s1, sort *s2) /*@*/ ;  
extern sort sort_fromLsymbol (lsymbol sortid) /*@modifies internalState@*/ ;

extern void sort_import(tsource *imported, ltoken tok, mapping *map)
   /*@modifies *imported, internalState@*/ ;

extern sort sort_bool;
extern sort sort_capBool;
extern sort sort_int;
extern sort sort_char;
extern sort sort_cstring;
extern sort sort_float;
extern sort sort_double;

# else
# error "Multiple include"
# endif


