/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** misc.h
**
** (general.c)
*/

# ifndef MISC_H
# define MISC_H

typedef	unsigned int bits;
typedef long unsigned Handle;

extern char *itoa (int i) /*@*/ ;
extern bool isLCLfile (cstring s) /*@*/ ;
extern bool isCext(char *s) /*@*/ ;
extern char *addExtension(char *s, const char *suffix);

extern char *removeExtension (char *s, const char *suffix) /*@*/ ;
extern char *removePath (char *s) /*@*/ ;
extern char *removePathFree (/*@only@*/ char *s) /*@*/ ;
extern char *removeAnyExtension (char *s) /*@*/ ;

extern int getInt (char **s) /*@modifies *s@*/ ;
extern char loadChar (char **s) /*@modifies *s@*/ ; 
extern double getDouble (char **s) /*@modifies *s@*/ ;
extern void docheckChar (char ** s, char c, char *file, int line)
   /*@modifies *s;@*/;

extern bool optCheckChar (char **s, char c) /*@modifies *s;@*/ ;
extern void checkChar (char **s, char c) /*@modifies *s;@*/ ;
# define checkChar(s,c)  (docheckChar (s, c, __FILE__, __LINE__))
extern /*@null@*/ char *getWord (char **s) /*@modifies *s@*/ ;
extern cstring getStringWord (char **s) /*@modifies *s@*/ ;

/* string functions */

typedef /*@concrete@*/ char *mstring;
typedef /*@observer@*/ char *ob_mstring;
typedef /*@observer@*/ /*@null@*/ char *bn_mstring;

extern /*@unused@*/ /*@notnull@*/ /*@observer@*/ char *
  mstring_safePrint (/*@returned@*/ /*@null@*/ char *s) /*@*/ ;
extern char *mstring_spaces (int n) /*@*/ ;
extern char *mstring_concat  (const char *c1, const char *c2) /*@*/ ;
extern char *mstring_concatFree (/*@only@*/ char *c1, /*@only@*/ char *c2) /*@modifies *c1, *c2*/ ;
extern char *mstring_concatFree1 (/*@only@*/ char *c1, const char *c2);
extern char *mstring_append (/*@only@*/ char *s1, char c);
extern char *mstring_copy (char *s1) /*@*/ ;
extern bool mstring_equalPrefix (const char *c1, const char *c2) /*@*/ ;
extern bool mstring_equal (/*@null@*/ const char *s1, /*@null@*/ const char *s2) /*@*/ ;

extern int mstring_length (/*@sef@*/ /*@null@*/ char *s) /*@*/ ;
# define mstring_length(s) \
  (((s) != NULL) ? size_toInt (strlen (s)) : 0)

extern /*@falsenull@*/ bool mstring_isDefined (/*@sef@*/ /*@null@*/ char *s) /*@*/ ;
# define mstring_isDefined(s) ((s) != NULL)

extern bool mstring_isEmpty (/*@sef@*/ /*@null@*/ char *s) /*@*/ ;
# define mstring_isEmpty(s) (mstring_length(s) == 0)

extern void mstring_markFree (/*@owned@*/ char *s) /*@modifies *s;@*/ ;

extern /*@notnull@*/ /*@only@*/ char *mstring_create (int n) /*@*/ ;
extern /*@notnull@*/ /*@only@*/ char *mstring_createEmpty (void) /*@*/ ;

extern void mstring_free (/*@out@*/ /*@only@*/ /*@null@*/ char *s);
# define mstring_free(s) sfree(s)

# define mstring_createEmpty() mstring_create(0)

extern int int_compare (/*@sef@*/ int x, /*@sef@*/ int y) /*@*/ ;
# define int_compare(x,y) (((x) > (y)) ? 1 : (((x) < (y)) ? -1 : 0))

/*@-macroparams@*/
/*@-macrofcndecl@*/ /* works for lots of types */
# define generic_compare(x,y) (((x) > (y)) ? 1 : (((x) < (y)) ? -1 : 0)) 
/*@=macrofcndecl@*/
/*@=macroparams@*/

# define getStringWord(s)     (cstring_fromChars(getWord(s)))

/*@notfunction@*/
# define GET(s) ((s *)smalloc(sizeof(s)))

extern void fputline (FILE *f, char *s) /*@modifies f@*/;

extern int int_log (int x) /*@*/ ;

/*@-czechfcns@*/
extern int size_toInt (size_t x) /*@*/ ;
extern size_t size_fromInt (int x) /*@*/ ;
extern int longUnsigned_toInt (long unsigned int x) /*@*/ ;
extern long unsigned longUnsigned_fromInt (int x) /*@*/ ;
/*@=czechfcns@*/

extern char char_fromInt (int x) /*@*/ ;

extern /*@observer@*/ /*@null@*/ char *
  filenameExtension (/*@returned@*/ char *s) /*@*/ ;

extern /*@exposed@*/ char *removePreDirs (/*@exposed@*/ char *s);
extern bool firstWord (char *s, char *w);
extern void checkUngetc (int c, FILE *f) /*@modifies *f@*/ ;

# else
# error "Multiple include"
# endif
