/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** messageLog.h (from slist_templace.h)
*/

# ifndef messageLog_H
# define messageLog_H

typedef struct _msgentry
{
  fileloc loc;
  cstring msg;
} *msgentry ;

typedef /*@only@*/ msgentry o_msgentry;

abst_typedef /*@null@*/ struct _messageLog
{
  int        nelements;
  int        nspace;
  /*@reldef@*/ /*@only@*/ o_msgentry  *elements;
} *messageLog ;

/*@constant null messageLog messageLog_undefined; @*/
# define messageLog_undefined ((messageLog)0)

extern /*@unused@*/ /*@falsenull@*/ bool 
  messageLog_isDefined (messageLog s) /*@*/ ;
# define messageLog_isDefined(c) ((c) != messageLog_undefined)

extern /*@only@*/ messageLog messageLog_new (void) /*@*/ ;
extern bool messageLog_add (messageLog s, fileloc fl, cstring mess) 
            /*@modifies s@*/ ;

extern /*@only@*/ /*@unused@*/ cstring messageLog_unparse (messageLog s)  /*@*/ ;
extern void messageLog_free (/*@only@*/ messageLog s) ;

/*@constant int messageLogBASESIZE; @*/
# define messageLogBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif




