/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** usymIdSet.h
**
** based on set_template.h
*/

# ifndef USYMIDSET_H
# define USYMIDSET_H

# include "usymId.h"

abst_typedef /*@null@*/ struct _usymIdSet
{
  int entries;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ usymId  *elements;
} *usymIdSet ;

extern usymIdSet usymIdSet_new(void);
extern bool usymIdSet_member (usymIdSet s, usymId el) /*@*/ ;
extern usymIdSet usymIdSet_subtract (usymIdSet s, usymIdSet t);
extern void usymIdSet_free (/*@only@*/ /*@only@*/ usymIdSet s);
extern /*@only@*/ cstring usymIdSet_unparse (usymIdSet ll);
extern /*@only@*/ cstring usymIdSet_dump (usymIdSet ll);
extern usymIdSet usymIdSet_undump (char **s);
extern /*@only@*/ usymIdSet usymIdSet_single (usymId t);

extern int usymIdSet_compare (usymIdSet l1, usymIdSet l2);

/*@constant int usymIdSetBASESIZE;@*/
# define usymIdSetBASESIZE SMALLBASESIZE

extern usymIdSet usymIdSet_newUnion (usymIdSet s1, usymIdSet s2) /*@*/ ;
extern usymIdSet usymIdSet_add (usymIdSet s, usymId el) /*@*/ ;

extern /*@only@*/ usymIdSet 
  usymIdSet_removeFresh (/*@temp@*/ usymIdSet s, usymId el);

/*@constant null usymIdSet usymIdSet_undefined; @*/
# define usymIdSet_undefined    ((usymIdSet) NULL)

extern /*@falsenull@*/ bool usymIdSet_isDefined (usymIdSet s) /*@*/ ;
# define usymIdSet_isDefined(s) ((s) != usymIdSet_undefined)

extern /*@truenull@*/ bool usymIdSet_isUndefined (usymIdSet s) /*@*/ ;
# define usymIdSet_isUndefined(s) ((s) == usymIdSet_undefined)

/*@iter usymIdSet_elements (sef usymIdSet u, yield usymId el); @*/ 
# define usymIdSet_elements(x, m_el) \
   { int m_ind; if (usymIdSet_isDefined (x)) { \
     for (m_ind = 0 ; m_ind < usymIdSet_size(x); m_ind++) \
       { usymId m_el = (x)->elements[m_ind];

# define end_usymIdSet_elements }}}

extern int usymIdSet_size (/*@sef@*/ usymIdSet s);
# define usymIdSet_size(s) (usymIdSet_isUndefined(s) ? 0 : (s)->entries)

# else
# error "Multiple include"
# endif

