/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** invariant: line1 <= line2
**            if line1 == line2, col1 <= col2.
*/

# ifndef FLAGMARKER_H
# define FLAGMARKER_H

typedef enum
{
  FMK_LOCALSET,
  FMK_IGNOREON,
  FMK_IGNORECOUNT,
  FMK_IGNOREOFF,
  FMK_SUPPRESS
} flagMarkerKind ;

typedef struct _flagMarker
{
  flagMarkerKind kind;
  flagcode code;
  
  /*@reldef@*/ union {
    ynm set;
    int nerrors;
  } info;

  fileloc  loc;
} *flagMarker ;

extern bool flagMarker_isLocalSet (flagMarker c) /*@*/ ;
# define flagMarker_isLocalSet(c) ((c)->kind == FMK_LOCALSET)

extern bool flagMarker_isSuppress (flagMarker c) /*@*/ ;
# define flagMarker_isSuppress(c) ((c)->kind == FMK_SUPPRESS)

extern bool flagMarker_isIgnoreOn (flagMarker c) /*@*/ ;
# define flagMarker_isIgnoreOn(c) ((c)->kind == FMK_IGNOREON)

extern bool flagMarker_isIgnoreOff (flagMarker c) /*@*/ ;
# define flagMarker_isIgnoreOff(c) ((c)->kind == FMK_IGNOREOFF)

extern bool flagMarker_isIgnoreCount (flagMarker c) /*@*/ ;
# define flagMarker_isIgnoreCount(c) ((c)->kind == FMK_IGNORECOUNT)

extern flagMarker
  flagMarker_createLocalSet (flagcode code, ynm set, fileloc loc) /*@*/ ;

extern flagMarker
  flagMarker_createIgnoreOn (fileloc loc) /*@*/ ;

extern flagMarker
  flagMarker_createIgnoreOff (fileloc loc) /*@*/ ;

extern flagMarker
  flagMarker_createIgnoreCount (int count, fileloc loc) /*@*/ ;

extern flagMarker
  flagMarker_createSuppress (flagcode code, fileloc loc) /*@*/ ;

extern void flagMarker_free (/*@only@*/ flagMarker c) ;

extern bool flagMarker_sameFile (flagMarker c, fileloc loc) /*@*/ ;
extern /*@only@*/ cstring flagMarker_unparse (flagMarker c) /*@*/ ;

extern bool flagMarker_beforeMarker (flagMarker c, fileloc loc) /*@*/ ;

extern ynm flagMarker_getSet (flagMarker f) /*@*/ ; 
extern flagcode flagMarker_getCode (flagMarker f) /*@*/ ; 
extern int flagMarker_getCount (flagMarker f) /*@*/ ; 

extern /*@observer@*/ fileloc flagMarker_getLoc (flagMarker f) /*@*/ ;  

# define flagMarker_getLoc(f)  ((f)->loc)

# else
# error "Multiple include"
# endif
