Stack (E, C): trait
  % Common LIFO operators
  includes StackBasics, Integer
  introduces
    count: E, C -> Int
    __ \in __: E, C -> Bool
    size: C -> Int
    isEmpty: C -> Bool
  asserts
    \forall e: E, stk: C
      size(empty) == 0;
      size(push(e, stk)) == size(stk) + 1;
      isEmpty(stk) == stk = empty
  implies 
    Container (push for insert, top for head,
               pop for tail)
    C partitioned by top, pop, isEmpty
    \forall stk: C
      size(stk) >= 0
    converts top, pop, count, \in, size, isEmpty
      exempting top(empty), pop(empty)
