// $Id: ScrolledGE.C,v 1.12 1997/05/21 14:41:12 zeller Exp $  -*- C++ -*-
// Scrolled Graph Editor

// Copyright (C) 1995 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
// 
// This file is part of the DDD Library.
// 
// The DDD Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// The DDD Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with the DDD Library -- see the file COPYING.LIB.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers at `ddd@ips.cs.tu-bs.de'.

char ScrolledGraphEdit_rcsid[] = 
    "$Id: ScrolledGE.C,v 1.12 1997/05/21 14:41:12 zeller Exp $";

#ifdef __GNUG__
#pragma implementation
#endif

#include <iostream.h>
#include "ScrolleGEP.h"
#include "GraphEdit.h"
#include "verify.h"

#define EVERYWHERE (BoxRegion(BoxPoint(0,0), BoxSize(INT_MAX, INT_MAX)))

#if USE_OWN_SCROLLED_WINDOW

// Method function declarations

static void Resize(Widget w);


// Class record initialization

ScrolledGraphEditClassRec scrolledGraphEditClassRec = {
  {	 /* core fields */
    /* superclass               */  xmScrolledWindowWidgetClass,
    /* class_name               */  "ScrolledGraphEdit",
    /* widget_size              */  sizeof(ScrolledGraphEditRec),
    /* class_initialize         */  XtProc(0),
    /* class_part_initialize    */  XtWidgetClassProc(0),
    /* class_inited             */  False,
    /* initialize               */  XtInitProc(0),
    /* initialize_hook          */  XtArgsProc(0),
    /* realize                  */  XtInheritRealize,
    /* actions                  */  NULL,
    /* num_actions              */  0,
    /* resources                */  NULL,
    /* num_resources            */  0,
    /* xrm_class                */  NULLQUARK,
    /* compress_motion          */  True,
    /* compress_exposure        */  True,
    /* compress_enterleave      */  True,
    /* visible_interest         */  False,
    /* destroy                  */  XtWidgetProc(0),
    /* resize                   */  Resize,
    /* expose                   */  XtInheritExpose,
    /* set_values               */  XtSetValuesFunc(0),
    /* set_values_hook          */  XtArgsFunc(0),
    /* set_values_almost        */  XtInheritSetValuesAlmost,
    /* get_values_hook          */  XtArgsProc(0),
    /* accept_focus             */  XtAcceptFocusProc(0),
    /* version                  */  XtVersion,
    /* callback_private         */  NULL,
    /* tm_table                 */  NULL,
    /* query_geometry           */  XtInheritQueryGeometry,
    /* display_accelerator      */  XtInheritDisplayAccelerator,
    /* extension                */  NULL,
  },
  {     /* Composite fields */
    /* geometry_manager         */  XtInheritGeometryManager,
    /* change_managed           */  XtInheritChangeManaged,
    /* insert_child             */  XtInheritInsertChild,
    /* delete_child             */  XtInheritDeleteChild,
    /* extension                */  NULL,
  },
  {     /* Constraint fields */
    /* resources                */  NULL,
    /* num_resources            */  0,
    /* constraint_size          */  0,
    /* initialize               */  XtInitProc(0),
    /* destroy                  */  XtWidgetProc(0),
    /* set_values               */  XtSetValuesFunc(0),
    /* extension                */  NULL,
  },
  {     /* Manager fields */
    /* translations             */  XtInheritTranslations,
    /* syn_resources            */  NULL,
    /* num_syn_resources        */  0,
    /* syn_constraint_resources */  NULL,
    /* num_syn_constraint_res   */  0,
    /* parent_process           */  XmInheritParentProcess,
    /* extension                */  NULL,
  },
  {     /* Scrolled window fields */
    /* mumble                   */  0,
  },
  {	/* ScrolledGraphEdit fields */
    /* extension                */  0,
  },
};

WidgetClass scrolledGraphEditWidgetClass = 
    (WidgetClass)&scrolledGraphEditClassRec;

static void Resize(Widget w)
{
    // resize child if it's a graphEdit child
    Widget child = ScrolledGraphEditWidget(w)->swindow.WorkWindow;
    if (child && XtIsSubclass(child, graphEditWidgetClass))
	graphEditSizeChanged(child);

    // call superclass resize method
    scrolledGraphEditClassRec.core_class.superclass->core_class.resize(w);
}

#else // !USE_OWN_SCROLLED_WINDOW

// In Motif 2.0 or later, the definition above crashes.
// Use a standard scrolled window instead.

// Siddharth Ram <srram@qualcomm.com> says this is also the case
// for Motif 1.2 => use this definition all the time.

WidgetClass scrolledGraphEditWidgetClass = xmScrolledWindowWidgetClass;

#endif

Widget createScrolledGraphEdit(Widget parent, String name,
			       ArgList arglist, Cardinal argcount)
{
    Arg args[10];
    int arg = 0;

    XtSetArg(args[arg], XmNscrollingPolicy, XmAUTOMATIC); arg++;
    string swindow_name = string(name) + "_swindow";

    Widget scrolledWindow = 
	verify(XtCreateManagedWidget((char *)swindow_name, 
				     scrolledGraphEditWidgetClass,
				     parent, args, arg));

    return verify(XtCreateManagedWidget(name, graphEditWidgetClass,
					scrolledWindow, arglist, argcount));
}

// For a given graph editor W, return its scroller
Widget scrollerOfGraphEdit(Widget w)
{
    XtCheckSubclass(w, GraphEditWidgetClass, "Bad widget class");

    Widget parent = w;
    while (parent != 0)
    {
	if (XtIsSubclass(parent, scrolledGraphEditWidgetClass))
	    break;
	parent = XtParent(parent);
    }
    return parent;
}
