/* $Id: text-fmt.cc,v 1.7 1997/03/31 21:51:32 dps Exp $ */

/* Everything is declared as static to avoid namespace polution but */
/* is reachable externally via the exported table (and this it the  */
/* only way they get called).					    */
#include <stdio.h>
#include <stdlib.h>
#include "interface.h"
#include "lib.h"
#include "text-table.h"

/* Local data */
struct text_data
{
    text_table *tabl;
    int col;
    int row;
};

/* Most of these values are thanks to catdoc by
 * Victor B. Wagner <vitus@agropc.msk.su> et al */
static const cmap char_map[]=
{
    { 0x1E, "-" },      // Unbreakable join
    { 0x1F, "" },       // Soft hypen
    { 0x85, "..." },    // Dots
    { 0x91, "`" },      // 91 = left quote
    { 0x92, "'" },      // 92 = right quote
    { 0x93, "\"" },     // 93 = opening double quote
    { 0x94, "\"" },     // 94 = closing double quote
    { 0x95, "o " },	// 95 = Bullet
    { 0x96, "-" },      // em-dash
    { 0x97, "-" },      // en-dash
    { 0x99, "(tm)" },   // Trademark
    { 0xA0, " " },      // Unbreakable space
    { 0xA3, "<=" },	// Less than or = came out as A3
    { 0xA9, "(c)" },    // Copyright
    { 0xAB, "<<" },     // Openning << quotes
    { 0xAE, "(R)" },    // Reserved sign
    { 0xB3, ">=" },	// Greater than or = came out as B3
    { 0xBB, ">>" },	// Closing >> quotes
};

/* Allocate local data */
static void *allocate_txt(void)
{
    struct text_data *tdata;

    tdata=new(struct text_data);
    tdata->tabl=NULL;
    return tdata;
}

/* Free local data */
static void free_txt(void *d)
{
    struct text_data *tdata;

    tdata=(struct text_data *) d;
    if (tdata->tabl!=NULL)
	delete(tdata->tabl);
}

/* Paragraphs are easy */
static void fold_para(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		      void *d)
{
    tblock *b, *ts;
    const char *s;

    d=d;			// No need for d
    ts=map_string(t->data.d, char_map);
    b=word_wrap((*ts), "\n", "\n", fmt->maxline, 0);
    delete(ts);
    s=*b;
    fputc('\n', out);
    fputs(s, out);
    fputc('\n', out);
    delete(b);
}

/* Start a table === allocate table and initialise */
static void alloc_tbl(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		      void *d)
{
    struct text_data *tdata;

    out=out;
    fmt=fmt;
    tdata=(struct text_data *) d;
    tdata->col=0;
    tdata->row=0;
    tdata->tabl=new(text_table)(t->data.table.cols, t->data.table.rows);
}


/* End of a table==print the table */
static void format_tbl(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		       void *d)
{
    struct text_data *tdata;

    t=t;
    tdata=(struct text_data *) d;
    tdata->tabl->print_table(fmt->maxline, out); // Print table
    delete(tdata->tabl);
    tdata->tabl=NULL;
}

/* start row==set column to 0 */
static void start_row(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		      void *d)
{ 
    struct text_data *tdata;

    out=out;
    fmt=fmt;
    t=t;
    tdata=(struct text_data *) d;
    tdata->col=0;
}

/* end row==add one to row */
static void inc_row(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		    void *d)
{ 
    struct text_data *tdata;

    out=out;
    fmt=fmt;
    t=t;
    tdata=(struct text_data *) d;
    tdata->row++;
}


/* Start field === set field */
static void set_field(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		      void *d)
{
    struct tblock *ts;
    struct text_data *tdata;

    out=out;
    fmt=fmt;
    ts=map_string(t->data.d, char_map);
    tdata=(struct text_data *) d;
    tdata->tabl->set(tdata->col, tdata->row, (*ts));
    delete(ts);
}

/* end field==add one to col */
static void inc_col(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		    void *d)
{ 
    struct text_data *tdata;

    out=out;
    fmt=fmt;
    t=t;
    tdata=(struct text_data *) d;
    tdata->col++;
}

/* pointers to the functions that do the work */
docfmt txtfmt=
{
    76,				    // Width
    "\n",			    // Use \n as line ends
    allocate_txt,		    // Allocate space
    free_txt,			    // Free text
    {
	{ null_proc, null_proc },   // End and start of document---do nothing
	{ fold_para, null_proc },   // Paragraph
	{ alloc_tbl, format_tbl },  // Start/end table
	{ set_field, inc_col },	    // Start/end field
	{ start_row, inc_row },	    // Start/end row
	{ null_proc, null_proc },   // Throw away embed messages
	{ null_proc, null_proc }    // Do not understanding anything else
    }
};
