/*
 * names.h: Header for names.c
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: names.h,v 1.7 1994/07/30 17:06:30 mrg Exp $
 */

#ifndef _NAMES_H_
#define _NAMES_H_

#include "irc_std.h"
#include "window.h"
#include "irc.h"

/* from names.c - "iklmnpst" */
#define MODE_INVITE	((u_long) 0x0001)
#define MODE_KEY	((u_long) 0x0002)
#define MODE_LIMIT	((u_long) 0x0004)
#define MODE_MODERATED	((u_long) 0x0008)
#define MODE_MSGS	((u_long) 0x0010)
#define MODE_PRIVATE	((u_long) 0x0020)
#define MODE_SECRET	((u_long) 0x0040)
#define MODE_TOPIC	((u_long) 0x0080)

/* ChannelList: structure for the list of channels you are current on */
typedef	struct	channel_stru
{
struct	channel_stru *	next;		/* pointer to next channel entry */
	char *		channel;	/* channel name */
	int		server;		/* server index for this channel */
	u_long		mode;		/* Current mode settings for channel */
	u_long		i_mode;		/* channel mode for cached string */
	char *		s_mode;		/* cached string version of modes */
	int		limit;		/* max users for the channel */
	char *		key;		/* key for this channel */
	char		chop;		/* true if you are chop */
	char		voice;		/* true if you are voiced */
	Window *	window;		/* the window that the channel is "on" */
	NickList *	nicks;		/* pointer to list of nicks on channel */
}	ChannelList;

extern	void		add_channel 		_((char *, int));
extern	void		add_to_channel 		_((char *, char *, int, int, int));
extern	void		change_server_channels 	_((int, int));
extern	char *		channel_key 		_((char *));
extern	void		channel_server_delete 	_((int));
extern	void		clear_channel_list 	_((int));
extern	char *		create_channel_list 	_((Window *));
extern	char *		get_channel_mode 	_((char *, int));
extern	int		get_channel_oper 	_((char *, int));
extern	int		get_channel_voice	_((char *, int));
extern	int		im_on_channel 		_((char *));
extern	int		is_channel_mode 	_((char *, int, int));
extern	int		is_chanop 		_((char *, char *));
extern	int		is_on_channel 		_((char *, char *));
extern	void		list_channels 		_((void));
extern	ChannelList *	lookup_channel 		_((char *, int, int));
extern	char *		real_channel 		_((void));
extern	void		reconnect_all_channels 	_((void));
extern	void		remove_channel 		_((char *, int));
extern	void		remove_from_channel 	_((char *, char *, int));
extern	void		remove_from_mode_list 	_((char *));
extern	void		rename_nick 		_((char *, char *, int));
extern	void		set_channel_window 	_((Window *, char *));
extern	void		set_waiting_channel 	_((int));
extern	void		switch_channels 	_((char, char *));
extern	void		update_channel_mode 	_((char *, char *));
extern	char *		walk_channels 		_((int, char *));
extern	char *		what_channel 		_((char *));

#endif /* _NAMES_H_ */
