#ifndef __HPP_CLAMAV
#define __HPP_CLAMAV

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by Aecio F. Neto (afn@harvest.com.br)
//              Harvest Consultoria (www.harvest.com.br)
//
//  and somewhat hacked by mad@madness.at ;-)
//

#include <clamav.h>
#include <fstream>
#include <string>
#include <syslog.h>
#include <time.h>

#include "VirusEngine.hpp"
#include "OptionContainer.hpp"

using namespace std;

// this class implements the VirusEngine api for clamav/clamscan
//
class ClamEngine:public VirusEngine
{
private:
  const char *virname;
  const char *err_str;
  struct cl_node *root;
  struct cl_limits limits;
  struct cl_stat dbstat;

  string vname;                 // extra virus name field, in case we manually need to set one
  // (e.g. forked scanning needs this; child->parent data handover)
  string errstr;

public:
    ClamEngine ();
    virtual ~ ClamEngine ();

  virtual int loadEngine ();
  virtual int reloadEngine ();
  virtual int unloadEngine ();

  virtual int scanFile (const char *_fname);

  virtual const char *getVirusName ();
  virtual const char *getErrString ();

  virtual void setVirusName (const char *_vname);
  virtual void setErrString (const char *_err_str);
};

#endif
