#!/usr/local/bin/perl
# update.pl
# Find and install updated modules, and email out the result

$no_acl_check++;
require './webmin-lib.pl';

# Get the update source
if ($config{'upsource'}) {
	$config{'upsource'} =~ /^http:\/\/([^:\/]+)(:(\d+))?(\/\S+)$/ ||
		die "Invalid update source URL!";
	$host = $1;
	$port = $2 ? $3 : 80;
	$page = $4;
	}
else {
	$host = $update_host;
	$port = $update_port;
	$page = $update_page;
	}

# Retrieve the updates list (format is  module version url support description )
$temp = &tempname();
&http_download($host, $port, $page, $temp);
open(UPDATES, $temp);
while(<UPDATES>) {
	if (/^([^\t]+)\t+([^\t]+)\t+([^\t]+)\t+([^\t]+)\t+(.*)/) {
		push(@updates, [ $1, $2, $3, $4, $5 ]);
		}
	}
close(UPDATES);
unlink($temp);

# Go through the results
foreach $u (@updates) {
	next if ($u->[1] >= &get_webmin_version() + .01);
	local %minfo = &get_module_info($u->[0]);
	local %tinfo = &get_theme_info($u->[0]);
	if (!%minfo && !%tinfo && !$config{'upmissing'}) {
		$rv .= &text('update_mmissing', $u->[0])."\n"
			if (!$config{'upquiet'});
		next;
		}
	if (%minfo && $minfo{'version'} >= $u->[1]) {
		$rv .= &text('update_malready', $u->[0])."\n"
			if (!$config{'upquiet'});
		next;
		}
	if (%tinfo && $tinfo{'version'} >= $u->[1]) {
		$rv .= &text('update_malready', $u->[0])."\n"
			if (!$config{'upquiet'});
		next;
		}
	local $osinfo = { 'os_support' => $u->[3] };
	if (!&check_os_support($osinfo)) {
		$rv .= &text('update_mos', $u->[0])."\n"
			if (!$config{'upquiet'});
		next;
		}
	if ($config{'upshow'}) {
		# Just tell the user what would be done
		$rv .= &text('update_mshow', $u->[0], $u->[1])."\n$u->[4]\n\n";
		}
	else {
		# Actually do the update ..
		local (@mdescs, @mdirs, @msizes);
		$rv .= &text('update_mok', $u->[0], $u->[1])."\n$u->[4]\n\n";
		if ($u->[2] =~ /^http:\/\/([^:\/]+)(:(\d+))?(\/\S+)$/) {
			$mhost = $1;
			$mport = $2 ? $3 : 80;
			$mpage = $4;
			}
		elsif ($u->[2] =~ /^\/\S+$/) {
			$mhost = $host;
			$mport = $port;
			$mpage = $u->[2];
			}
		else {
			$mhost = $host;
			$mport = $port;
			($mpage = $page) =~ s/[^\/]+$//;
			$mpage .= $u->[2];
			}
		$mtemp = &tempname();
		&http_download($mhost, $mport, $mpage, $mtemp, \$error);
		if ($error) {
			$rv .= "$error\n\n";
			last;
			}
		else {
			&install_webmin_module($mtemp, 1,
					       \@mdescs, \@mdirs, \@msizes);
			$rv .= &text('update_mdesc', $mdescs[0],
				     $msizes[0])."\n\n";
			}
		}
	}

# Check if a new version of webmin itself is available
$file = &tempname();
&http_download('www.webmin.com', 80, '/webmin/', $file);
open(FILE, $file);
while(<FILE>) {
	if (/webmin-([0-9\.]+)\.tar\.gz/) {
		$version = $1;
		last;
		}
	}
close(FILE);
unlink($file);
if ($version > &get_webmin_version()) {
	$rv .= &text('update_version', $version)."\n";
	}

# Send off a results email
if ($config{'upemail'} && $rv) {
	local %sconfig = &foreign_config("sendmail");
	open(MAIL, "|$sconfig{'sendmail_path'} -t");
	print MAIL "From: webmin\n";
	print MAIL "To: $config{'upemail'}\n";
	print MAIL "Subject: $text{'update_subject'}\n";
	print MAIL "\n";
	local $os_type = $gconfig{'real_os_type'} ?
		$gconfig{'real_os_type'} : $gconfig{'os_type'};
	local $os_version = $gconfig{'real_os_version'} ?
		$gconfig{'real_os_version'} : $gconfig{'os_version'};
	print MAIL &get_system_hostname," (",$os_type," ",$os_version,")\n\n";
	print MAIL &text('update_rv', "http://$host:$port$page")."\n\n";
	print MAIL $rv;
	close(MAIL);
	}

