#!/usr/local/bin/perl
# list_access.cgi
# Display a list of all domain and address mappings

require './sendmail-lib.pl';
require './access-lib.pl';
&ReadParse();
$access{'access'} || &error($text{'access_ecannot'});
&header($text{'access_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
$afile = &access_file($conf);
($adbm, $adbmtype) = &access_dbm($conf);
if (!$adbm) {
	# No Kaccess directive in sendmail.cf
	print "<p><b>",&text('access_efeature', 'list_features.cgi'),"</b><p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
if (!-r $afile) {
	# Text file not found
	print "<p><b>",&text('access_efile', "<tt>$afile</tt>",
	      "<tt>$adbm</tt>", "/config.cgi?$module_name"),"</b> <p>\n";
	print "<b>",&text('virtusers_createfile',
		    	  'create_file.cgi?mode=access'),"</b><p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
@accs = &list_access($afile);

&access_form();

if ($in{'search'}) {
	# Restrict to search results
	@accs = grep { $_->{'from'} =~ /$in{'search'}/ } @accs;
	}
elsif ($config{'max_records'} && @accs > $config{'max_records'}) {
	# Show search form
	print $text{'access_toomany'},"<br>\n";
	print "<form action=list_access.cgi>\n";
	print "<input type=submit value='$text{'access_go'}'>\n";
	print "<input name=search size=20></form>\n";
	undef(@accs);
	}

if (@accs) {
	# sort if needed
	if ($config{'sort_mode'} == 1) {
		@accs = sort { $a->{'from'} cmp $b->{'from'} } @accs;
		}

	# render table of access rules
	$mid = int((@accs+1)/2);
	print "<table width=100%> <tr><td width=50% valign=top>\n";
	&accs_table(@accs[0..$mid-1]);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @accs) { &accs_table(@accs[$mid..$#accs]); }
	print "</td></tr> </table><br>\n";
	}
print "<a href='edit_file.cgi?mode=access'>",
	&text('file_edit', "<tt>$afile</tt>"),"</a><p>\n";
print $text{'access_desc1'},"<p>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub accs_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'access_source'}</b></td> ",
      "<td><b>$text{'access_action'}</b></td> </tr>\n";
foreach $m (@_) {
	print "<tr $cb> <td><a href=\"edit_access.cgi?num=$m->{'num'}\">",
	      &html_escape($m->{'from'}),"</a></td>\n";
	print "<td>",&html_escape($m->{'action'}),"</td> </tr>\n";
	}
print "</table>\n";
}

