#!/usr/local/bin/perl
# view_raid.cgi
# Display information about a raid device

require './raid-lib.pl';
&foreign_require("fdisk", "fdisk-lib.pl");
&foreign_require("mount", "mount-lib.pl");
&ReadParse();

&header($text{'view_title'}, "");
$conf = &get_raidtab();
$raid = $conf->[$in{'idx'}];
print "<hr>\n";

# Find mounted partitions
foreach $m (&foreign_call("mount", "list_mounted")) {
	$mounted{$m->[1]} = $m->[0];
	}

print "<form action=save_raid.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'view_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'view_device'}</b></td>\n";
print "<td><tt>$raid->{'value'}</tt></td> </tr>\n";

$lvl = &find_value('raid-level', $raid->{'members'});
print "<tr> <td><b>$text{'view_level'}</b></td>\n";
print "<td>",$lvl eq 'linear' ? $text{'linear'}
			      : $text{"raid$lvl"},"</td> </tr>\n";

$m = $mounted{$raid->{'value'}};
print "<tr> <td><b>$text{'view_status'}</b></td> <td>\n";
print $m ? &text('view_mounted', "<tt>$m</tt>") :
      $raid->{'active'} ? $text{'view_active'} :
			  $text{'view_inactive'};
print "</td> </tr>\n";

if ($raid->{'size'}) {
	print "<tr> <td><b>$text{'view_size'}</b></td>\n";
	print "<td>$raid->{'size'} blocks</td> </tr>\n";
	}
if ($raid->{'resync'}) {
	print "<tr> <td><b>$text{'view_resync'}</b></td>\n";
	print "<td>$raid->{'resync'} \%</td> </tr>\n";
	}

$super = &find_value('persistent-superblock', $raid->{'members'});
print "<tr> <td><b>$text{'view_super'}</b></td>\n";
print "<td>",$super ? $text{'yes'} : $text{'no'},"</td> </tr>\n";

if ($lvl eq '5') {
	$parity = &find_value('parity-algorithm', $raid->{'members'});
	print "<tr> <td><b>$text{'view_parity'}</b></td>\n";
	print "<td>",$parity ? $parity : $text{'default'},"</td> </tr>\n";
	}

$chunk = &find_value('chunk-size', $raid->{'members'});
print "<tr> <td><b>$text{'view_chunk'}</b></td>\n";
print "<td>$chunk kB</td> </tr>\n";

# Display partitions in RAID
print "<tr> <td valign=top><b>$text{'view_disks'}</b></td> <td>\n";
foreach $d (&find('device', $raid->{'members'})) {
	if (&find('raid-disk', $d->{'members'}) ||
            &find('parity-disk', $d->{'members'})) {
		if ($d->{'value'} =~ /(h|s)d(\S+)(\d+)$/) {
			print &text('select_part', $1 eq 'h' ? 'IDE' : 'SCSI',
				    uc($2), "$3"),"\n";
			}
		elsif ($d->{'value'} =~ /rd\/c(\d+)d(\d+)p(\d+)$/) {
			print &text('select_mpart', "$1", "$2", "$3");
			}
		elsif ($d->{'value'} =~ /ida\/c(\d+)d(\d+)p(\d+)$/) {
			print &text('select_cpart', "$1", "$2", "$3");
			}
		else {
			print $d->{'value'},"\n";
			}
		if (&indexof($d->{'value'}, @{$raid->{'devices'}}) < 0 &&
		    $raid->{'active'}) {
			print "<font color=#ff0000>$text{'view_down'}</font>\n";
			}
		print "<br>\n";
		}
	}
print "</td> </tr>\n";

# Display spare partitions
foreach $d (&find('device', $raid->{'members'})) {
	if (&find('spare-disk', $d->{'members'})) {
		if ($d->{'value'} =~ /(h|s)d(\S+)(\d+)$/) {
			$sp .= &text('select_part', $1 eq 'h' ? 'IDE' : 'SCSI',
				    uc($2), "$3")."<br>\n";
			}
		else {
			$sp .= $d->{'value'}."<br>\n";
			}
		}
	}
if ($sp) {
	print "<tr> <td valign=top><b>$text{'view_spares'}</b></td> <td>\n";
	print $sp,"</td> </tr>\n";
	}

print "</table></td></tr></table>\n";

if ($mounted{$raid->{'value'}}) {
	print "<br><b>$text{'view_cannot'}</b> <p>\n";
	}
else {
	if ($raid->{'active'}) {
		print "<input type=submit name=stop ",
		      "value='$text{'view_stop'}'>&nbsp;\n";
		}
	else {
		print "<input type=submit name=start ",
		      "value='$text{'view_start'}'>&nbsp;\n";
		}
	print "<input type=submit name=delete value='$text{'delete'}'>&nbsp;\n";
	if ($raid->{'active'}) {
		print "<input type=submit name=mkfs ",
		      "value='$text{'view_mkfs'}'>&nbsp;\n";
		}
	}
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

