# log_parser.pl
# Functions for parsing this module's logs

do './raid-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p) = @_;
$object = &html_escape($object);
if ($action eq 'create') {
	return &text('log_create', $text{$p->{'level'}}, "<tt>$object</tt>");
	}
elsif ($action eq 'stop') {
	return &text('log_stop', "<tt>$object</tt>");
	}
elsif ($action eq 'start') {
	return &text('log_start', "<tt>$object</tt>");
	}
elsif ($action eq 'delete') {
	return &text('log_delete', "<tt>$object</tt>");
	}
elsif ($action eq 'mkfs') {
	return &text('log_mkfs', "<tt>EXT2</tt>", "<tt>$object</tt>");
	}
else {
	return undef;
	}
}

